/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import java.util.concurrent.locks.LockSupport;

public interface BlockingStrategy {
    public static final BlockingStrategy PARKING = new BlockingStrategy(){

        @Override
        public void park(long nanosToPark) throws InterruptedException {
            long endNanos = System.nanoTime() + nanosToPark;
            long remainingParkNanos = nanosToPark;
            do {
                remainingParkNanos = this.parkAndCalculateRemaining(remainingParkNanos, endNanos);
                if (!Thread.interrupted()) continue;
                throw new InterruptedException();
            } while (remainingParkNanos > 0L);
        }

        @Override
        public void parkUninterruptibly(long nanosToPark) {
            long endNanos = System.nanoTime() + nanosToPark;
            long remainingParkNanos = nanosToPark;
            boolean interrupted = false;
            try {
                while (true) {
                    if ((remainingParkNanos = this.parkAndCalculateRemaining(remainingParkNanos, endNanos)) <= 0L) {
                        return;
                    }
                    if (!Thread.interrupted()) continue;
                    interrupted = true;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private long parkAndCalculateRemaining(long remainingParkNanos, long endNanos) {
            LockSupport.parkNanos(remainingParkNanos);
            long currentTimeNanos = System.nanoTime();
            return endNanos - currentTimeNanos;
        }
    };

    public void park(long var1) throws InterruptedException;

    public void parkUninterruptibly(long var1);
}

