/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.TimeMeter;
import java.util.concurrent.atomic.AtomicReference;

public class LockFreeBucket
extends AbstractBucket {
    private final BucketConfiguration configuration;
    private final Bandwidth[] bandwidths;
    private final TimeMeter timeMeter;
    private final AtomicReference<BucketState> stateReference;

    public LockFreeBucket(BucketConfiguration configuration) {
        this.configuration = configuration;
        this.bandwidths = configuration.getBandwidths();
        this.timeMeter = configuration.getTimeMeter();
        BucketState initialState = BucketState.createInitialState(configuration);
        this.stateReference = new AtomicReference<BucketState>(initialState);
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens(this.bandwidths);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            newState.consume(this.bandwidths, toConsume);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                return toConsume;
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            newState.consume(this.bandwidths, tokensToConsume);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                return true;
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = newState.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = newState.delayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume);
                return ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill);
            }
            newState.consume(this.bandwidths, tokensToConsume);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                return ConsumptionProbe.consumed(availableToConsume - tokensToConsume);
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyNanosLimit, boolean uninterruptibly, BlockingStrategy blockingStrategy) throws InterruptedException {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long nanosToCloseDeficit = newState.delayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume);
            if (nanosToCloseDeficit == 0L) {
                newState.consume(this.bandwidths, tokensToConsume);
                if (this.stateReference.compareAndSet(previousState, newState)) {
                    return true;
                }
                previousState = this.stateReference.get();
                newState.copyStateFrom(previousState);
                continue;
            }
            if (waitIfBusyNanosLimit > 0L && nanosToCloseDeficit > waitIfBusyNanosLimit) {
                return false;
            }
            newState.consume(this.bandwidths, tokensToConsume);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                this.park(blockingStrategy, nanosToCloseDeficit, uninterruptibly);
                return true;
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    private void park(BlockingStrategy blockingStrategy, long nanosToCloseDeficit, boolean uninterruptibly) throws InterruptedException {
        if (uninterruptibly) {
            blockingStrategy.parkUninterruptibly(nanosToCloseDeficit);
        } else {
            blockingStrategy.park(nanosToCloseDeficit);
        }
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        BucketState previousState = this.stateReference.get();
        BucketState newState = previousState.copy();
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        while (true) {
            newState.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            newState.addTokens(this.bandwidths, tokensToAdd);
            if (this.stateReference.compareAndSet(previousState, newState)) {
                return;
            }
            previousState = this.stateReference.get();
            newState.copyStateFrom(previousState);
        }
    }

    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        BucketState snapshot = this.stateReference.get().copy();
        snapshot.refillAllBandwidth(this.bandwidths, currentTimeNanos);
        return snapshot.getAvailableTokens(this.bandwidths);
    }

    @Override
    public BucketState createSnapshot() {
        return this.stateReference.get().copy();
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "LockFreeBucket{state=" + this.stateReference.get() + ", configuration=" + this.getConfiguration() + '}';
    }
}

