/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.ConfigurationBuilder;
import io.github.bucket4j.local.FakeLock;
import io.github.bucket4j.local.LockFreeBucket;
import io.github.bucket4j.local.SynchronizationStrategy;
import io.github.bucket4j.local.SynchronizedBucket;

public class LocalBucketBuilder
extends ConfigurationBuilder<LocalBucketBuilder> {
    public Bucket build() {
        return this.build(SynchronizationStrategy.LOCK_FREE);
    }

    public Bucket build(SynchronizationStrategy synchronizationStrategy) {
        BucketConfiguration configuration = this.buildConfiguration();
        switch (synchronizationStrategy) {
            case LOCK_FREE: {
                return new LockFreeBucket(configuration);
            }
            case SYNCHRONIZED: {
                return new SynchronizedBucket(configuration);
            }
            case NONE: {
                return new SynchronizedBucket(configuration, FakeLock.INSTANCE);
            }
        }
        throw new IllegalStateException();
    }
}

