/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.TimeMeter;

public class UnsafeBucket
extends AbstractBucket {
    private final BucketConfiguration configuration;
    private final Bandwidth[] bandwidths;
    private final TimeMeter timeMeter;
    private final BucketState state;

    public UnsafeBucket(BucketConfiguration configuration) {
        this.configuration = configuration;
        this.bandwidths = configuration.getBandwidths();
        this.timeMeter = configuration.getTimeMeter();
        this.state = BucketState.createInitialState(configuration);
    }

    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
        long toConsume = Math.min(limit, availableToConsume);
        if (toConsume == 0L) {
            return 0L;
        }
        this.state.consume(this.bandwidths, toConsume);
        return toConsume;
    }

    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
        long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
        if (tokensToConsume > availableToConsume) {
            return false;
        }
        this.state.consume(this.bandwidths, tokensToConsume);
        return true;
    }

    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyNanosLimit, boolean uninterruptibly, BlockingStrategy blockingStrategy) throws InterruptedException {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
        long nanosToCloseDeficit = this.state.delayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume);
        if (nanosToCloseDeficit == 0L) {
            this.state.consume(this.bandwidths, tokensToConsume);
            return true;
        }
        if (waitIfBusyNanosLimit > 0L && nanosToCloseDeficit > waitIfBusyNanosLimit) {
            return false;
        }
        this.state.consume(this.bandwidths, tokensToConsume);
        if (uninterruptibly) {
            blockingStrategy.parkUninterruptibly(nanosToCloseDeficit);
        } else {
            blockingStrategy.park(nanosToCloseDeficit);
        }
        return true;
    }

    @Override
    protected void addTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
        this.state.addTokens(this.bandwidths, tokensToAdd);
    }

    @Override
    public BucketState createSnapshot() {
        return this.state.clone();
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "LockFreeBucket{state=" + this.state + ", configuration=" + this.getConfiguration() + '}';
    }
}

