/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.TimeMeter;

public class SynchronizedBucket
extends AbstractBucket {
    private final BucketConfiguration configuration;
    private final Bandwidth[] bandwidths;
    private final TimeMeter timeMeter;
    private final BucketState state;

    public SynchronizedBucket(BucketConfiguration configuration) {
        this.configuration = configuration;
        this.bandwidths = configuration.getBandwidths();
        this.timeMeter = configuration.getTimeMeter();
        this.state = BucketState.createInitialState(configuration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                return 0L;
            }
            this.state.consume(this.bandwidths, toConsume);
            return toConsume;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                return false;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyNanosLimit, boolean uninterruptibly, BlockingStrategy blockingStrategy) throws InterruptedException {
        long nanosToCloseDeficit;
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            nanosToCloseDeficit = this.state.delayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume);
            if (nanosToCloseDeficit == 0L) {
                this.state.consume(this.bandwidths, tokensToConsume);
                return true;
            }
            if (waitIfBusyNanosLimit > 0L && nanosToCloseDeficit > waitIfBusyNanosLimit) {
                return false;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
        }
        if (uninterruptibly) {
            blockingStrategy.parkUninterruptibly(nanosToCloseDeficit);
        } else {
            blockingStrategy.park(nanosToCloseDeficit);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state.addTokens(this.bandwidths, tokensToAdd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BucketState createSnapshot() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return this.state.clone();
        }
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return "SynchronizedBucket{state=" + this.state + ", configuration=" + this.getConfiguration() + '}';
        }
    }
}

