/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthDefinition;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationBuilder<T extends ConfigurationBuilder> {
    private TimeMeter timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
    private List<BandwidthDefinition> bandwidths = new ArrayList<BandwidthDefinition>(1);

    protected ConfigurationBuilder() {
    }

    public BucketConfiguration buildConfiguration() {
        return new BucketConfiguration(this.bandwidths, this.timeMeter);
    }

    public T addLimit(Bandwidth bandwidth) {
        this.bandwidths.add(BandwidthDefinition.unspecifiedInitialTokens(bandwidth));
        return (T)this;
    }

    public T addLimit(long initialTokens, Bandwidth bandwidth) {
        this.bandwidths.add(BandwidthDefinition.withInitialTokens(bandwidth, initialTokens));
        return (T)this;
    }

    public T withNanosecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_NANOTIME;
        return (T)this;
    }

    public T withMillisecondPrecision() {
        this.timeMeter = TimeMeter.SYSTEM_MILLISECONDS;
        return (T)this;
    }

    public T withCustomTimePrecision(TimeMeter customTimeMeter) {
        if (customTimeMeter == null) {
            throw BucketExceptions.nullTimeMeter();
        }
        this.timeMeter = customTimeMeter;
        return (T)this;
    }

    public String toString() {
        return "AbstractBucketBuilder{timeMeter=" + this.timeMeter + ", bandwidths=" + this.bandwidths + '}';
    }
}

