/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import java.util.concurrent.locks.LockSupport;

public interface BlockingStrategy {
    public static final BlockingStrategy PARKING = new BlockingStrategy(){

        @Override
        public void park(long nanosToPark) throws InterruptedException {
            long endNanos = System.nanoTime() + nanosToPark;
            while (true) {
                LockSupport.parkNanos(nanosToPark);
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                long currentTimeNanos = System.nanoTime();
                if (currentTimeNanos - endNanos >= 0L) {
                    return;
                }
                nanosToPark = endNanos - currentTimeNanos;
            }
        }

        @Override
        public void parkUninterruptibly(long nanosToPark) {
            long endNanos = System.nanoTime() + nanosToPark;
            boolean interrupted = Thread.interrupted();
            try {
                while (true) {
                    long currentTimeNanos;
                    LockSupport.parkNanos(nanosToPark);
                    if (Thread.interrupted()) {
                        interrupted = true;
                    }
                    if ((currentTimeNanos = System.nanoTime()) - endNanos >= 0L) {
                        return;
                    }
                    nanosToPark = endNanos - currentTimeNanos;
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    };

    public void park(long var1) throws InterruptedException;

    public void parkUninterruptibly(long var1);
}

