/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.Bucket;
import io.github.bucket4j.BucketExceptions;

public abstract class AbstractBucket
implements Bucket {
    protected static final long UNSPECIFIED_WAITING_LIMIT = -1L;

    protected abstract long consumeAsMuchAsPossibleImpl(long var1);

    protected abstract boolean tryConsumeImpl(long var1);

    protected abstract boolean consumeOrAwaitImpl(long var1, long var3, boolean var5, BlockingStrategy var6) throws InterruptedException;

    protected abstract void addTokensImpl(long var1);

    @Override
    public boolean tryConsume(long tokensToConsume) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        return this.tryConsumeImpl(tokensToConsume);
    }

    @Override
    public void consume(long tokensToConsume, BlockingStrategy blockingStrategy) throws InterruptedException {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        this.consumeOrAwaitImpl(tokensToConsume, -1L, false, blockingStrategy);
    }

    @Override
    public boolean consume(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) throws InterruptedException {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        if (maxWaitTimeNanos <= 0L) {
            throw BucketExceptions.nonPositiveNanosToWait(maxWaitTimeNanos);
        }
        return this.consumeOrAwaitImpl(tokensToConsume, maxWaitTimeNanos, false, blockingStrategy);
    }

    @Override
    public void consumeUninterruptibly(long tokensToConsume, BlockingStrategy blockingStrategy) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        try {
            this.consumeOrAwaitImpl(tokensToConsume, -1L, true, blockingStrategy);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Should never come here", e);
        }
    }

    @Override
    public boolean consumeUninterruptibly(long tokensToConsume, long maxWaitTimeNanos, BlockingStrategy blockingStrategy) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
        if (maxWaitTimeNanos <= 0L) {
            throw BucketExceptions.nonPositiveNanosToWait(maxWaitTimeNanos);
        }
        try {
            return this.consumeOrAwaitImpl(tokensToConsume, maxWaitTimeNanos, true, blockingStrategy);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Should never come here", e);
        }
    }

    @Override
    public long tryConsumeAsMuchAsPossible(long limit) {
        if (limit <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(limit);
        }
        return this.consumeAsMuchAsPossibleImpl(limit);
    }

    @Override
    public long tryConsumeAsMuchAsPossible() {
        return this.consumeAsMuchAsPossibleImpl(Long.MAX_VALUE);
    }

    @Override
    public void addTokens(long tokensToAdd) {
        if (tokensToAdd <= 0L) {
            throw new IllegalArgumentException("tokensToAdd should be >= 0");
        }
        this.addTokensImpl(tokensToAdd);
    }
}

