/*
 * Decompiled with CFR 0.152.
 */
package com.github.vivchar.rendererrecyclerviewadapter;

import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.github.vivchar.rendererrecyclerviewadapter.BaseViewRenderer;
import com.github.vivchar.rendererrecyclerviewadapter.CompositeViewHolder;
import com.github.vivchar.rendererrecyclerviewadapter.CompositeViewModel;
import com.github.vivchar.rendererrecyclerviewadapter.CompositeViewStateProvider;
import com.github.vivchar.rendererrecyclerviewadapter.RendererRecyclerViewAdapter;
import com.github.vivchar.rendererrecyclerviewadapter.ViewFinder;
import com.github.vivchar.rendererrecyclerviewadapter.ViewModel;
import com.github.vivchar.rendererrecyclerviewadapter.ViewRenderer;
import com.github.vivchar.rendererrecyclerviewadapter.ViewState;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeViewRenderer<M extends CompositeViewModel, VF extends ViewFinder>
extends BaseViewRenderer<M, VF, CompositeViewHolder<VF>> {
    @IdRes
    protected final int mRecyclerViewID;
    @NonNull
    protected final List<RecyclerView.ItemDecoration> mDecorations = new ArrayList<RecyclerView.ItemDecoration>();
    @Nullable
    protected CompositeViewStateProvider<M, CompositeViewHolder<VF>> mViewStateProvider = null;
    @NonNull
    protected final ArrayList<BaseViewRenderer> mRenderers = new ArrayList();
    @Nullable
    protected RecyclerView.RecycledViewPool mRecycledViewPool;

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type, @NonNull BaseViewRenderer.Binder<M, VF> binder, @NonNull List<? extends RecyclerView.ItemDecoration> decorations, @Nullable CompositeViewStateProvider<M, CompositeViewHolder<VF>> viewStateProvider) {
        super(layoutID, type, binder);
        this.mRecyclerViewID = recyclerViewID;
        this.mViewStateProvider = viewStateProvider;
        this.mDecorations.addAll(decorations);
    }

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type, @NonNull BaseViewRenderer.Binder<M, VF> binder) {
        super(layoutID, type, binder);
        this.mRecyclerViewID = recyclerViewID;
    }

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type, @NonNull BaseViewRenderer.Binder<M, VF> binder, ViewRenderer ... renderers) {
        super(layoutID, type, binder);
        this.mRecyclerViewID = recyclerViewID;
        Collections.addAll(this.mRenderers, renderers);
    }

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type) {
        this(layoutID, recyclerViewID, type, new BaseViewRenderer.Binder<M, VF>(){

            @Override
            public void bindView(@NonNull M model, @NonNull VF finder, @NonNull List<Object> payloads) {
            }
        });
    }

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type, @NonNull List<? extends RecyclerView.ItemDecoration> decorations) {
        this(layoutID, recyclerViewID, type);
        this.mDecorations.addAll(decorations);
    }

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type, @Nullable CompositeViewStateProvider<M, CompositeViewHolder<VF>> viewStateProvider) {
        this(layoutID, recyclerViewID, type);
        this.mViewStateProvider = viewStateProvider;
    }

    public CompositeViewRenderer(int layoutID, @IdRes int recyclerViewID, @NonNull Class<M> type, @NonNull List<? extends RecyclerView.ItemDecoration> decorations, @Nullable CompositeViewStateProvider<M, CompositeViewHolder<VF>> viewStateProvider) {
        this(layoutID, recyclerViewID, type);
        this.mViewStateProvider = viewStateProvider;
        this.mDecorations.addAll(decorations);
    }

    @Override
    public void rebindView(@NonNull M model, @NonNull CompositeViewHolder<VF> holder, @NonNull List<Object> payloads) {
        super.rebindView(model, holder, payloads);
        this.bindAdapterItems(holder.getAdapter(), model.getItems());
    }

    @Override
    protected void bindView(@NonNull M model, @NonNull CompositeViewHolder<VF> holder) {
        super.bindView(model, holder);
        this.bindAdapterItems(holder.getAdapter(), model.getItems());
    }

    protected void bindAdapterItems(@NonNull RendererRecyclerViewAdapter adapter, @NonNull List<? extends ViewModel> models) {
        adapter.setItems(models);
        adapter.notifyDataSetChanged();
    }

    @Override
    @NonNull
    protected CompositeViewHolder<VF> performCreateViewHolder(@NonNull ViewGroup parent) {
        RendererRecyclerViewAdapter adapter = this.createAdapter();
        for (BaseViewRenderer renderer : this.mRenderers) {
            adapter.registerRenderer(renderer);
        }
        CompositeViewHolder viewHolder = (CompositeViewHolder)((Object)super.performCreateViewHolder(parent));
        viewHolder.setAdapter(adapter);
        if (viewHolder.getRecyclerView() != null) {
            viewHolder.getRecyclerView().setLayoutManager(this.createLayoutManager());
            viewHolder.getRecyclerView().setAdapter((RecyclerView.Adapter)adapter);
            viewHolder.getRecyclerView().setRecycledViewPool(this.mRecycledViewPool);
            for (RecyclerView.ItemDecoration itemDecoration : this.createItemDecorations()) {
                viewHolder.getRecyclerView().addItemDecoration(itemDecoration);
            }
        }
        return viewHolder;
    }

    @Override
    @NonNull
    public CompositeViewHolder<VF> createViewHolder(@NonNull ViewGroup parent) {
        return new CompositeViewHolder(this.mRecyclerViewID, this.inflate(this.mLayoutID, parent));
    }

    @NonNull
    public CompositeViewRenderer registerRenderer(@NonNull BaseViewRenderer renderer) {
        this.mRenderers.add(renderer);
        return this;
    }

    @Override
    @Nullable
    public ViewState createViewState() {
        return super.createViewState();
    }

    @NonNull
    protected RecyclerView.LayoutManager createLayoutManager() {
        return new LinearLayoutManager(this.getContext(), 0, false);
    }

    @NonNull
    protected RendererRecyclerViewAdapter createAdapter() {
        return new RendererRecyclerViewAdapter();
    }

    @NonNull
    protected List<? extends RecyclerView.ItemDecoration> createItemDecorations() {
        return this.mDecorations;
    }

    @NonNull
    public CompositeViewRenderer<M, VF> setRecycledViewPool(@Nullable RecyclerView.RecycledViewPool pool) {
        this.mRecycledViewPool = pool;
        return this;
    }
}

