package com.pvitaliy.validationtext

import androidx.annotation.StringRes

abstract class ValidationException : Exception()

open class ErrorCodeException(
    open val errorCode: Int,
    vararg val args: Any?
) : ValidationException()


open class StringException(val reason: String) : ValidationException()

open class ResException(
    @StringRes val resString: Int,
    vararg val args: Any?
) : ValidationException()