/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb.managers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import se.vidstige.jadb.JadbDevice;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFile;
import se.vidstige.jadb.Stream;
import se.vidstige.jadb.managers.Package;

public class PackageManager {
    private final JadbDevice device;
    public static final InstallOption WITH_FORWARD_LOCK = new InstallOption("-l");
    public static final InstallOption REINSTALL_KEEPING_DATA = new InstallOption("-r");
    public static final InstallOption ALLOW_TEST_APK = new InstallOption("-t");
    public static final InstallOption ALLOW_VERSION_DOWNGRADE = new InstallOption("-d");
    public static final InstallOption GRANT_ALL_PERMISSIONS = new InstallOption("-g");

    public PackageManager(JadbDevice device) {
        this.device = device;
    }

    public List<Package> getPackages() throws IOException, JadbException {
        try (BufferedReader input = new BufferedReader(new InputStreamReader(this.device.executeShell("pm", "list", "packages"), StandardCharsets.UTF_8));){
            String line;
            ArrayList<Package> result = new ArrayList<Package>();
            while ((line = input.readLine()) != null) {
                String prefix = "package:";
                if (!line.startsWith("package:")) continue;
                result.add(new Package(line.substring("package:".length())));
            }
            ArrayList<Package> arrayList = result;
            return arrayList;
        }
    }

    private String getErrorMessage(String operation, String target, String errorMessage) {
        return "Could not " + operation + " " + target + ": " + errorMessage;
    }

    private void verifyOperation(String operation, String target, String result) throws JadbException {
        if (!result.contains("Success")) {
            throw new JadbException(this.getErrorMessage(operation, target, result));
        }
    }

    private void remove(RemoteFile file) throws IOException, JadbException {
        InputStream s = this.device.executeShell("rm", "-f", file.getPath());
        Stream.readAll(s, StandardCharsets.UTF_8);
    }

    private void install(File apkFile, List<String> extraArguments) throws IOException, JadbException {
        RemoteFile remote = new RemoteFile("/data/local/tmp/" + apkFile.getName());
        this.device.push(apkFile, remote);
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("install");
        arguments.addAll(extraArguments);
        arguments.add(remote.getPath());
        InputStream s = this.device.executeShell("pm", arguments.toArray(new String[0]));
        String result = Stream.readAll(s, StandardCharsets.UTF_8);
        this.remove(remote);
        this.verifyOperation("install", apkFile.getName(), result);
    }

    public void install(File apkFile) throws IOException, JadbException {
        this.install(apkFile, new ArrayList<String>(0));
    }

    public void installWithOptions(File apkFile, List<? extends InstallOption> options) throws IOException, JadbException {
        ArrayList<String> optionsAsStr = new ArrayList<String>(options.size());
        for (InstallOption installOption : options) {
            optionsAsStr.add(installOption.getStringRepresentation());
        }
        this.install(apkFile, optionsAsStr);
    }

    public void forceInstall(File apkFile) throws IOException, JadbException {
        this.installWithOptions(apkFile, Collections.singletonList(REINSTALL_KEEPING_DATA));
    }

    public void uninstall(Package name) throws IOException, JadbException {
        InputStream s = this.device.executeShell("pm", "uninstall", name.toString());
        String result = Stream.readAll(s, StandardCharsets.UTF_8);
        this.verifyOperation("uninstall", name.toString(), result);
    }

    public void launch(Package name) throws IOException, JadbException {
        InputStream s = this.device.executeShell("monkey", "-p", name.toString(), "-c", "android.intent.category.LAUNCHER", "1");
        s.close();
    }

    public static InstallOption WITH_INSTALLER_PACKAGE_NAME(String name) {
        return new InstallOption("-t", name);
    }

    public static InstallOption ON_SHARED_MASS_STORAGE(String name) {
        return new InstallOption("-s", name);
    }

    public static InstallOption ON_INTERNAL_SYSTEM_MEMORY(String name) {
        return new InstallOption("-f", name);
    }

    public static class InstallOption {
        private final StringBuilder stringBuilder = new StringBuilder();

        InstallOption(String ... varargs) {
            String suffix = "";
            for (String str : varargs) {
                this.stringBuilder.append(suffix).append(str);
                suffix = " ";
            }
        }

        private String getStringRepresentation() {
            return this.stringBuilder.toString();
        }
    }
}

