/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.IOException;
import java.net.InetSocketAddress;
import se.vidstige.jadb.ConnectionToRemoteDeviceException;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.Transport;

class HostConnectToRemoteTcpDevice {
    private final Transport transport;
    private final ResponseValidator responseValidator;

    HostConnectToRemoteTcpDevice(Transport transport) {
        this.transport = transport;
        this.responseValidator = new ResponseValidatorImp();
    }

    HostConnectToRemoteTcpDevice(Transport transport, ResponseValidator responseValidator) {
        this.transport = transport;
        this.responseValidator = responseValidator;
    }

    InetSocketAddress connect(InetSocketAddress inetSocketAddress) throws IOException, JadbException, ConnectionToRemoteDeviceException {
        this.transport.send(String.format("host:connect:%s:%d", inetSocketAddress.getHostString(), inetSocketAddress.getPort()));
        this.verifyTransportLevel();
        this.verifyProtocolLevel();
        return inetSocketAddress;
    }

    private void verifyTransportLevel() throws IOException, JadbException {
        this.transport.verifyResponse();
    }

    private void verifyProtocolLevel() throws IOException, ConnectionToRemoteDeviceException {
        String status = this.transport.readString();
        this.responseValidator.validate(status);
    }

    static final class ResponseValidatorImp
    implements ResponseValidator {
        private static final String SUCCESSFULLY_CONNECTED = "connected to";
        private static final String ALREADY_CONNECTED = "already connected to";

        ResponseValidatorImp() {
        }

        @Override
        public void validate(String response) throws ConnectionToRemoteDeviceException {
            if (!this.checkIfConnectedSuccessfully(response) && !this.checkIfAlreadyConnected(response)) {
                throw new ConnectionToRemoteDeviceException(this.extractError(response));
            }
        }

        private boolean checkIfConnectedSuccessfully(String response) {
            return response.startsWith(SUCCESSFULLY_CONNECTED);
        }

        private boolean checkIfAlreadyConnected(String response) {
            return response.startsWith(ALREADY_CONNECTED);
        }

        private String extractError(String response) {
            int lastColon = response.lastIndexOf(":");
            if (lastColon != -1) {
                return response.substring(lastColon, response.length());
            }
            return response;
        }
    }

    static interface ResponseValidator {
        public void validate(String var1) throws ConnectionToRemoteDeviceException;
    }
}

