/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import se.vidstige.jadb.AdbFilterInputStream;
import se.vidstige.jadb.AdbFilterOutputStream;
import se.vidstige.jadb.ITransportFactory;
import se.vidstige.jadb.JadbConnection;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFile;
import se.vidstige.jadb.RemoteFileRecord;
import se.vidstige.jadb.SyncTransport;
import se.vidstige.jadb.Transport;
import se.vidstige.jadb.managers.Bash;

public class JadbDevice {
    private final String serial;
    private final ITransportFactory transportFactory;

    JadbDevice(String serial, String type, ITransportFactory tFactory) {
        this.serial = serial;
        this.transportFactory = tFactory;
    }

    static JadbDevice createAny(JadbConnection connection) {
        return new JadbDevice(connection);
    }

    private JadbDevice(ITransportFactory tFactory) {
        this.serial = null;
        this.transportFactory = tFactory;
    }

    private Transport getTransport() throws IOException, JadbException {
        Transport transport = this.transportFactory.createTransport();
        if (this.serial == null) {
            transport.send("host:transport-any");
            transport.verifyResponse();
        } else {
            transport.send("host:transport:" + this.serial);
            transport.verifyResponse();
        }
        return transport;
    }

    public String getSerial() {
        return this.serial;
    }

    public String getState() throws IOException, JadbException {
        Transport transport = this.getTransport();
        transport.send("get-state");
        transport.verifyResponse();
        return transport.readString();
    }

    public InputStream executeShell(String command, String ... args) throws IOException, JadbException {
        Transport transport = this.getTransport();
        StringBuilder shellLine = new StringBuilder(command);
        for (String arg : args) {
            shellLine.append(" ");
            shellLine.append(Bash.quote(arg));
        }
        this.send(transport, "shell:" + shellLine.toString());
        return new AdbFilterInputStream(new BufferedInputStream(transport.getInputStream()));
    }

    @Deprecated
    public void executeShell(OutputStream output, String command, String ... args) throws IOException, JadbException {
        Transport transport = this.getTransport();
        StringBuilder shellLine = new StringBuilder(command);
        for (String arg : args) {
            shellLine.append(" ");
            shellLine.append(Bash.quote(arg));
        }
        this.send(transport, "shell:" + shellLine.toString());
        if (output != null) {
            transport.readResponseTo(new AdbFilterOutputStream(output));
        }
    }

    public List<RemoteFile> list(String remotePath) throws IOException, JadbException {
        Transport transport = this.getTransport();
        SyncTransport sync = transport.startSync();
        sync.send("LIST", remotePath);
        ArrayList<RemoteFile> result = new ArrayList<RemoteFile>();
        RemoteFileRecord dent = sync.readDirectoryEntry();
        while (dent != RemoteFileRecord.DONE) {
            result.add(dent);
            dent = sync.readDirectoryEntry();
        }
        return result;
    }

    private int getMode(File file) {
        return 436;
    }

    public void push(InputStream source, long lastModified, int mode, RemoteFile remote) throws IOException, JadbException {
        Transport transport = this.getTransport();
        SyncTransport sync = transport.startSync();
        sync.send("SEND", remote.getPath() + "," + Integer.toString(mode));
        sync.sendStream(source);
        sync.sendStatus("DONE", (int)lastModified);
        sync.verifyStatus();
    }

    public void push(File local, RemoteFile remote) throws IOException, JadbException {
        FileInputStream fileStream = new FileInputStream(local);
        this.push(fileStream, local.lastModified(), this.getMode(local), remote);
        fileStream.close();
    }

    public void pull(RemoteFile remote, OutputStream destination) throws IOException, JadbException {
        Transport transport = this.getTransport();
        SyncTransport sync = transport.startSync();
        sync.send("RECV", remote.getPath());
        sync.readChunksTo(destination);
    }

    public void pull(RemoteFile remote, File local) throws IOException, JadbException {
        FileOutputStream fileStream = new FileOutputStream(local);
        this.pull(remote, fileStream);
        fileStream.close();
    }

    private void send(Transport transport, String command) throws IOException, JadbException {
        transport.send(command);
        transport.verifyResponse();
    }

    public String toString() {
        return "Android Device with serial " + this.serial;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serial == null ? 0 : this.serial.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JadbDevice other = (JadbDevice)obj;
        return !(this.serial == null ? other.serial != null : !this.serial.equals(other.serial));
    }
}

