/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.swagger2;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomPropertyDefinition;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.SchemaGeneratorGeneralConfigPart;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.SubtypeResolver;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.TypeScope;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.module.swagger2.Swagger2SchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.module.swagger2.Swagger2SubtypeResolver;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class Swagger2Module
implements Module {
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        this.applyToConfigBuilder(builder.forTypesInGeneral());
        this.applyToConfigBuilder(builder.forFields());
        this.applyToConfigBuilder(builder.forMethods());
    }

    private void applyToConfigBuilder(SchemaGeneratorGeneralConfigPart configPart) {
        configPart.withDescriptionResolver(this.createTypePropertyResolver(Schema::description, description -> !description.isEmpty()));
        configPart.withTitleResolver(this.createTypePropertyResolver(Schema::title, title -> !title.isEmpty()));
        configPart.withSubtypeResolver((SubtypeResolver)new Swagger2SubtypeResolver());
        configPart.withDefinitionNamingStrategy((SchemaDefinitionNamingStrategy)new Swagger2SchemaDefinitionNamingStrategy(configPart.getDefinitionNamingStrategy()));
    }

    private void applyToConfigBuilder(SchemaGeneratorConfigPart<?> configPart) {
        configPart.withTargetTypeOverridesResolver(this::resolveTargetTypeOverrides);
        configPart.withIgnoreCheck(this::shouldBeIgnored);
        configPart.withPropertyNameOverrideResolver(this::resolvePropertyNameOverride);
        configPart.withCustomDefinitionProvider(this::provideCustomSchemaDefinition);
        configPart.withDescriptionResolver(this::resolveDescription);
        configPart.withTitleResolver(this::resolveTitle);
        configPart.withRequiredCheck(this::checkRequired);
        configPart.withNullableCheck(this::checkNullable);
        configPart.withReadOnlyCheck(this::checkReadOnly);
        configPart.withWriteOnlyCheck(this::checkWriteOnly);
        configPart.withEnumResolver(this::resolveEnum);
        configPart.withDefaultResolver(this::resolveDefault);
        configPart.withStringMinLengthResolver(this::resolveMinLength);
        configPart.withStringMaxLengthResolver(this::resolveMaxLength);
        configPart.withStringFormatResolver(this::resolveFormat);
        configPart.withStringPatternResolver(this::resolvePattern);
        configPart.withNumberMultipleOfResolver(this::resolveMultipleOf);
        configPart.withNumberExclusiveMaximumResolver(this::resolveExclusiveMaximum);
        configPart.withNumberInclusiveMaximumResolver(this::resolveInclusiveMaximum);
        configPart.withNumberExclusiveMinimumResolver(this::resolveExclusiveMinimum);
        configPart.withNumberInclusiveMinimumResolver(this::resolveInclusiveMinimum);
        configPart.withArrayMinItemsResolver(this::resolveArrayMinItems);
        configPart.withArrayMaxItemsResolver(this::resolveArrayMaxItems);
        configPart.withArrayUniqueItemsResolver(this::resolveArrayUniqueItems);
        configPart.withInstanceAttributeOverride(this::overrideInstanceAttributes);
    }

    protected List<ResolvedType> resolveTargetTypeOverrides(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::implementation, annotatedImplementation -> annotatedImplementation != Void.class).map(annotatedType -> member.getContext().resolve((Type)annotatedType, new Type[0])).map(Collections::singletonList).orElse(null);
    }

    protected boolean shouldBeIgnored(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::hidden, Boolean.TRUE::equals).isPresent();
    }

    protected String resolvePropertyNameOverride(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::name, name -> !name.isEmpty()).orElse(null);
    }

    protected String resolveDescription(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::description, description -> !description.isEmpty()).orElse(null);
    }

    protected String resolveTitle(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::title, title -> !title.isEmpty()).orElse(null);
    }

    protected boolean checkRequired(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::required, Boolean.TRUE::equals).isPresent();
    }

    protected boolean checkNullable(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::nullable, Boolean.TRUE::equals).isPresent();
    }

    protected boolean checkReadOnly(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::accessMode, arg_0 -> Schema.AccessMode.READ_ONLY.equals(arg_0)).isPresent();
    }

    protected boolean checkWriteOnly(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::accessMode, arg_0 -> Schema.AccessMode.WRITE_ONLY.equals(arg_0)).isPresent();
    }

    protected List<String> resolveEnum(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::allowableValues, values -> ((String[])values).length > 0).map(Arrays::asList).orElse(null);
    }

    protected String resolveDefault(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::defaultValue, defaultValue -> !defaultValue.isEmpty()).orElse(null);
    }

    protected Integer resolveMinLength(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::minLength, minLength -> minLength > 0).orElse(null);
    }

    protected Integer resolveMaxLength(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::maxLength, maxLength -> maxLength < Integer.MAX_VALUE && maxLength > -1).orElse(null);
    }

    protected String resolveFormat(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::format, format -> !format.isEmpty()).orElse(null);
    }

    protected String resolvePattern(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::pattern, pattern -> !pattern.isEmpty()).orElse(null);
    }

    protected BigDecimal resolveMultipleOf(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::multipleOf, multipleOf -> multipleOf != 0.0).map(BigDecimal::new).orElse(null);
    }

    protected BigDecimal resolveExclusiveMaximum(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::maximum, maximum -> !maximum.isEmpty()).filter(_maximum -> this.getSchemaAnnotationValue(member, Schema::exclusiveMaximum, Boolean.TRUE::equals).isPresent()).map(BigDecimal::new).orElse(null);
    }

    protected BigDecimal resolveInclusiveMaximum(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::maximum, maximum -> !maximum.isEmpty()).filter(_maximum -> this.getSchemaAnnotationValue(member, Schema::exclusiveMaximum, Boolean.FALSE::equals).isPresent()).map(BigDecimal::new).orElse(null);
    }

    protected BigDecimal resolveExclusiveMinimum(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::minimum, minimum -> !minimum.isEmpty()).filter(_minimum -> this.getSchemaAnnotationValue(member, Schema::exclusiveMinimum, Boolean.TRUE::equals).isPresent()).map(BigDecimal::new).orElse(null);
    }

    protected BigDecimal resolveInclusiveMinimum(MemberScope<?, ?> member) {
        return this.getSchemaAnnotationValue(member, Schema::minimum, minimum -> !minimum.isEmpty()).filter(_minimum -> this.getSchemaAnnotationValue(member, Schema::exclusiveMinimum, Boolean.FALSE::equals).isPresent()).map(BigDecimal::new).orElse(null);
    }

    protected Integer resolveArrayMinItems(MemberScope<?, ?> member) {
        if (member.isFakeContainerItemScope()) {
            return null;
        }
        return this.getArraySchemaAnnotation(member).map(ArraySchema::minItems).filter(minItems -> minItems != Integer.MAX_VALUE).orElse(null);
    }

    protected Integer resolveArrayMaxItems(MemberScope<?, ?> member) {
        if (member.isFakeContainerItemScope()) {
            return null;
        }
        return this.getArraySchemaAnnotation(member).map(ArraySchema::maxItems).filter(maxItems -> maxItems != Integer.MIN_VALUE).orElse(null);
    }

    protected Boolean resolveArrayUniqueItems(MemberScope<?, ?> member) {
        if (member.isFakeContainerItemScope()) {
            return null;
        }
        return this.getArraySchemaAnnotation(member).map(ArraySchema::uniqueItems).filter(uniqueItemsFlag -> uniqueItemsFlag).orElse(null);
    }

    protected CustomPropertyDefinition provideCustomSchemaDefinition(MemberScope<?, ?> scope, SchemaGenerationContext context) {
        CustomDefinition.AttributeInclusion attributeInclusion;
        Optional<String> externalReference = this.getSchemaAnnotationValue(scope, Schema::ref, ref -> !ref.isEmpty());
        if (!externalReference.isPresent()) {
            return null;
        }
        switch (context.getGeneratorConfig().getSchemaVersion()) {
            case DRAFT_6: 
            case DRAFT_7: {
                attributeInclusion = CustomDefinition.AttributeInclusion.NO;
                break;
            }
            default: {
                attributeInclusion = CustomDefinition.AttributeInclusion.YES;
            }
        }
        ObjectNode reference = context.getGeneratorConfig().createObjectNode().put(context.getKeyword(SchemaKeyword.TAG_REF), externalReference.get());
        return new CustomPropertyDefinition(reference, attributeInclusion);
    }

    protected void overrideInstanceAttributes(ObjectNode memberAttributes, MemberScope<?, ?> member, SchemaGenerationContext context) {
        ArrayNode allOfArray;
        Schema annotation = this.getSchemaAnnotationValue(member, Function.identity(), x -> true).orElse(null);
        if (annotation == null) {
            return;
        }
        if (annotation.not() != Void.class) {
            memberAttributes.set(context.getKeyword(SchemaKeyword.TAG_NOT), (JsonNode)context.createDefinitionReference(context.getTypeContext().resolve((Type)annotation.not(), new Type[0])));
        }
        if (annotation.allOf().length > 0) {
            allOfArray = memberAttributes.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF));
            Stream.of(annotation.allOf()).map(arg_0 -> Swagger2Module.lambda$overrideInstanceAttributes$27(context.getTypeContext(), arg_0)).map(arg_0 -> ((SchemaGenerationContext)context).createDefinitionReference(arg_0)).forEach(arg_0 -> ((ArrayNode)allOfArray).add(arg_0));
        }
        if (annotation.anyOf().length > 0) {
            allOfArray = memberAttributes.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF));
            ArrayNode anyOfArray = allOfArray.addObject().withArray(context.getKeyword(SchemaKeyword.TAG_ANYOF));
            Stream.of(annotation.anyOf()).map(arg_0 -> Swagger2Module.lambda$overrideInstanceAttributes$28(context.getTypeContext(), arg_0)).map(arg_0 -> ((SchemaGenerationContext)context).createDefinitionReference(arg_0)).forEach(arg_0 -> ((ArrayNode)anyOfArray).add(arg_0));
        }
        if (annotation.oneOf().length > 0) {
            allOfArray = memberAttributes.withArray(context.getKeyword(SchemaKeyword.TAG_ALLOF));
            ArrayNode oneOfArray = allOfArray.addObject().withArray(context.getKeyword(SchemaKeyword.TAG_ONEOF));
            Stream.of(annotation.oneOf()).map(arg_0 -> Swagger2Module.lambda$overrideInstanceAttributes$29(context.getTypeContext(), arg_0)).map(arg_0 -> ((SchemaGenerationContext)context).createDefinitionReference(arg_0)).forEach(arg_0 -> ((ArrayNode)oneOfArray).add(arg_0));
        }
        if (annotation.minProperties() > 0) {
            memberAttributes.put(context.getKeyword(SchemaKeyword.TAG_PROPERTIES_MIN), annotation.minProperties());
        }
        if (annotation.maxProperties() > 0) {
            memberAttributes.put(context.getKeyword(SchemaKeyword.TAG_PROPERTIES_MAX), annotation.maxProperties());
        }
        if (annotation.requiredProperties().length > 0) {
            HashSet alreadyMentionedRequiredFields = new HashSet();
            ArrayNode requiredFieldNames = memberAttributes.withArray(context.getKeyword(SchemaKeyword.TAG_REQUIRED));
            requiredFieldNames.forEach(arrayItem -> alreadyMentionedRequiredFields.add(arrayItem.asText()));
            Stream.of(annotation.requiredProperties()).filter(field -> !alreadyMentionedRequiredFields.contains(field)).forEach(arg_0 -> ((ArrayNode)requiredFieldNames).add(arg_0));
        }
    }

    private <T> Optional<T> getSchemaAnnotationValue(MemberScope<?, ?> member, Function<Schema, T> valueExtractor, Predicate<T> valueFilter) {
        if (member.isFakeContainerItemScope()) {
            return this.getArraySchemaAnnotation(member).map(ArraySchema::schema).map(valueExtractor).filter(valueFilter);
        }
        Schema annotation = (Schema)member.getAnnotationConsideringFieldAndGetter(Schema.class);
        if (annotation != null) {
            return Optional.of(annotation).map(valueExtractor).filter(valueFilter);
        }
        return this.getArraySchemaAnnotation(member).map(ArraySchema::arraySchema).map(valueExtractor).filter(valueFilter);
    }

    private <T> ConfigFunction<TypeScope, T> createTypePropertyResolver(Function<Schema, T> valueExtractor, Predicate<T> valueFilter) {
        return typeScope -> Optional.ofNullable(typeScope.getType().getErasedType().getAnnotation(Schema.class)).map(valueExtractor).filter(valueFilter).orElse(null);
    }

    private Optional<ArraySchema> getArraySchemaAnnotation(MemberScope<?, ?> member) {
        return Optional.ofNullable(member.getAnnotationConsideringFieldAndGetter(ArraySchema.class));
    }

    private static /* synthetic */ ResolvedType lambda$overrideInstanceAttributes$29(TypeContext rec$, Type x$0) {
        return rec$.resolve(x$0, new Type[0]);
    }

    private static /* synthetic */ ResolvedType lambda$overrideInstanceAttributes$28(TypeContext rec$, Type x$0) {
        return rec$.resolve(x$0, new Type[0]);
    }

    private static /* synthetic */ ResolvedType lambda$overrideInstanceAttributes$27(TypeContext rec$, Type x$0) {
        return rec$.resolve(x$0, new Type[0]);
    }
}

