/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.plugin.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;

public enum ClasspathType {
    PROJECT_ONLY,
    WITH_RUNTIME_DEPENDENCIES,
    WITH_COMPILE_DEPENDENCIES,
    WITH_ALL_DEPENDENCIES;


    public List<URL> getUrls(MavenProject project) {
        Collection<Object> classPathElements;
        try {
            switch (this) {
                case PROJECT_ONLY: {
                    classPathElements = Collections.singleton(project.getBuild().getOutputDirectory());
                    break;
                }
                case WITH_COMPILE_DEPENDENCIES: {
                    classPathElements = project.getCompileClasspathElements();
                    break;
                }
                case WITH_RUNTIME_DEPENDENCIES: {
                    classPathElements = project.getRuntimeClasspathElements();
                    break;
                }
                case WITH_ALL_DEPENDENCIES: {
                    classPathElements = new HashSet();
                    classPathElements.addAll(project.getRuntimeClasspathElements());
                    classPathElements.addAll(project.getCompileClasspathElements());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ClasspathType " + (Object)((Object)this) + " not supported");
                }
            }
        }
        catch (DependencyResolutionRequiredException e) {
            throw new IllegalStateException("Failed to resolve classpathType elements", e);
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPathElements.size());
        for (String string : classPathElements) {
            try {
                urls.add(new File(string).toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Failed to resolve classpath element", e);
            }
        }
        return urls;
    }
}

