/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.EnumSet;
import java.util.function.Function;
import java.util.stream.Stream;

public enum SchemaKeyword {
    TAG_SCHEMA("$schema", Type.TAG),
    TAG_SCHEMA_VALUE(SchemaVersion::getIdentifier, Type.VALUE),
    TAG_ID("$id", Type.TAG),
    TAG_ANCHOR("$anchor", Type.TAG),
    TAG_DEFINITIONS(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "definitions" : "$defs", Type.TAG),
    TAG_REF("$ref", Type.TAG),
    TAG_REF_MAIN("#", Type.VALUE),
    TAG_REF_PREFIX(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "#/definitions/" : "#/$defs/", Type.VALUE),
    TAG_TYPE("type", Type.TAG),
    TAG_TYPE_NULL("null", Type.VALUE),
    TAG_TYPE_ARRAY("array", Type.VALUE),
    TAG_TYPE_OBJECT("object", Type.VALUE),
    TAG_TYPE_BOOLEAN("boolean", Type.VALUE),
    TAG_TYPE_STRING("string", Type.VALUE),
    TAG_TYPE_INTEGER("integer", Type.VALUE),
    TAG_TYPE_NUMBER("number", Type.VALUE),
    TAG_PROPERTIES("properties", Type.TAG),
    TAG_ITEMS("items", Type.TAG),
    TAG_REQUIRED("required", Type.TAG),
    TAG_ADDITIONAL_PROPERTIES("additionalProperties", Type.TAG),
    TAG_PATTERN_PROPERTIES("patternProperties", Type.TAG),
    TAG_PROPERTIES_MIN("minProperties", Type.TAG),
    TAG_PROPERTIES_MAX("maxProperties", Type.TAG),
    TAG_ALLOF("allOf", Type.TAG),
    TAG_ANYOF("anyOf", Type.TAG),
    TAG_ONEOF("oneOf", Type.TAG),
    TAG_NOT("not", Type.TAG),
    TAG_TITLE("title", Type.TAG),
    TAG_DESCRIPTION("description", Type.TAG),
    TAG_CONST("const", Type.TAG),
    TAG_ENUM("enum", Type.TAG),
    TAG_DEFAULT("default", Type.TAG),
    TAG_READ_ONLY("readOnly", Type.TAG),
    TAG_WRITE_ONLY("writeOnly", Type.TAG),
    TAG_LENGTH_MIN("minLength", Type.TAG),
    TAG_LENGTH_MAX("maxLength", Type.TAG),
    TAG_FORMAT("format", Type.TAG),
    TAG_PATTERN("pattern", Type.TAG),
    TAG_MINIMUM("minimum", Type.TAG),
    TAG_MINIMUM_EXCLUSIVE("exclusiveMinimum", Type.TAG),
    TAG_MAXIMUM("maximum", Type.TAG),
    TAG_MAXIMUM_EXCLUSIVE("exclusiveMaximum", Type.TAG),
    TAG_MULTIPLE_OF("multipleOf", Type.TAG),
    TAG_ITEMS_MIN("minItems", Type.TAG),
    TAG_ITEMS_MAX("maxItems", Type.TAG),
    TAG_ITEMS_UNIQUE("uniqueItems", Type.TAG),
    TAG_IF("if", Type.TAG),
    TAG_THEN("then", Type.TAG),
    TAG_ELSE("else", Type.TAG);

    private final Function<SchemaVersion, String> valueProvider;
    private final Type type;

    private SchemaKeyword(String fixedValue, Type keywordType) {
        this((SchemaVersion _version) -> fixedValue, keywordType);
    }

    private SchemaKeyword(Function<SchemaVersion, String> valueProvider, Type keywordType) {
        this.valueProvider = valueProvider;
        this.type = keywordType;
    }

    public String forVersion(SchemaVersion version) {
        return this.valueProvider.apply(version);
    }

    public static Stream<SchemaKeyword> getTagStream() {
        return EnumSet.allOf(SchemaKeyword.class).stream().filter(keyword -> keyword.type == Type.TAG);
    }

    private static enum Type {
        TAG,
        VALUE;

    }
}

