/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.SchemaVersion;
import java.util.function.Function;

public enum SchemaKeyword {
    TAG_SCHEMA("$schema"),
    TAG_SCHEMA_VALUE(SchemaVersion::getIdentifier),
    TAG_ID("$id"),
    TAG_ANCHOR("$anchor"),
    TAG_DEFINITIONS(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "definitions" : "$defs"),
    TAG_REF("$ref"),
    TAG_REF_MAIN("#"),
    TAG_REF_PREFIX(version -> version == SchemaVersion.DRAFT_6 || version == SchemaVersion.DRAFT_7 ? "#/definitions/" : "#/$defs/"),
    TAG_TYPE("type"),
    TAG_TYPE_NULL("null"),
    TAG_TYPE_ARRAY("array"),
    TAG_TYPE_OBJECT("object"),
    TAG_TYPE_BOOLEAN("boolean"),
    TAG_TYPE_STRING("string"),
    TAG_TYPE_INTEGER("integer"),
    TAG_TYPE_NUMBER("number"),
    TAG_PROPERTIES("properties"),
    TAG_ITEMS("items"),
    TAG_REQUIRED("required"),
    TAG_ADDITIONAL_PROPERTIES("additionalProperties"),
    TAG_PATTERN_PROPERTIES("patternProperties"),
    TAG_ALLOF("allOf"),
    TAG_ANYOF("anyOf"),
    TAG_ONEOF("oneOf"),
    TAG_TITLE("title"),
    TAG_DESCRIPTION("description"),
    TAG_CONST("const"),
    TAG_ENUM("enum"),
    TAG_DEFAULT("default"),
    TAG_LENGTH_MIN("minLength"),
    TAG_LENGTH_MAX("maxLength"),
    TAG_FORMAT("format"),
    TAG_PATTERN("pattern"),
    TAG_MINIMUM("minimum"),
    TAG_MINIMUM_EXCLUSIVE("exclusiveMinimum"),
    TAG_MAXIMUM("maximum"),
    TAG_MAXIMUM_EXCLUSIVE("exclusiveMaximum"),
    TAG_MULTIPLE_OF("multipleOf"),
    TAG_ITEMS_MIN("minItems"),
    TAG_ITEMS_MAX("maxItems"),
    TAG_ITEMS_UNIQUE("uniqueItems"),
    TAG_IF("if"),
    TAG_THEN("then"),
    TAG_ELSE("else");

    private final Function<SchemaVersion, String> valueProvider;

    private SchemaKeyword(String fixedValue) {
        this.valueProvider = _version -> fixedValue;
    }

    private SchemaKeyword(Function<SchemaVersion, String> valueProvider) {
        this.valueProvider = valueProvider;
    }

    public String forVersion(SchemaVersion version) {
        return this.valueProvider.apply(version);
    }
}

