/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.HierarchicType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMethod;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.FieldScope;
import com.github.victools.jsonschema.generator.MethodScope;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.impl.TypeContextFactory;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaGenerator {
    private static final Logger logger = LoggerFactory.getLogger(SchemaGenerator.class);
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;

    public SchemaGenerator(SchemaGeneratorConfig config) {
        this(config, TypeContextFactory.createDefaultTypeContext());
    }

    public SchemaGenerator(SchemaGeneratorConfig config, TypeContext context) {
        this.config = config;
        this.typeContext = context;
    }

    public JsonNode generateSchema(Type mainTargetType, Type ... typeParameters) {
        ObjectNode definitionsNode;
        SchemaGenerationContext generationContext = new SchemaGenerationContext(this.config, this.typeContext);
        ResolvedType mainType = generationContext.getTypeContext().resolve(mainTargetType, typeParameters);
        this.traverseGenericType(mainType, null, false, generationContext);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put("$schema", "http://json-schema.org/draft-07/schema#");
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(mainType, generationContext)).size() > 0) {
            jsonSchemaResult.set("definitions", (JsonNode)definitionsNode);
        }
        ObjectNode mainSchemaNode = generationContext.getDefinition(mainType);
        jsonSchemaResult.setAll(mainSchemaNode);
        return jsonSchemaResult;
    }

    private void traverseGenericType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, SchemaGenerationContext generationContext) {
        if (generationContext.containsDefinition(targetType)) {
            logger.debug("adding reference to existing definition of {}", (Object)targetType);
            generationContext.addReference(targetType, targetNode, isNullable);
            return;
        }
        ObjectNode definition = generationContext.getTypeContext().isContainerType(targetType) ? this.traverseArrayType(targetType, targetNode, isNullable, generationContext) : this.traverseObjectType(targetType, targetNode, isNullable, generationContext);
        this.config.getTypeAttributeOverrides().forEach(override -> override.overrideTypeAttributes(definition, targetType, this.config));
    }

    private ObjectNode traverseArrayType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, SchemaGenerationContext generationContext) {
        ObjectNode definition;
        if (targetNode == null) {
            definition = this.config.createObjectNode();
            generationContext.putDefinition(targetType, definition);
        } else {
            definition = targetNode;
        }
        if (isNullable) {
            definition.set("type", (JsonNode)this.config.createArrayNode().add("array").add("null"));
        } else {
            definition.put("type", "array");
        }
        ObjectNode arrayItemTypeRef = this.config.createObjectNode();
        definition.set("items", (JsonNode)arrayItemTypeRef);
        ResolvedType itemType = generationContext.getTypeContext().getContainerItemType(targetType);
        this.traverseGenericType(itemType, arrayItemTypeRef, false, generationContext);
        return definition;
    }

    private ObjectNode traverseObjectType(ResolvedType targetType, ObjectNode targetNode, boolean isNullable, SchemaGenerationContext generationContext) {
        ObjectNode definition;
        CustomDefinition customDefinition = this.config.getCustomDefinition(targetType, generationContext.getTypeContext());
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            if (targetNode == null) {
                logger.debug("storing configured custom inline type for {} as definition (since it is the main schema \"#\")", (Object)targetType);
                definition = customDefinition.getValue();
                generationContext.putDefinition(targetType, definition);
            } else {
                logger.debug("directly applying configured custom inline type for {}", (Object)targetType);
                targetNode.setAll(customDefinition.getValue());
                definition = targetNode;
            }
        } else {
            definition = this.config.createObjectNode();
            generationContext.putDefinition(targetType, definition);
            if (targetNode != null) {
                generationContext.addReference(targetType, targetNode, isNullable);
            }
            if (customDefinition == null) {
                logger.debug("generating definition for {}", (Object)targetType);
                definition.put("type", "object");
                TreeMap<String, JsonNode> targetFields = new TreeMap<String, JsonNode>();
                TreeMap<String, JsonNode> targetMethods = new TreeMap<String, JsonNode>();
                HashSet<String> requiredProperties = new HashSet<String>();
                this.collectObjectProperties(targetType, targetFields, targetMethods, requiredProperties, generationContext);
                if (!targetFields.isEmpty() || !targetMethods.isEmpty()) {
                    ObjectNode propertiesNode = this.config.createObjectNode();
                    propertiesNode.setAll(targetFields);
                    propertiesNode.setAll(targetMethods);
                    definition.set("properties", (JsonNode)propertiesNode);
                    if (!requiredProperties.isEmpty()) {
                        ArrayNode requiredNode = this.config.createArrayNode();
                        requiredProperties.forEach(arg_0 -> ((ArrayNode)requiredNode).add(arg_0));
                        definition.set("required", (JsonNode)requiredNode);
                    }
                }
            } else {
                logger.debug("applying configured custom definition for {}", (Object)targetType);
                definition.setAll(customDefinition.getValue());
            }
        }
        return definition;
    }

    private void collectObjectProperties(ResolvedType targetType, Map<String, JsonNode> targetFields, Map<String, JsonNode> targetMethods, Set<String> requiredProperties, SchemaGenerationContext generationContext) {
        logger.debug("collecting non-static fields and methods from {}", (Object)targetType);
        ResolvedTypeWithMembers targetTypeWithMembers = generationContext.getTypeContext().resolveWithMembers(targetType);
        this.populateFields(targetTypeWithMembers, ResolvedTypeWithMembers::getMemberFields, targetFields, requiredProperties, generationContext);
        this.populateMethods(targetTypeWithMembers, ResolvedTypeWithMembers::getMemberMethods, targetMethods, requiredProperties, generationContext);
        boolean includeStaticFields = this.config.shouldIncludeStaticFields();
        boolean includeStaticMethods = this.config.shouldIncludeStaticMethods();
        if (includeStaticFields || includeStaticMethods) {
            for (HierarchicType singleHierarchy : targetTypeWithMembers.allTypesAndOverrides()) {
                ResolvedType hierachyType = singleHierarchy.getType();
                logger.debug("collecting static fields and methods from {}", (Object)hierachyType);
                if ((!includeStaticFields || hierachyType.getStaticFields().isEmpty()) && (!includeStaticMethods || hierachyType.getStaticMethods().isEmpty())) continue;
                ResolvedTypeWithMembers hierarchyTypeMembers = hierachyType == targetType ? targetTypeWithMembers : generationContext.getTypeContext().resolveWithMembers(hierachyType);
                if (includeStaticFields) {
                    this.populateFields(hierarchyTypeMembers, ResolvedTypeWithMembers::getStaticFields, targetFields, requiredProperties, generationContext);
                }
                if (!includeStaticMethods) continue;
                this.populateMethods(hierarchyTypeMembers, ResolvedTypeWithMembers::getStaticMethods, targetMethods, requiredProperties, generationContext);
            }
        }
    }

    private void populateFields(ResolvedTypeWithMembers declaringTypeMembers, Function<ResolvedTypeWithMembers, ResolvedField[]> fieldLookup, Map<String, JsonNode> collectedFields, Set<String> requiredProperties, SchemaGenerationContext generationContext) {
        Stream.of((Object[])fieldLookup.apply(declaringTypeMembers)).map(declaredField -> generationContext.getTypeContext().createFieldScope((ResolvedField)declaredField, declaringTypeMembers)).filter(fieldScope -> !this.config.shouldIgnore((FieldScope)fieldScope)).forEach(fieldScope -> this.populateField((FieldScope)fieldScope, collectedFields, requiredProperties, generationContext));
    }

    private void populateMethods(ResolvedTypeWithMembers declaringTypeMembers, Function<ResolvedTypeWithMembers, ResolvedMethod[]> methodLookup, Map<String, JsonNode> collectedMethods, Set<String> requiredProperties, SchemaGenerationContext generationContext) {
        Stream.of((Object[])methodLookup.apply(declaringTypeMembers)).map(declaredMethod -> generationContext.getTypeContext().createMethodScope((ResolvedMethod)declaredMethod, declaringTypeMembers)).filter(methodScope -> !this.config.shouldIgnore((MethodScope)methodScope)).forEach(methodScope -> this.populateMethod((MethodScope)methodScope, collectedMethods, requiredProperties, generationContext));
    }

    private void populateField(FieldScope field, Map<String, JsonNode> collectedFields, Set<String> requiredProperties, SchemaGenerationContext generationContext) {
        String propertyNameOverride = this.config.resolvePropertyNameOverride(field);
        FieldScope fieldWithOverride = propertyNameOverride == null ? field : field.withOverriddenName(propertyNameOverride);
        String propertyName = fieldWithOverride.getSchemaPropertyName();
        if (this.config.isRequired(field)) {
            requiredProperties.add(propertyName);
        }
        if (collectedFields.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)fieldWithOverride.getDeclaringType(), (Object)fieldWithOverride.getDeclaredName());
            return;
        }
        ObjectNode subSchema = this.config.createObjectNode();
        collectedFields.put(propertyName, (JsonNode)subSchema);
        ResolvedType typeOverride = this.config.resolveTargetTypeOverride(fieldWithOverride);
        fieldWithOverride = typeOverride == null ? fieldWithOverride : fieldWithOverride.withOverriddenType(typeOverride);
        ObjectNode fieldAttributes = AttributeCollector.collectFieldAttributes(fieldWithOverride, this.config);
        boolean isNullable = !((Field)fieldWithOverride.getRawMember()).isEnumConstant() && this.config.isNullable(fieldWithOverride);
        this.populateSchema(fieldWithOverride.getType(), subSchema, isNullable, fieldAttributes, generationContext);
    }

    private void populateMethod(MethodScope method, Map<String, JsonNode> collectedMethods, Set<String> requiredProperties, SchemaGenerationContext generationContext) {
        String propertyNameOverride = this.config.resolvePropertyNameOverride(method);
        MethodScope methodWithOverride = propertyNameOverride == null ? method : method.withOverriddenName(propertyNameOverride);
        String propertyName = methodWithOverride.getSchemaPropertyName();
        if (this.config.isRequired(method)) {
            requiredProperties.add(propertyName);
        }
        if (collectedMethods.containsKey(propertyName)) {
            logger.debug("ignoring overridden {}.{}", (Object)methodWithOverride.getDeclaringType(), (Object)methodWithOverride.getDeclaredName());
            return;
        }
        ResolvedType typeOverride = this.config.resolveTargetTypeOverride(methodWithOverride);
        MethodScope methodScope = methodWithOverride = typeOverride == null ? methodWithOverride : methodWithOverride.withOverriddenType(typeOverride);
        if (methodWithOverride.isVoid()) {
            collectedMethods.put(propertyName, (JsonNode)BooleanNode.FALSE);
        } else {
            ObjectNode subSchema = this.config.createObjectNode();
            collectedMethods.put(propertyName, (JsonNode)subSchema);
            ObjectNode methodAttributes = AttributeCollector.collectMethodAttributes(methodWithOverride, this.config);
            boolean isNullable = this.config.isNullable(methodWithOverride);
            this.populateSchema(methodWithOverride.getType(), subSchema, isNullable, methodAttributes, generationContext);
        }
    }

    private void populateSchema(ResolvedType javaType, ObjectNode targetNode, boolean isNullable, ObjectNode collectedAttributes, SchemaGenerationContext generationContext) {
        ObjectNode referenceContainer;
        CustomDefinition customDefinition = this.config.getCustomDefinition(javaType, generationContext.getTypeContext());
        if (collectedAttributes == null || collectedAttributes.size() == 0 || customDefinition != null && customDefinition.isMeantToBeInline() || generationContext.getTypeContext().isContainerType(javaType)) {
            referenceContainer = targetNode;
        } else {
            referenceContainer = this.config.createObjectNode();
            targetNode.set("allOf", (JsonNode)this.config.createArrayNode().add((JsonNode)referenceContainer).add((JsonNode)collectedAttributes));
        }
        if (customDefinition != null && customDefinition.isMeantToBeInline()) {
            referenceContainer.setAll(customDefinition.getValue());
            if (collectedAttributes != null && collectedAttributes.size() > 0) {
                referenceContainer.setAll(collectedAttributes);
            }
            if (isNullable) {
                this.makeNullable(referenceContainer);
            }
        } else {
            try {
                this.traverseGenericType(javaType, referenceContainer, isNullable, generationContext);
            }
            catch (UnsupportedOperationException ex) {
                logger.warn("Skipping type definition due to error", (Throwable)ex);
            }
        }
    }

    private void makeNullable(ObjectNode node) {
        if (node.has("$ref") || node.has("allOf") || node.has("anyOf") || node.has("oneOf")) {
            ObjectNode nullSchema = this.config.createObjectNode().put("type", "null");
            ArrayNode oneOf = this.config.createArrayNode().add((JsonNode)nullSchema).add(this.config.createObjectNode().setAll(node));
            node.removeAll();
            node.set("oneOf", (JsonNode)oneOf);
        } else {
            JsonNode fixedJsonSchemaType = node.get("type");
            if (fixedJsonSchemaType instanceof ArrayNode) {
                ArrayNode arrayOfTypes = (ArrayNode)fixedJsonSchemaType;
                boolean alreadyContainsNull = false;
                for (JsonNode arrayEntry : arrayOfTypes) {
                    alreadyContainsNull = alreadyContainsNull || "null".equals(arrayEntry.textValue());
                }
                if (!alreadyContainsNull) {
                    arrayOfTypes.add("null");
                }
            } else if (fixedJsonSchemaType instanceof TextNode && !"null".equals(fixedJsonSchemaType.textValue())) {
                node.replace("type", (JsonNode)this.config.createArrayNode().add(fixedJsonSchemaType).add("null"));
            }
        }
    }

    private ObjectNode buildDefinitionsAndResolveReferences(ResolvedType mainSchemaTarget, SchemaGenerationContext generationContext) {
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(generationContext.getTypeContext()::getSchemaDefinitionName, TreeMap::new, Collectors.toList()));
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        for (Map.Entry aliasEntry : aliases.entrySet()) {
            String referenceKey;
            boolean referenceInline;
            List types = (List)aliasEntry.getValue();
            List<ObjectNode> referencingNodes = types.stream().flatMap(type -> generationContext.getReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            List<ObjectNode> nullableReferences = types.stream().flatMap(type -> generationContext.getNullableReferences((ResolvedType)type).stream()).collect(Collectors.toList());
            String alias = (String)aliasEntry.getKey();
            boolean bl = referenceInline = !types.contains(mainSchemaTarget) && (referencingNodes.isEmpty() || !createDefinitionsForAll && referencingNodes.size() + nullableReferences.size() < 2);
            if (referenceInline) {
                referencingNodes.forEach(referenceNode -> referenceNode.setAll(generationContext.getDefinition((ResolvedType)types.get(0))));
                referenceKey = null;
            } else {
                if (types.contains(mainSchemaTarget)) {
                    referenceKey = "#";
                } else {
                    definitionsNode.set(alias, (JsonNode)generationContext.getDefinition((ResolvedType)types.get(0)));
                    referenceKey = "#/definitions/" + alias;
                }
                referencingNodes.forEach(referenceNode -> referenceNode.put("$ref", referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            ObjectNode definition = referenceInline ? generationContext.getDefinition((ResolvedType)types.get(0)) : this.config.createObjectNode().put("$ref", referenceKey);
            this.makeNullable(definition);
            if (createDefinitionsForAll || nullableReferences.size() > 1) {
                String nullableAlias = alias + " (nullable)";
                String nullableReferenceKey = "#/definitions/" + nullableAlias;
                definitionsNode.set(nullableAlias, (JsonNode)definition);
                nullableReferences.forEach(referenceNode -> referenceNode.put("$ref", nullableReferenceKey));
                continue;
            }
            nullableReferences.forEach(referenceNode -> referenceNode.setAll(definition));
        }
        return definitionsNode;
    }
}

