/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.util.Optional;

public class FlattenedOptionalModule
implements Module {
    private static boolean isOptional(ResolvedType type) {
        return type.getErasedType() == Optional.class;
    }

    private <F> ResolvedType resolveOptionalComponentType(F fieldOrMethod, ResolvedType javaType, ResolvedTypeWithMembers declaringType) {
        return FlattenedOptionalModule.isOptional(javaType) ? (ResolvedType)javaType.typeParametersFor(Optional.class).get(0) : null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withNullableCheck((field, javaType, declaringType) -> FlattenedOptionalModule.isOptional(javaType) ? Boolean.TRUE : null).withTargetTypeOverrideResolver(this::resolveOptionalComponentType);
        builder.forMethods().withNullableCheck((method, javaType, declaringType) -> FlattenedOptionalModule.isOptional(javaType) ? Boolean.TRUE : null).withTargetTypeOverrideResolver(this::resolveOptionalComponentType);
    }
}

