/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ReflectionToStringUtils {
    public static String createStringRepresentation(ResolvedType type) {
        String result = type.getErasedType().getSimpleName();
        List typeParameters = type.getTypeParameters();
        if (!typeParameters.isEmpty()) {
            result = result + typeParameters.stream().map(ReflectionToStringUtils::createStringRepresentation).collect(Collectors.joining(", ", "<", ">"));
        }
        return result;
    }

    public static String createStringRepresentation(ResolvedMethod method) {
        String result = method.getName();
        result = result + IntStream.range(0, method.getArgumentCount()).mapToObj(arg_0 -> ((ResolvedMethod)method).getArgumentType(arg_0)).map(ReflectionToStringUtils::createStringRepresentation).collect(Collectors.joining(", ", "(", ")"));
        return result;
    }
}

