/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.ReflectionTypeUtils;

public class FlattenedOptionalModule
implements Module {
    private JavaType resolveOptionalComponentType(JavaType javaType) {
        if (ReflectionTypeUtils.isOptionalType(javaType)) {
            return ReflectionTypeUtils.getOptionalComponentType(javaType);
        }
        return null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withNullableCheck((field, javaType) -> ReflectionTypeUtils.isOptionalType(javaType) ? Boolean.TRUE : null).withTargetTypeOverrideResolver((field, javaType) -> this.resolveOptionalComponentType((JavaType)javaType));
        builder.forMethods().withNullableCheck((method, javaType) -> ReflectionTypeUtils.isOptionalType(javaType) ? Boolean.TRUE : null).withTargetTypeOverrideResolver((method, javaType) -> this.resolveOptionalComponentType((JavaType)javaType));
    }
}

