/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.InstanceAttributeOverride;
import com.github.victools.jsonschema.generator.JavaType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SchemaGeneratorConfigPart<O> {
    private final List<InstanceAttributeOverride<O>> instanceAttributeOverrides = new ArrayList<InstanceAttributeOverride<O>>();
    private final List<Predicate<O>> ignoreChecks = new ArrayList<Predicate<O>>();
    private final List<BiFunction<O, JavaType, Boolean>> nullableChecks = new ArrayList<BiFunction<O, JavaType, Boolean>>();
    private final List<BiFunction<O, JavaType, JavaType>> targetTypeOverrideResolvers = new ArrayList<BiFunction<O, JavaType, JavaType>>();
    private final List<BiFunction<O, String, String>> propertyNameOverrideResolvers = new ArrayList<BiFunction<O, String, String>>();
    private final List<BiFunction<O, JavaType, String>> titleResolvers = new ArrayList<BiFunction<O, JavaType, String>>();
    private final List<BiFunction<O, JavaType, String>> descriptionResolvers = new ArrayList<BiFunction<O, JavaType, String>>();
    private final List<BiFunction<O, JavaType, Collection<?>>> enumResolvers = new ArrayList();
    private final List<BiFunction<O, JavaType, Integer>> stringMinLengthResolvers = new ArrayList<BiFunction<O, JavaType, Integer>>();
    private final List<BiFunction<O, JavaType, Integer>> stringMaxLengthResolvers = new ArrayList<BiFunction<O, JavaType, Integer>>();
    private final List<BiFunction<O, JavaType, String>> stringFormatResolvers = new ArrayList<BiFunction<O, JavaType, String>>();
    private final List<BiFunction<O, JavaType, BigDecimal>> numberInclusiveMinimumResolvers = new ArrayList<BiFunction<O, JavaType, BigDecimal>>();
    private final List<BiFunction<O, JavaType, BigDecimal>> numberExclusiveMinimumResolvers = new ArrayList<BiFunction<O, JavaType, BigDecimal>>();
    private final List<BiFunction<O, JavaType, BigDecimal>> numberInclusiveMaximumResolvers = new ArrayList<BiFunction<O, JavaType, BigDecimal>>();
    private final List<BiFunction<O, JavaType, BigDecimal>> numberExclusiveMaximumResolvers = new ArrayList<BiFunction<O, JavaType, BigDecimal>>();
    private final List<BiFunction<O, JavaType, BigDecimal>> numberMultipleOfResolvers = new ArrayList<BiFunction<O, JavaType, BigDecimal>>();
    private final List<BiFunction<O, JavaType, Integer>> arrayMinItemsResolvers = new ArrayList<BiFunction<O, JavaType, Integer>>();
    private final List<BiFunction<O, JavaType, Integer>> arrayMaxItemsResolvers = new ArrayList<BiFunction<O, JavaType, Integer>>();
    private final List<BiFunction<O, JavaType, Boolean>> arrayUniqueItemsResolvers = new ArrayList<BiFunction<O, JavaType, Boolean>>();

    private static <O, P, R> R getFirstDefinedValue(List<BiFunction<O, P, R>> resolvers, O origin, P secondParameter) {
        return resolvers.stream().map(resolver -> resolver.apply(origin, secondParameter)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public SchemaGeneratorConfigPart<O> withInstanceAttributeOverride(InstanceAttributeOverride<O> override) {
        this.instanceAttributeOverrides.add(override);
        return this;
    }

    public List<InstanceAttributeOverride<O>> getInstanceAttributeOverrides() {
        return Collections.unmodifiableList(this.instanceAttributeOverrides);
    }

    public SchemaGeneratorConfigPart<O> withIgnoreCheck(Predicate<O> check) {
        this.ignoreChecks.add(check);
        return this;
    }

    public boolean shouldIgnore(O origin) {
        return this.ignoreChecks.stream().anyMatch(check -> check.test(origin));
    }

    public SchemaGeneratorConfigPart<O> withNullableCheck(BiFunction<O, JavaType, Boolean> check) {
        this.nullableChecks.add(check);
        return this;
    }

    public Boolean isNullable(O origin, JavaType originType) {
        Set result = this.nullableChecks.stream().map(check -> (Boolean)check.apply(origin, originType)).filter(Objects::nonNull).collect(Collectors.toSet());
        return result.isEmpty() ? null : Boolean.valueOf(result.stream().anyMatch(value -> value));
    }

    public SchemaGeneratorConfigPart<O> withTargetTypeOverrideResolver(BiFunction<O, JavaType, JavaType> resolver) {
        this.targetTypeOverrideResolvers.add(resolver);
        return this;
    }

    public JavaType resolveTargetTypeOverride(O origin, JavaType defaultType) {
        return (JavaType)SchemaGeneratorConfigPart.getFirstDefinedValue(this.targetTypeOverrideResolvers, origin, defaultType);
    }

    public SchemaGeneratorConfigPart<O> withPropertyNameOverrideResolver(BiFunction<O, String, String> resolver) {
        this.propertyNameOverrideResolvers.add(resolver);
        return this;
    }

    public String resolvePropertyNameOverride(O origin, String defaultName) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.propertyNameOverrideResolvers, origin, defaultName);
    }

    public SchemaGeneratorConfigPart<O> withTitleResolver(BiFunction<O, JavaType, String> resolver) {
        this.titleResolvers.add(resolver);
        return this;
    }

    public String resolveTitle(O origin, JavaType originType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.titleResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withDescriptionResolver(BiFunction<O, JavaType, String> resolver) {
        this.descriptionResolvers.add(resolver);
        return this;
    }

    public String resolveDescription(O origin, JavaType originType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.descriptionResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withEnumResolver(BiFunction<O, JavaType, Collection<?>> resolver) {
        this.enumResolvers.add(resolver);
        return this;
    }

    public Collection<?> resolveEnum(O origin, JavaType originType) {
        return (Collection)SchemaGeneratorConfigPart.getFirstDefinedValue(this.enumResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withStringMinLengthResolver(BiFunction<O, JavaType, Integer> resolver) {
        this.stringMinLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMinLength(O origin, JavaType originType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringMinLengthResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withStringMaxLengthResolver(BiFunction<O, JavaType, Integer> resolver) {
        this.stringMaxLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMaxLength(O origin, JavaType originType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringMaxLengthResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withStringFormatResolver(BiFunction<O, JavaType, String> resolver) {
        this.stringFormatResolvers.add(resolver);
        return this;
    }

    public String resolveStringFormat(O origin, JavaType originType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringFormatResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withNumberInclusiveMinimumResolver(BiFunction<O, JavaType, BigDecimal> resolver) {
        this.numberInclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMinimum(O origin, JavaType originType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberInclusiveMinimumResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withNumberExclusiveMinimumResolver(BiFunction<O, JavaType, BigDecimal> resolver) {
        this.numberExclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMinimum(O origin, JavaType originType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberExclusiveMinimumResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withNumberInclusiveMaximumResolver(BiFunction<O, JavaType, BigDecimal> resolver) {
        this.numberInclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMaximum(O origin, JavaType originType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberInclusiveMaximumResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withNumberExclusiveMaximumResolver(BiFunction<O, JavaType, BigDecimal> resolver) {
        this.numberExclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMaximum(O origin, JavaType originType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberExclusiveMaximumResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withNumberMultipleOfResolver(BiFunction<O, JavaType, BigDecimal> resolver) {
        this.numberMultipleOfResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberMultipleOf(O origin, JavaType originType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberMultipleOfResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withArrayMinItemsResolver(BiFunction<O, JavaType, Integer> resolver) {
        this.arrayMinItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMinItems(O origin, JavaType originType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayMinItemsResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withArrayMaxItemsResolver(BiFunction<O, JavaType, Integer> resolver) {
        this.arrayMaxItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMaxItems(O origin, JavaType originType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayMaxItemsResolvers, origin, originType);
    }

    public SchemaGeneratorConfigPart<O> withArrayUniqueItemsResolver(BiFunction<O, JavaType, Boolean> resolver) {
        this.arrayUniqueItemsResolvers.add(resolver);
        return this;
    }

    public Boolean resolveArrayUniqueItems(O origin, JavaType originType) {
        return (Boolean)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayUniqueItemsResolvers, origin, originType);
    }
}

