/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigPart;
import com.github.victools.jsonschema.generator.impl.ReflectionGetterUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.BiFunction;

public class GetterAttributesForFieldModule
implements Module {
    private static <D, R> BiFunction<Field, D, R> resolveForGetter(BiFunction<Method, D, R> resolver) {
        return (field, defaultValue) -> Optional.ofNullable(ReflectionGetterUtils.findGetterForField(field)).map(method -> resolver.apply((Method)method, (Object)defaultValue)).orElse(null);
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        SchemaGeneratorConfigPart<Method> methodConfigPart = builder.forMethods();
        builder.forFields().withArrayMaxItemsResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveArrayMaxItems)).withArrayMinItemsResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveArrayMinItems)).withArrayUniqueItemsResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveArrayUniqueItems)).withDescriptionResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveDescription)).withEnumResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveEnum)).withNullableCheck(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::isNullable)).withNumberExclusiveMaximumResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveNumberExclusiveMaximum)).withNumberExclusiveMinimumResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveNumberExclusiveMinimum)).withNumberInclusiveMaximumResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveNumberInclusiveMaximum)).withNumberInclusiveMinimumResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveNumberInclusiveMinimum)).withNumberMultipleOfResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveNumberMultipleOf)).withStringFormatResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveStringFormat)).withStringMaxLengthResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveStringMaxLength)).withStringMinLengthResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveStringMinLength)).withTargetTypeOverrideResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveTargetTypeOverride)).withTitleResolver(GetterAttributesForFieldModule.resolveForGetter(methodConfigPart::resolveTitle));
    }
}

