/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.InstanceAttributeOverride;
import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.TypeAttributeOverride;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public interface SchemaGeneratorConfig {
    public boolean shouldCreateDefinitionsForAllObjects();

    public boolean shouldIncludeSchemaVersionIndicator();

    public ObjectMapper getObjectMapper();

    public ObjectNode createObjectNode();

    public ArrayNode createArrayNode();

    public CustomDefinition getCustomDefinition(JavaType var1);

    public List<TypeAttributeOverride> getTypeAttributeOverrides();

    public List<InstanceAttributeOverride<Field>> getFieldAttributeOverrides();

    public List<InstanceAttributeOverride<Method>> getMethodAttributeOverrides();

    public boolean isNullable(Field var1, JavaType var2);

    public boolean isNullable(Method var1, JavaType var2);

    public boolean shouldIgnore(Field var1);

    public boolean shouldIgnore(Method var1);

    public JavaType resolveTargetTypeOverride(Field var1, JavaType var2);

    public JavaType resolveTargetTypeOverride(Method var1, JavaType var2);

    public String resolvePropertyNameOverride(Field var1, String var2);

    public String resolvePropertyNameOverride(Method var1, String var2);

    public String resolveTitle(Field var1, JavaType var2);

    public String resolveTitle(Method var1, JavaType var2);

    public String resolveDescription(Field var1, JavaType var2);

    public String resolveDescription(Method var1, JavaType var2);

    public Collection<?> resolveEnum(Field var1, JavaType var2);

    public Collection<?> resolveEnum(Method var1, JavaType var2);

    public Integer resolveStringMinLength(Field var1, JavaType var2);

    public Integer resolveStringMinLength(Method var1, JavaType var2);

    public Integer resolveStringMaxLength(Field var1, JavaType var2);

    public Integer resolveStringMaxLength(Method var1, JavaType var2);

    public String resolveStringFormat(Field var1, JavaType var2);

    public String resolveStringFormat(Method var1, JavaType var2);

    public BigDecimal resolveNumberInclusiveMinimum(Field var1, JavaType var2);

    public BigDecimal resolveNumberInclusiveMinimum(Method var1, JavaType var2);

    public BigDecimal resolveNumberExclusiveMinimum(Field var1, JavaType var2);

    public BigDecimal resolveNumberExclusiveMinimum(Method var1, JavaType var2);

    public BigDecimal resolveNumberInclusiveMaximum(Field var1, JavaType var2);

    public BigDecimal resolveNumberInclusiveMaximum(Method var1, JavaType var2);

    public BigDecimal resolveNumberExclusiveMaximum(Field var1, JavaType var2);

    public BigDecimal resolveNumberExclusiveMaximum(Method var1, JavaType var2);

    public BigDecimal resolveNumberMultipleOf(Field var1, JavaType var2);

    public BigDecimal resolveNumberMultipleOf(Method var1, JavaType var2);

    public Integer resolveArrayMinItems(Field var1, JavaType var2);

    public Integer resolveArrayMinItems(Method var1, JavaType var2);

    public Integer resolveArrayMaxItems(Field var1, JavaType var2);

    public Integer resolveArrayMaxItems(Method var1, JavaType var2);

    public Boolean resolveArrayUniqueItems(Field var1, JavaType var2);

    public Boolean resolveArrayUniqueItems(Method var1, JavaType var2);
}

