/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.lss.push;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;
import com.vhall.framework.VHAPI;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.lss.VHLssApi;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.push.IVHCapture;
import com.vhall.push.LivePusher;
import com.vhall.push.VHAudioCapture;
import com.vhall.push.VHLivePushConfig;
import com.vhall.push.VHScreenCapture;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHScreenRecordService
extends Service {
    private static final String TAG = "VHScreenRecordService";
    public static final String BROADCAST_ACTION = "com.vhall.aps.status";
    private LivePusher livePusher;
    private String mRoomId;
    private String mAccessToken;
    private String mURL;
    private boolean dispatching = false;
    private VHPlayerListener listener = new VHPlayerListener(){

        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START: {
                    VHScreenRecordService.this.broStateChanged(0, null);
                    JSONObject body = new JSONObject();
                    try {
                        body.put("type", (Object)"live_start");
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    VHAPI.sendMsg((String)body.toString(), (String)VHScreenRecordService.this.mAccessToken, (String)"service_room", (String)VHScreenRecordService.this.mRoomId, null, null);
                    VHScreenRecordService.this.trackScreenShareEvent();
                    break;
                }
                case STOP: {
                    VHScreenRecordService.this.broStateChanged(1, null);
                    break;
                }
            }
        }

        public void onEvent(int i, String s) {
            VHScreenRecordService.this.broStateChanged(2, s);
        }

        public void onError(int i, int i1, String s) {
            VHScreenRecordService.this.broStateChanged(3, s);
        }
    };

    public IBinder onBind(Intent intent) {
        return new ScreenRecordServiceBinder();
    }

    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    public void onCreate() {
        super.onCreate();
        String CHANNEL_ONE_ID = "vhall_screen_record";
        String CHANNEL_ONE_NAME = "vhall screenRecord";
        NotificationChannel notificationChannel = null;
        Notification.Builder builder = new Notification.Builder((Context)this);
        if (Build.VERSION.SDK_INT >= 26) {
            notificationChannel = new NotificationChannel(CHANNEL_ONE_ID, (CharSequence)CHANNEL_ONE_NAME, 4);
            NotificationManager manager = (NotificationManager)this.getSystemService("notification");
            manager.createNotificationChannel(notificationChannel);
            builder.setChannelId(CHANNEL_ONE_ID);
        }
        Notification notification = builder.build();
        this.startForeground(1, notification);
    }

    public void onDestroy() {
        this.stop();
        super.onDestroy();
    }

    public void start(String roomId, String accessToken, VHLivePushConfig config, MediaProjection mp) {
        config.encodeType = 0;
        if (this.livePusher == null) {
            this.livePusher = new LivePusher((IVHCapture)new VHScreenCapture(config, mp), (IVHCapture)new VHAudioCapture(), config);
            this.livePusher.setListener(this.listener);
        }
        if (TextUtils.isEmpty((CharSequence)roomId) || TextUtils.isEmpty((CharSequence)accessToken)) {
            return;
        }
        switch (this.livePusher.getState()) {
            case START: {
                L.w((String)TAG, (String)"livepusher already started");
                break;
            }
            case STOP: 
            case IDLE: {
                this.disPatchURL(roomId, accessToken);
                break;
            }
            case END: {
                L.e((String)TAG, (String)"status error:audioCapture already released");
            }
        }
    }

    public void stop() {
        if (this.livePusher != null) {
            this.livePusher.stop();
            this.livePusher = null;
            try {
                JSONObject body = new JSONObject();
                body.put("type", (Object)"live_over");
                VHAPI.sendMsg((String)body.toString(), (String)(this.mAccessToken + ""), (String)"service_room", (String)(this.mRoomId + ""), null, null);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void broStateChanged(int state, String msg) {
        Intent intent = new Intent();
        intent.setAction(BROADCAST_ACTION);
        intent.putExtra("state", state);
        intent.putExtra("msg", msg);
        this.sendBroadcast(intent);
    }

    private void disPatchURL(final String roomId, final String accessToken) {
        if (this.dispatching) {
            return;
        }
        this.dispatching = true;
        this.listener.onEvent(-257, "");
        this.listener.onStateChanged(Constants.State.BUFFER);
        VHLssApi.getPublishInfo(roomId, accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                L.e((String)VHScreenRecordService.TAG, (String)e.getMessage());
                VHScreenRecordService.this.dispatching = false;
                VHScreenRecordService.this.trackInitEvent("-1");
                VHScreenRecordService.this.listener.onError(1, -1, "error network,please try later\uff01");
            }

            public void onResponse(Call call, Response response) throws IOException {
                VHScreenRecordService.this.dispatching = false;
                String content = response.body().string();
                try {
                    JSONObject result = new JSONObject(content);
                    String msg = result.optString("msg");
                    int code = result.optInt("code");
                    if (code == 200) {
                        JSONObject data = result.optJSONObject("data");
                        JSONObject pushObj = data.optJSONObject("publish_server");
                        JSONObject logObj = data.optJSONObject("log_info");
                        DispatchParam mDispatchParam = new DispatchParam();
                        JSONArray urllist = pushObj.optJSONArray("publish_domainname");
                        ArrayList<String> urls = new ArrayList<String>();
                        for (int i = 0; i < urllist.length(); ++i) {
                            urls.add(urllist.optString(i));
                        }
                        mDispatchParam.urls = urls;
                        JSONObject args = pushObj.optJSONObject("publish_args");
                        mDispatchParam.accesstoken = args.optString("accesstoken");
                        mDispatchParam.token = args.optString("token");
                        mDispatchParam.mixer = args.optString("mixer");
                        mDispatchParam.vhost = args.optString("vhost");
                        mDispatchParam.roomId = roomId;
                        LogInfo.getInstance().roomId = VHScreenRecordService.this.mRoomId;
                        VHScreenRecordService.this.mRoomId = roomId;
                        VHScreenRecordService.this.mAccessToken = accessToken;
                        VHScreenRecordService.this.mURL = mDispatchParam.getURL();
                        if (null != VHScreenRecordService.this.livePusher) {
                            VHScreenRecordService.this.livePusher.setLogParam(LogInfo.getInstance().toString());
                            VHScreenRecordService.this.livePusher.start(VHScreenRecordService.this.mURL);
                        }
                        VHScreenRecordService.this.trackInitEvent();
                    } else {
                        VHScreenRecordService.this.trackInitEvent(code + ":" + msg);
                        VHScreenRecordService.this.listener.onError(1, -1, msg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    VHScreenRecordService.this.listener.onError(1, -1, "\u521d\u59cb\u5316\u89c6\u9891\u4fe1\u606f\u5931\u8d25\uff01");
                    VHScreenRecordService.this.trackInitEvent("-2");
                }
            }
        });
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2002", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2002", params);
    }

    private void trackScreenShareEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("action", (Object)"start");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("113104", params);
    }

    public class ScreenRecordServiceBinder
    extends Binder {
        public VHScreenRecordService getService() {
            return VHScreenRecordService.this;
        }
    }

    private class DispatchParam {
        List<String> urls;
        String token = "";
        String mixer = "";
        String accesstoken = "";
        String vhost = "";
        String roomId;

        private DispatchParam() {
        }

        String getURL() {
            return this.urls.get(0) + "?vhost=" + this.vhost + "?token=" + this.token + "?webinar_id=" + this.roomId + "?ismix=0?mixserver=" + this.mixer + "?accesstoken=" + this.accesstoken + "/" + this.roomId;
        }
    }
}

