/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.lss.push;

import android.text.TextUtils;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.lss.VHLssApi;
import com.vhall.player.Constants;
import com.vhall.push.IVHCapture;
import com.vhall.push.LivePusher;
import com.vhall.push.VHLivePushConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHLivePusher
extends LivePusher {
    private static final String TAG = "VHLivePusher";
    private String mRoomId;
    private String mAccessToken;
    private String mURL;
    private String logReportRoomId = "";
    private boolean dispatching = false;

    public VHLivePusher(IVHCapture videoCapture, IVHCapture audioCapture, VHLivePushConfig config) {
        super(videoCapture, audioCapture, config);
        this.setIdentifier(VhallSDK.getInstance().getAPP_ID());
    }

    public void setLogReportRoomId(String logReportRoomId) {
        this.logReportRoomId = logReportRoomId;
    }

    public void start(String roomId, String accessToken) {
        if (TextUtils.isEmpty((CharSequence)roomId) || TextUtils.isEmpty((CharSequence)accessToken)) {
            return;
        }
        switch (this.getState()) {
            case START: {
                L.w((String)TAG, (String)"livepusher already started");
                break;
            }
            case IDLE: 
            case STOP: {
                this.disPatchURL(roomId, accessToken);
                break;
            }
            case END: {
                L.e((String)TAG, (String)"status error:audioCapture already released");
            }
        }
    }

    public void pause() {
        super.pause();
        JSONObject body = new JSONObject();
        try {
            body.put("type", (Object)"live_over");
            body.put("room", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        VHAPI.sendMsg((String)body.toString(), (String)this.mAccessToken, (String)"service_room", (String)this.mRoomId, null, null);
    }

    protected void changeState(Constants.State state) {
        super.changeState(state);
        switch (state) {
            case START: {
                JSONObject body = new JSONObject();
                try {
                    body.put("type", (Object)"live_start");
                    body.put("room", (Object)this.mRoomId);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                VHAPI.sendMsg((String)body.toString(), (String)this.mAccessToken, (String)"service_room", (String)this.mRoomId, null, (Callback)new Callback(){

                    public void onFailure(Call call, IOException e) {
                        VLog.e((String)"Jooper", (String)"---> onFailure");
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        VLog.e((String)"Jooper", (String)("---> onResponse " + response.body().string()));
                    }
                });
            }
        }
    }

    private void disPatchURL(final String roomId, final String accessToken) {
        if (this.dispatching) {
            return;
        }
        this.dispatching = true;
        this.sendEvent(-257, "");
        this.changeState(Constants.State.BUFFER);
        VHLssApi.getPublishInfo(roomId, accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                L.e((String)VHLivePusher.TAG, (String)e.getMessage());
                VHLivePusher.this.dispatching = false;
                VHLivePusher.this.trackInitEvent("-1");
                VHLivePusher.this.mDispatcher.post(new Runnable(){

                    @Override
                    public void run() {
                        VHLivePusher.this.sendError(1, -1, "error network,please try later\uff01");
                    }
                });
            }

            public void onResponse(Call call, Response response) throws IOException {
                VHLivePusher.this.dispatching = false;
                final String content = response.body().string();
                VHLivePusher.this.mDispatcher.post(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(content);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                JSONObject data = result.optJSONObject("data");
                                JSONObject pushObj = data.optJSONObject("publish_server");
                                JSONObject logObj = data.optJSONObject("log_info");
                                logObj.put("room_id", (Object)roomId);
                                DispatchParam mDispatchParam = new DispatchParam();
                                JSONArray urllist = pushObj.optJSONArray("publish_domainname");
                                ArrayList<String> urls = new ArrayList<String>();
                                for (int i = 0; i < urllist.length(); ++i) {
                                    urls.add(urllist.optString(i));
                                }
                                mDispatchParam.urls = urls;
                                JSONObject args = pushObj.optJSONObject("publish_args");
                                mDispatchParam.accesstoken = args.optString("accesstoken");
                                mDispatchParam.token = args.optString("token");
                                mDispatchParam.mixer = args.optString("mixer");
                                mDispatchParam.vhost = args.optString("vhost");
                                mDispatchParam.roomId = roomId;
                                VHLivePusher.this.mRoomId = roomId;
                                VHLivePusher.this.mAccessToken = accessToken;
                                String pushUrl = data.optString("pushUrl");
                                if (TextUtils.isEmpty((CharSequence)pushUrl)) {
                                    VHLivePusher.this.mURL = mDispatchParam.getURL();
                                } else {
                                    VHLivePusher.this.mURL = pushUrl;
                                }
                                LogInfo.getInstance().roomId = !TextUtils.isEmpty((CharSequence)VHLivePusher.this.logReportRoomId) ? VHLivePusher.this.logReportRoomId : VHLivePusher.this.mRoomId;
                                if (logObj != null) {
                                    VLog.d((String)VHLivePusher.TAG, (String)logObj.toString());
                                    LogInfo.getInstance().initBaseData(logObj);
                                }
                                VHLivePusher.this.setLogParam(LogInfo.getInstance().toString());
                                VHLivePusher.this.start(VHLivePusher.this.mURL);
                                VHLivePusher.this.trackInitEvent();
                            } else {
                                VHLivePusher.this.trackInitEvent(code + ":" + msg);
                                VHLivePusher.this.sendError(1, -1, msg);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            VHLivePusher.this.sendError(1, -1, "\u521d\u59cb\u5316\u89c6\u9891\u4fe1\u606f\u5931\u8d25\uff01");
                            VHLivePusher.this.trackInitEvent("-2");
                        }
                    }
                });
            }
        });
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2002", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2002", params);
    }

    private class DispatchParam {
        List<String> urls;
        String token = "";
        String mixer = "";
        String accesstoken = "";
        String vhost = "";
        String roomId;

        private DispatchParam() {
        }

        String getURL() {
            return this.urls.get(0) + "?vhost=" + this.vhost + "?token=" + this.token + "?webinar_id=" + this.roomId + "?ismix=0?mixserver=" + this.mixer + "?accesstoken=" + this.accesstoken + "/" + this.roomId;
        }
    }
}

