/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.lss.play;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.SurfaceView;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.lss.VHLssApi;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.player.MPlayer;
import com.vhall.player.VHPlayer;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHAudioPlayer;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.vod.VodPlayerView;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class VHTimeShiftPlayer
implements VHPlayer,
IVHService {
    private static final String TAG = "VHTimeShiftPlayer";
    private MPlayer mPlayer;
    private boolean mLoading = false;
    private VHPlayerListener mListener;
    private Handler mDispatcher;
    private String mRoomId;
    private String mAccessToken;
    private String mDispatchURL;
    private String mDefaultURLS;
    private String waterMarkUrl = "";
    private float waterMarkAlpha = 1.0f;
    private int waterMarkGravity = 0;
    private VodPlayerView vodPlayerView;
    private Context mContext;
    private boolean enable_projection_screen = true;
    private int live_duration;
    private int delay;
    private String mCDNPriority = "";
    private boolean is_default_live_subtitle;
    private boolean is_live_subtitle = this.is_default_live_subtitle = false;
    private int live_subtitle = 0;
    private String live_subtitle_mps = "";
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;

    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        this.mOnConnectChangedListener = listener;
    }

    private VHTimeShiftPlayer(Context context) {
        this.mPlayer = new MPlayer(context, 3);
        this.mContext = context;
        this.mDispatcher = new Handler(Looper.getMainLooper());
        VhallSDK.getInstance().join((IVHService)this);
    }

    public int getLive_duration() {
        return this.live_duration;
    }

    public void start(String roomId, String accessToken) {
        this.start(roomId, accessToken, 90);
    }

    public void start(String roomId, String accessToken, int delay) {
        if (TextUtils.isEmpty((CharSequence)roomId) || TextUtils.isEmpty((CharSequence)accessToken)) {
            L.e((String)TAG, (String)"roomId or accessToken should not be null");
            return;
        }
        this.delay = delay;
        this.disPatchURL(roomId, accessToken);
    }

    public Constants.State getState() {
        return this.mPlayer.getState();
    }

    public void setDisplay(SurfaceView surfaceView) {
    }

    public void setDisplay(VodPlayerView vodPlayerView) {
        if (vodPlayerView == null) {
            return;
        }
        this.mContext = vodPlayerView.getContext();
        this.vodPlayerView = vodPlayerView;
        if (this.mPlayer != null) {
            this.mPlayer.setDisplay(vodPlayerView);
        }
    }

    public void startPlay(String s) {
        this.mPlayer.startPlay(s);
    }

    public boolean resumeAble() {
        return !TextUtils.isEmpty((CharSequence)this.mDispatchURL);
    }

    public void setDPI(String dpi) {
        this.mPlayer.setDefinition(dpi);
    }

    public void setDefaultRealtimeSubtitle(boolean open_live_subtitle) {
        this.is_default_live_subtitle = open_live_subtitle;
        this.is_live_subtitle = open_live_subtitle;
    }

    public void setRealtimeSubtitle(boolean open_live_subtitle) {
        this.is_live_subtitle = open_live_subtitle;
        if (!TextUtils.isEmpty((CharSequence)this.live_subtitle_mps)) {
            this.mPlayer.setLiveSubtitleMPS(this.is_live_subtitle && !TextUtils.isEmpty((CharSequence)this.live_subtitle_mps) ? this.mPlayer.mDispatcher.live_subtitle_mps : "");
        } else if (this.live_subtitle == 1) {
            this.mPlayer.setLiveSubtitle(this.is_live_subtitle && this.live_subtitle == 1 ? 1 : 0);
        }
    }

    public String getDpi() {
        return this.mPlayer.mDispatcher.mCurrentDPI;
    }

    public void pushMsgInfo() {
        this.mPlayer.pushMsgInfo();
    }

    public void stop() {
        this.mPlayer.stop();
    }

    public void pause() {
        this.mPlayer.pause();
    }

    public void resume() {
        this.mPlayer.resume();
    }

    public void release() {
        VhallSDK.getInstance().leave((IVHService)this);
        this.mListener = null;
        this.mPlayer.setListener(null);
        this.mPlayer.stop();
        this.mPlayer.release();
        this.mPlayer = null;
    }

    public void seekto(long l) {
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    public void setLogParam(String s) {
    }

    public void setVideoPlayer(IVHVideoPlayer ivhVideoPlayer) {
    }

    public void setAudioPlayer(IVHAudioPlayer ivhAudioPlayer) {
    }

    public float setSpeed(float i) {
        return 1.0f;
    }

    public long getPosition() {
        return 0L;
    }

    public long getDuration() {
        return 0L;
    }

    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.isPlaying();
        }
        return false;
    }

    public void setListener(VHPlayerListener listener) {
        this.mListener = listener;
        this.mPlayer.setListener(listener);
    }

    public void setDrawMode(int i) {
        this.mPlayer.setDrawMode(i);
    }

    public String getChannelId() {
        return this.mRoomId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public int getRealityBufferTime() {
        return this.mPlayer.getRealityBufferTime();
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.mOnConnectChangedListener != null) {
            this.mOnConnectChangedListener.onStateChanged(state, serverType);
        }
    }

    public void onMessage(String msg) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            try {
                JSONObject obj = new JSONObject(msg);
                String serviceType = obj.optString("service_type");
                if (TextUtils.isEmpty((CharSequence)serviceType)) {
                    return;
                }
                if (!serviceType.equals("service_room")) {
                    return;
                }
                String dataStr = obj.optString("data");
                JSONObject data = new JSONObject(dataStr);
                String type = data.optString("type");
                if (!TextUtils.isEmpty((CharSequence)type)) {
                    if (type.equals("live_start")) {
                        this.sendEvent(-272, data == null ? "" : data.toString());
                    } else if (type.equals("live_over")) {
                        this.sendEvent(-273, data == null ? "" : data.toString());
                    } else if (type.equals("live_converted")) {
                        this.mPlayer.pushMsgInfo();
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public String getOriginalUrl() {
        if (this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    private void disPatchURL(final String roomId, final String accessToken) {
        if (this.mLoading) {
            return;
        }
        this.mLoading = true;
        this.mRoomId = roomId;
        this.mAccessToken = accessToken;
        VHLssApi.getWatchLiveInfo(roomId, accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                VHTimeShiftPlayer.this.mLoading = false;
                VHTimeShiftPlayer.this.trackInitEvent("-1");
                VHTimeShiftPlayer.this.sendEvent(-1, "error network,please try later\uff01");
            }

            public void onResponse(Call call, Response response) throws IOException {
                String content = response.body().string();
                if (VHTimeShiftPlayer.this.getData(content, roomId, accessToken)) {
                    VHTimeShiftPlayer.this.sendEvent(-256, "init success");
                    if (VHTimeShiftPlayer.this.mPlayer != null) {
                        VHTimeShiftPlayer.this.sendEvent(-266, "{\"live_subtitle\":" + VHTimeShiftPlayer.this.live_subtitle + ",\"live_subtitle_mps\":\"" + VHTimeShiftPlayer.this.live_subtitle_mps + "\"}");
                    }
                    if (VHTimeShiftPlayer.this.mPlayer != null) {
                        VHTimeShiftPlayer.this.start();
                    }
                }
                VHTimeShiftPlayer.this.mLoading = false;
            }
        });
    }

    private void start() {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.setLogParam(LogInfo.getInstance().toString());
        this.mPlayer.startPlay(this.mDispatchURL, this.mDefaultURLS, this.mCDNPriority, (long)this.delay);
        if (this.waterMarkGravity != 0 && this.vodPlayerView != null) {
            this.setWaterMark();
        }
    }

    public void prepare(String streamUrl) {
    }

    private boolean getData(String json, String roomid, String accessToken) {
        boolean success = false;
        try {
            JSONObject result = new JSONObject(json);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject data = result.optJSONObject("data");
                JSONObject server = data.optJSONObject("default_server");
                JSONObject logObj = data.optJSONObject("log_info");
                int live_type = data.optInt("live_type", 0);
                if (live_type != 1) {
                    this.sendError(-1, "not support time shift");
                    this.trackInitEvent(code + ":not support time shift");
                    return false;
                }
                int streamStatus = data.has("stream_status") ? data.optInt("stream_status") : 1;
                if (streamStatus == 1) {
                    JSONObject projectionScreen;
                    int gravity;
                    LogInfo.getInstance().roomId = roomid;
                    if (logObj != null) {
                        LogInfo.getInstance().initBaseData(logObj);
                    }
                    this.live_subtitle = data.optInt("live_subtitle", 0);
                    int live_delay = data.optInt("live_delay", 0);
                    if (this.mPlayer != null) {
                        this.mPlayer.setLiveSubtitle(this.is_live_subtitle && this.live_subtitle == 1 ? 1 : 0);
                        this.live_subtitle_mps = data.optString("live_subtitle_mps", "");
                        this.mPlayer.setLiveSubtitleMPS(this.is_live_subtitle && !TextUtils.isEmpty((CharSequence)this.live_subtitle_mps) ? this.live_subtitle_mps : "");
                    }
                    String dispatch_server = data.optString("dispatch_server");
                    String rand = server.optString("rand");
                    int app_type = data.optInt("app_type");
                    this.live_duration = data.optInt("live_duration");
                    this.mDispatchURL = dispatch_server + "/api/dispatch_play?webinar_id=" + roomid + "&rand=" + rand + "&uid=id&bu=1&app_type=" + app_type + "&is_subtitle=" + this.live_subtitle + "&is_delay_stream=" + live_delay;
                    result.put("data", (Object)server);
                    this.mDefaultURLS = result.toString();
                    L.i((String)TAG, (String)("mDefaultURLS:" + this.mDefaultURLS));
                    JSONObject waterMark = data.optJSONObject("watermark");
                    String url = waterMark.optString("url");
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        this.waterMarkUrl = url;
                    }
                    if ((gravity = waterMark.optInt("position")) > 0) {
                        this.waterMarkGravity = gravity;
                    }
                    if ((projectionScreen = data.optJSONObject("projection_screen")) != null) {
                        this.enable_projection_screen = projectionScreen.optBoolean("enable", true);
                    }
                    this.mCDNPriority = data.optString("cdn_priority", "");
                    success = true;
                } else {
                    this.sendEvent(-275, "There is no stream push !");
                }
                this.trackInitEvent();
            } else {
                this.sendError(-1, msg);
                this.trackInitEvent(code + ":" + msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trackInitEvent("-2");
        }
        return success;
    }

    public boolean getProjectionScreen() {
        return this.enable_projection_screen;
    }

    private void sendEvent(final int code, final String msg) {
        this.mDispatcher.post(new Runnable(){

            @Override
            public void run() {
                if (VHTimeShiftPlayer.this.mListener != null) {
                    VHTimeShiftPlayer.this.mListener.onEvent(code, msg);
                }
            }
        });
    }

    private void sendError(final int code, final String msg) {
        this.mDispatcher.post(new Runnable(){

            @Override
            public void run() {
                if (VHTimeShiftPlayer.this.mListener != null) {
                    VHTimeShiftPlayer.this.mListener.onError(code, 0, msg);
                }
            }
        });
    }

    public void setWaterMark(String url, int gravity, float alpha) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.waterMarkUrl = url;
        }
        if (gravity > 0) {
            this.waterMarkGravity = gravity;
        }
        this.waterMarkAlpha = alpha;
    }

    private void setWaterMark() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(VHTimeShiftPlayer.this.waterMarkUrl);
                    HttpURLConnection conn = VHTimeShiftPlayer.this.waterMarkUrl.contains("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)conn.getInputStream());
                    BitmapDrawable drawable = new BitmapDrawable(VHTimeShiftPlayer.this.mContext.getResources(), bitmap);
                    VHTimeShiftPlayer.this.mDispatcher.post(new Runnable(){
                        final /* synthetic */ Drawable val$drawable;
                        {
                            this.val$drawable = drawable;
                        }

                        @Override
                        public void run() {
                            if (VHTimeShiftPlayer.this.vodPlayerView != null) {
                                VHTimeShiftPlayer.this.vodPlayerView.setWaterMark(this.val$drawable);
                                VHTimeShiftPlayer.this.vodPlayerView.setWaterMarkAlpha(VHTimeShiftPlayer.this.waterMarkAlpha);
                                switch (VHTimeShiftPlayer.this.waterMarkGravity) {
                                    case 1: {
                                        VHTimeShiftPlayer.this.vodPlayerView.setWaterMarkGravity(3);
                                        break;
                                    }
                                    case 2: {
                                        VHTimeShiftPlayer.this.vodPlayerView.setWaterMarkGravity(5);
                                        break;
                                    }
                                    case 3: {
                                        VHTimeShiftPlayer.this.vodPlayerView.setWaterMarkGravity(85);
                                        break;
                                    }
                                    case 4: {
                                        VHTimeShiftPlayer.this.vodPlayerView.setWaterMarkGravity(83);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void setmConnectTimeout(int mConnectTimeout) {
        this.mPlayer.setmBufferSeconds(mConnectTimeout);
    }

    public void setmReconnectTimes(int mReconnectTimes) {
        this.mPlayer.setmReconnectTimes(mReconnectTimes);
    }

    public void setmBufferSeconds(int mBufferSeconds) {
        this.mPlayer.setmBufferSeconds(mBufferSeconds);
    }

    private void setmDecodeMode(int mDecodeMode) {
        this.mPlayer.setmDecodeMode(mDecodeMode);
    }

    private void setmStreamType(int mStreamType) {
        this.mPlayer.setmStreamType(mStreamType);
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2003", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2010", params);
    }

    public static class Builder {
        VHTimeShiftPlayer player;

        public Builder(Context context) {
            this.player = new VHTimeShiftPlayer(context);
        }

        public Builder audioPlayer(IVHAudioPlayer audioPlayer) {
            this.player.setAudioPlayer(audioPlayer);
            return this;
        }

        public Builder videoPlayer(VodPlayerView videoPlayer) {
            this.player.setDisplay(videoPlayer);
            return this;
        }

        public Builder listener(VHPlayerListener listener) {
            this.player.setListener(listener);
            return this;
        }

        public Builder bufferSeconds(int bufferSeconds) {
            if (bufferSeconds > 0) {
                this.player.setmBufferSeconds(bufferSeconds);
            }
            return this;
        }

        public Builder reconnectTimes(int reconnectTimes) {
            if (reconnectTimes > 0) {
                this.player.setmReconnectTimes(reconnectTimes);
            }
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout > 0) {
                this.player.setmConnectTimeout(connectTimeout);
            }
            return this;
        }

        public VHTimeShiftPlayer build(Context context) {
            return this.player;
        }
    }
}

