/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.lss.play;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.SurfaceView;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.lss.VHLssApi;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayer;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.RtcLivePlayer;
import com.vhall.player.stream.play.IVHAudioPlayer;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.stream.play.impl.VHVideoPlayerView;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class VHFastLivePlayer
implements VHPlayer,
IVHService {
    private static final String TAG = "VHFastLivePlayer";
    private RtcLivePlayer mPlayer;
    private boolean mLoading = false;
    private VHPlayerListener mListener;
    private Handler mDispatcher;
    private String mRoomId;
    private String mInavId;
    private String mUserId;
    private String mAccessToken;
    private String mDispatchURL;
    private String mDefaultURLS;
    private String waterMarkUrl = "";
    private float waterMarkAlpha = 1.0f;
    private int waterMarkGravity = 0;
    private IVHVideoPlayer videoPlayer;
    private Context mContext;
    private boolean enable_projection_screen = true;
    private String mRtcScheduleServer = null;
    private final String STREAMPATH_START = "/vrtc/v1/startPullStream";
    private final String STREAMPATH_STOP = "/vrtc/v1/stopPullStream";
    private final String HOST_WEBRTC = "webrtc://vrtc.liveplay.vhall.com/";
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;

    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        this.mOnConnectChangedListener = listener;
    }

    public void initPlayer(Context context) {
        this.mPlayer = new RtcLivePlayer(context);
        this.mPlayer.setLogParam(LogInfo.getInstance().toString());
        this.mDispatcher = new Handler(Looper.getMainLooper());
    }

    public void start(String lssRoomId, String inavId, String accessToken) {
        if (TextUtils.isEmpty((CharSequence)inavId)) {
            L.e((String)TAG, (String)"inavId should not be null");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)lssRoomId) || TextUtils.isEmpty((CharSequence)accessToken)) {
            L.e((String)TAG, (String)"roomId or accessToken should not be null");
            return;
        }
        if (this.mPlayer.getState() == Constants.State.START) {
            L.e((String)TAG, (String)"player has already started");
            return;
        }
        this.mInavId = inavId;
        this.disPatchURL(lssRoomId, accessToken);
    }

    public Constants.State getState() {
        return this.mPlayer.getState();
    }

    public void setDisplay(SurfaceView surfaceView) {
        this.mPlayer.setDisplay(surfaceView);
    }

    public void startPlay(String s) {
        this.mPlayer.startPlay(s);
    }

    public boolean resumeAble() {
        return !TextUtils.isEmpty((CharSequence)this.mDispatchURL);
    }

    public void stop() {
        this.mPlayer.stop();
    }

    public void pause() {
        this.mPlayer.pause();
    }

    public void resume() {
        this.mPlayer.resume();
    }

    public void release() {
        VhallSDK.getInstance().leave((IVHService)this);
        this.mListener = null;
        if (null != this.mPlayer) {
            this.mPlayer.setListener(null);
            this.mPlayer.stop();
            this.mPlayer.release();
        }
        this.mPlayer = null;
    }

    public void seekto(long l) {
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    public void setLogParam(String s) {
    }

    public void setVideoPlayer(IVHVideoPlayer ivhVideoPlayer) {
    }

    public void setAudioPlayer(IVHAudioPlayer ivhAudioPlayer) {
    }

    public float setSpeed(float i) {
        return 1.0f;
    }

    public long getPosition() {
        return 0L;
    }

    public long getDuration() {
        return 0L;
    }

    public boolean isPlaying() {
        if (this.mPlayer != null) {
            return this.mPlayer.isPlaying();
        }
        return false;
    }

    public void setListener(VHPlayerListener listener) {
        this.mListener = listener;
        this.mPlayer.setListener(listener);
    }

    public void setDrawMode(int i) {
        this.mPlayer.setDrawMode(i);
    }

    public String getChannelId() {
        return this.mRoomId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.mOnConnectChangedListener != null) {
            this.mOnConnectChangedListener.onStateChanged(state, serverType);
        }
    }

    public void changeStreamResolution(int resolution) {
        if (null != this.mPlayer) {
            this.mPlayer.changeStreamResolution(resolution);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) return;
        try {
            JSONObject obj = new JSONObject(msg);
            String serviceType = obj.optString("service_type");
            if (TextUtils.isEmpty((CharSequence)serviceType)) {
                return;
            }
            if (!serviceType.equals("service_room")) {
                return;
            }
            String dataStr = obj.optString("data");
            JSONObject data = new JSONObject(dataStr);
            String type = data.optString("type");
            if (TextUtils.isEmpty((CharSequence)type)) return;
            if (type.equals("live_start")) {
                this.sendEvent(-272, data == null ? "" : data.toString());
                return;
            }
            if (type.equals("live_over")) {
                this.sendEvent(-273, data == null ? "" : data.toString());
                return;
            }
            if (!type.equals("live_converted")) return;
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void disPatchURL(final String roomId, final String accessToken) {
        if (this.mLoading) {
            return;
        }
        this.mLoading = true;
        this.mRoomId = roomId;
        this.mAccessToken = accessToken;
        VHLssApi.getWatchLiveInfo(roomId, accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                VHFastLivePlayer.this.mLoading = false;
                VHFastLivePlayer.this.trackInitEvent("-1");
                VHFastLivePlayer.this.sendEvent(-1, "error network,please try later\uff01");
            }

            public void onResponse(Call call, Response response) throws IOException {
                String content = response.body().string();
                if (VHFastLivePlayer.this.getData(content, roomId, accessToken)) {
                    VHFastLivePlayer.this.sendEvent(-256, "init success");
                    if (VHFastLivePlayer.this.mPlayer != null) {
                        VHFastLivePlayer.this.start();
                    }
                }
                VHFastLivePlayer.this.mLoading = false;
            }
        });
    }

    private void start() {
        if (this.mPlayer == null) {
            return;
        }
        this.mPlayer.setLogParam(LogInfo.getInstance().toString());
        this.mPlayer.startPlay(this.getStreamStartUrl(), this.getStreamStopUrl(), this.getWebRtcUrl(), this.getInavId(), this.mUserId);
        VhallSDK.getInstance().join((IVHService)this);
        if (this.waterMarkGravity != 0 && this.videoPlayer != null && this.videoPlayer instanceof VHVideoPlayerView && ((VHVideoPlayerView)this.videoPlayer).getWaterMark() == null) {
            this.setWaterMark();
        }
    }

    private String getStreamStartUrl() {
        return this.mRtcScheduleServer + "/vrtc/v1/startPullStream";
    }

    private String getStreamStopUrl() {
        return this.mRtcScheduleServer + "/vrtc/v1/stopPullStream";
    }

    private String getWebRtcUrl() {
        return "webrtc://vrtc.liveplay.vhall.com/" + this.mInavId;
    }

    private String getInavId() {
        return this.mInavId;
    }

    public void prepare(String streamUrl) {
    }

    private boolean getData(String json, String roomid, String accessToken) {
        boolean success = false;
        try {
            JSONObject result = new JSONObject(json);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject data = result.optJSONObject("data");
                JSONObject server = data.optJSONObject("default_server");
                JSONObject logObj = data.optJSONObject("log_info");
                int streamStatus = data.has("stream_status") ? data.optInt("stream_status") : 1;
                if (streamStatus == 1) {
                    JSONObject projectionScreen;
                    int gravity;
                    LogInfo.getInstance().roomId = roomid;
                    if (logObj != null) {
                        LogInfo.getInstance().initBaseData(logObj);
                        this.mUserId = logObj.optString("uid");
                    }
                    int support_live_subtitle = data.optInt("live_subtitle", 0);
                    int live_delay = data.optInt("live_delay", 0);
                    String dispatch_server = data.optString("dispatch_server");
                    String rand = server.optString("rand");
                    int app_type = data.optInt("app_type");
                    this.mDispatchURL = dispatch_server + "/api/dispatch_play?webinar_id=" + roomid + "&rand=" + rand + "&uid=id&bu=1&app_type=" + app_type + "&is_subtitle=" + support_live_subtitle + "&is_delay_stream=" + live_delay;
                    result.put("data", (Object)server);
                    this.mDefaultURLS = result.toString();
                    L.i((String)TAG, (String)("mDefaultURLS:" + this.mDefaultURLS));
                    JSONObject waterMark = data.optJSONObject("watermark");
                    String url = waterMark.optString("url");
                    if (!TextUtils.isEmpty((CharSequence)url)) {
                        this.waterMarkUrl = url;
                    }
                    if ((gravity = waterMark.optInt("position")) > 0) {
                        this.waterMarkGravity = gravity;
                    }
                    if ((projectionScreen = data.optJSONObject("projection_screen")) != null) {
                        this.enable_projection_screen = projectionScreen.optBoolean("enable", true);
                    }
                    this.mRtcScheduleServer = data.optString("rtc_schedule_server");
                    success = true;
                } else {
                    this.sendEvent(-275, "There is no stream push !");
                }
                this.trackInitEvent();
            } else {
                this.sendError(-1, msg);
                this.trackInitEvent(code + ":" + msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trackInitEvent("-2");
        }
        return success;
    }

    public boolean getProjectionScreen() {
        return this.enable_projection_screen;
    }

    private void sendEvent(final int code, final String msg) {
        this.mDispatcher.post(new Runnable(){

            @Override
            public void run() {
                if (VHFastLivePlayer.this.mListener != null) {
                    VHFastLivePlayer.this.mListener.onEvent(code, msg);
                }
            }
        });
    }

    private void sendError(final int code, final String msg) {
        this.mDispatcher.post(new Runnable(){

            @Override
            public void run() {
                if (VHFastLivePlayer.this.mListener != null) {
                    VHFastLivePlayer.this.mListener.onError(code, 0, msg);
                }
            }
        });
    }

    public void setWaterMark(String url, int gravity, float alpha) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.waterMarkUrl = url;
        }
        if (gravity > 0) {
            this.waterMarkGravity = gravity;
        }
        this.waterMarkAlpha = alpha;
    }

    private void setWaterMark() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(VHFastLivePlayer.this.waterMarkUrl);
                    HttpURLConnection conn = VHFastLivePlayer.this.waterMarkUrl.contains("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)conn.getInputStream());
                    BitmapDrawable drawable = new BitmapDrawable(VHFastLivePlayer.this.mContext.getResources(), bitmap);
                    VHFastLivePlayer.this.mDispatcher.post(new Runnable(){
                        final /* synthetic */ Drawable val$drawable;
                        {
                            this.val$drawable = drawable;
                        }

                        @Override
                        public void run() {
                            if (VHFastLivePlayer.this.videoPlayer != null && ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).getWaterMark() == null) {
                                ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).setWaterMark(this.val$drawable);
                                ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).setWaterMarkAlpha(VHFastLivePlayer.this.waterMarkAlpha);
                                switch (VHFastLivePlayer.this.waterMarkGravity) {
                                    case 1: {
                                        ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).setWaterMarkGravity(3);
                                        break;
                                    }
                                    case 2: {
                                        ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).setWaterMarkGravity(5);
                                        break;
                                    }
                                    case 3: {
                                        ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).setWaterMarkGravity(85);
                                        break;
                                    }
                                    case 4: {
                                        ((VHVideoPlayerView)VHFastLivePlayer.this.videoPlayer).setWaterMarkGravity(83);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void setmConnectTimeout(int mConnectTimeout) {
        this.mPlayer.setConnectTimeout(mConnectTimeout);
    }

    public void setmReconnectTimes(int mReconnectTimes) {
        this.mPlayer.setReconnectTimes(mReconnectTimes);
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2003", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", (Object)this.mRoomId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2003", params);
    }

    public static class Builder {
        VHFastLivePlayer player = new VHFastLivePlayer();

        public Builder init(Context context) {
            this.player.initPlayer(context);
            return this;
        }

        public Builder listener(VHPlayerListener listener) {
            this.player.setListener(listener);
            return this;
        }

        public Builder reconnectTimes(int reconnectTimes) {
            if (reconnectTimes > 0) {
                this.player.setmReconnectTimes(reconnectTimes);
            }
            return this;
        }

        public Builder connectTimeout(int connectTimeout) {
            if (connectTimeout > 0) {
                this.player.setmConnectTimeout(connectTimeout);
            }
            return this;
        }

        public Builder setDisplay(SurfaceView surfaceView) {
            this.player.setDisplay(surfaceView);
            return this;
        }

        public VHFastLivePlayer build() {
            return this.player;
        }
    }
}

