package com.vhall.lss.push;


import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.Service;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.text.TextUtils;

import com.vhall.framework.VHAPI;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.lss.VHLssApi;
import com.vhall.player.Constants;
import com.vhall.player.VHPlayerListener;
import com.vhall.push.LivePusher;
import com.vhall.push.VHAudioCapture;
import com.vhall.push.VHLivePushConfig;
import com.vhall.push.VHLivePushFormat;
import com.vhall.push.VHScreenCapture;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;


/**
 * Created by zwp on 2019-08-16
 */
public class VHScreenRecordService extends Service {

    private static final String TAG = "VHScreenRecordService";
    public static final String BROADCAST_ACTION = "com.vhall.aps.status";
    private LivePusher livePusher;
    private String mRoomId;
    private String mAccessToken;
    private String mURL;
    private boolean dispatching = false;
    private VHPlayerListener listener = new VHPlayerListener() {
        @Override
        public void onStateChanged(Constants.State state) {
            switch (state) {
                case START:
                    broStateChanged(0,null);
                    JSONObject body = new JSONObject();
                    try {
                        body.put("type", VHLssApi.TYPE_STREAM_START);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    VHAPI.sendMsg(body.toString(), mAccessToken, VHLssApi.TYPE_ROOM, mRoomId, null, null);//给服务器发消息，流已停止

                    trackScreenShareEvent();
                    break;
                case STOP:
                    broStateChanged(1,null);
                    break;
                case END:

                    break;
            }
        }

        @Override
        public void onEvent(int i, String s) {
            broStateChanged(2,s);
        }

        @Override
        public void onError(int i, int i1, String s) {
            broStateChanged(3,s);
        }
    };

    @Override
    public IBinder onBind(Intent intent) {
        return new ScreenRecordServiceBinder();
    }

    public class ScreenRecordServiceBinder extends Binder {
        public VHScreenRecordService getService() {
            return VHScreenRecordService.this;
        }
    }

    @Override
    public boolean onUnbind(Intent intent) {
        return super.onUnbind(intent);
    }

    @Override
    public void onCreate() {
        super.onCreate();
        String CHANNEL_ONE_ID = "vhall_screen_record";
        String CHANNEL_ONE_NAME = "vhall screenRecord";
        NotificationChannel notificationChannel = null;
        Notification.Builder builder = new Notification.Builder(this);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
            notificationChannel = new NotificationChannel(CHANNEL_ONE_ID, CHANNEL_ONE_NAME, NotificationManager.IMPORTANCE_HIGH);
            NotificationManager manager = (NotificationManager) getSystemService(NOTIFICATION_SERVICE);
            manager.createNotificationChannel(notificationChannel);
            builder.setChannelId(CHANNEL_ONE_ID);
        }
        Notification notification = builder.build();
        startForeground(1, notification);
    }

    @Override
    public void onDestroy() {
        stop();
        super.onDestroy();
    }

    public void start(String roomId, String accessToken, VHLivePushConfig config, MediaProjection mp) {
        config.encodeType = VHLivePushFormat.ENCODE_TYPE_SOFT;
        if (livePusher == null) {
            livePusher = new LivePusher(new VHScreenCapture(config, mp), new VHAudioCapture(), config);
            livePusher.setListener(listener);
        }
        if (TextUtils.isEmpty(roomId) || TextUtils.isEmpty(accessToken))
            return;
        switch (livePusher.getState()) {
            case START:
                L.w(TAG, "livepusher already started");
                break;
            case IDLE:
            case STOP:
                disPatchURL(roomId, accessToken);
                break;
            case END:
                L.e(TAG, "status error:audioCapture already released");
                break;
        }
    }

    /**
     * 停止录屏直播
     */
    public void stop() {
        if (livePusher != null) {
            livePusher.stop();
            livePusher = null;
            try {
                JSONObject body = new JSONObject();
                body.put("type", VHLssApi.TYPE_STREAM_STOP);
                VHAPI.sendMsg(body.toString(), mAccessToken+"", VHLssApi.TYPE_ROOM, mRoomId+"", null, null);//给服务器发消息，流已停止
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    //0 开始 1 结束 2 推流速率  3 错误
    private void broStateChanged(int state, String msg) {
        Intent intent = new Intent();
        intent.setAction(BROADCAST_ACTION);
        intent.putExtra("state", state);
        intent.putExtra("msg", msg);
        sendBroadcast(intent);
    }

    private void disPatchURL(final String roomId, final String accessToken) {
        if (dispatching)
            return;
        dispatching = true;

        //TODO 20190726 by zwp demo与文档中不再显示该事件，推荐使用BUFFER状态代替；
        //一段时间后可以删除EVENT_STATUS_STARING 事件；
        listener.onEvent(Constants.Event.EVENT_STATUS_STARTING, "");
        listener.onStateChanged(Constants.State.BUFFER);
        VHLssApi.getPublishInfo(roomId, accessToken, new Callback() {

            @Override
            public void onFailure(Call call, IOException e) {
                L.e(TAG, e.getMessage());
                dispatching = false;
                trackInitEvent(LogReporter.LOG_ERROR_NET);
                listener.onError(Constants.ErrorCode.ERROR_PUSH, Constants.ErrorCode.ERROR_CONNECT, "error network,please try later！");
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                dispatching = false;
                final String content = response.body().string();
                try {
                    JSONObject result = new JSONObject(content);
                    String msg = result.optString("msg");
                    int code = result.optInt("code");
                    if (code == 200) {
                        JSONObject data = result.optJSONObject("data");
                        JSONObject pushObj = data.optJSONObject("publish_server");
                        JSONObject logObj = data.optJSONObject("log_info");
                        DispatchParam mDispatchParam = new DispatchParam();
                        //param
                        JSONArray urllist = pushObj.optJSONArray("publish_domainname");
                        List<String> urls = new ArrayList<String>();
                        for (int i = 0; i < urllist.length(); i++) {
                            urls.add(urllist.optString(i));
                        }
                        mDispatchParam.urls = urls;
                        JSONObject args = pushObj.optJSONObject("publish_args");
                        mDispatchParam.accesstoken = args.optString("accesstoken");
                        mDispatchParam.token = args.optString("token");
                        mDispatchParam.mixer = args.optString("mixer");
                        mDispatchParam.vhost = args.optString("vhost");
                        mDispatchParam.roomId = roomId;//添加房间信息到调试地址
                        LogInfo.getInstance().roomId = mRoomId;
                        //房间ID
                        mRoomId = roomId;
                        mAccessToken = accessToken;
                        mURL = mDispatchParam.getURL();
                        if (null != livePusher) {
                            //设置日志地址
                            livePusher.setLogParam(LogInfo.getInstance().toString());
                            livePusher.start(mURL);
                        }
                        trackInitEvent();
                    } else {
                        trackInitEvent(code + ":" + msg);
                        listener.onError(Constants.ErrorCode.ERROR_PUSH, Constants.ErrorCode.ERROR_CONNECT, msg);
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    listener.onError(Constants.ErrorCode.ERROR_PUSH, Constants.ErrorCode.ERROR_CONNECT, "初始化视频信息失败！");
                    trackInitEvent(LogReporter.LOG_ERROR_EXCEPTION);
                }
            }
        });
    }

    private class DispatchParam {
        List<String> urls;
        String token = "";
        String mixer = "";
        String accesstoken = "";
        String vhost = "";
        String roomId;

        String getURL() {
            return this.urls.get(0)
                    + "?vhost=" + this.vhost
                    + "?token=" + this.token
                    + "?webinar_id=" + this.roomId
                    + "?ismix=0?mixserver=" + this.mixer
                    + "?accesstoken=" + this.accesstoken
                    + "/" + this.roomId;

        }
    }


    private void trackInitEvent(String error){
        JSONObject params = new JSONObject();
        try {
            params.put("roomId",mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_PUSH, false, params);
    }

    private void trackInitEvent(){
        JSONObject params = new JSONObject();
        try {
            params.put("roomId",mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_PUSH, params);
    }

    private void trackScreenShareEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("action", "start");
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_REPORT_SCREENSHARE, params);
    }
}
