package com.vhall.lss.push;

import static com.vhall.lss.VHLssApi.TYPE_ROOM;
import static com.vhall.lss.VHLssApi.TYPE_STREAM_START;
import static com.vhall.lss.VHLssApi.TYPE_STREAM_STOP;

import android.text.TextUtils;

import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.lss.VHLssApi;
import com.vhall.player.Constants;
import com.vhall.push.IVHCapture;
import com.vhall.push.LivePusher;
import com.vhall.push.VHLivePushConfig;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class VHLivePusher extends LivePusher {

    private static final String TAG = "VHLivePusher";
    private String mRoomId;
    private String mAccessToken;
    private String mURL;
    /**
     * 日志上报时真实的日志id
     * start 之前设置有效
     */
    private String logReportRoomId = "";

    public VHLivePusher(IVHCapture videoCapture, IVHCapture audioCapture, VHLivePushConfig config) {
        super(videoCapture, audioCapture, config);
        setIdentifier(VhallSDK.getInstance().getAPP_ID());
    }

    public void setLogReportRoomId(String logReportRoomId) {
        this.logReportRoomId = logReportRoomId;
    }

    public void start(String roomId, String accessToken) {
        if (TextUtils.isEmpty(roomId) || TextUtils.isEmpty(accessToken))
            return;
        switch (getState()) {
            case START:
                L.w(TAG, "livepusher already started");
                break;
            case IDLE:
            case STOP:
                disPatchURL(roomId, accessToken);
                break;
            case END:
                L.e(TAG, "status error:audioCapture already released");
                break;
        }
    }

    private boolean dispatching = false;

    @Override
    public void pause() {
        super.pause();
        JSONObject body = new JSONObject();
        try {
            body.put("type", TYPE_STREAM_STOP);
            body.put("room", mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        VHAPI.sendMsg(body.toString(), mAccessToken, TYPE_ROOM, mRoomId, null, null);
    }


    @Override
    protected void changeState(Constants.State state) {
        super.changeState(state);
        switch (state) {
            case START:
                JSONObject body = new JSONObject();
                try {
                    body.put("type", TYPE_STREAM_START);
                    body.put("room", mRoomId);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
                VHAPI.sendMsg(body.toString(), mAccessToken, TYPE_ROOM, mRoomId, null, new Callback() {
                    @Override
                    public void onFailure(Call call, IOException e) {
                        VLog.e("Jooper", "---> " + "onFailure");
                    }

                    @Override
                    public void onResponse(Call call, Response response) throws IOException {
                        VLog.e("Jooper", "---> " + "onResponse " + response.body().string());
                    }
                });//给服务器发消息，流已停止
                break;
        }

    }


    private void disPatchURL(final String roomId, final String accessToken) {
        if (dispatching)
            return;
        dispatching = true;

        //TODO 20190726 by zwp demo与文档中不再显示该事件，推荐使用BUFFER状态代替；
        //一段时间后可以删除EVENT_STATUS_STARING 事件；
        sendEvent(Constants.Event.EVENT_STATUS_STARTING, "");
        changeState(Constants.State.BUFFER);
        VHLssApi.getPublishInfo(roomId, accessToken, new Callback() {

            @Override
            public void onFailure(Call call, IOException e) {
                L.e(TAG, e.getMessage());
                dispatching = false;
                trackInitEvent(LogReporter.LOG_ERROR_NET);
                mDispatcher.post(new Runnable() {
                    @Override
                    public void run() {
                        sendError(Constants.ErrorCode.ERROR_PUSH, Constants.ErrorCode.ERROR_CONNECT, "error network,please try later！");
                    }
                });
            }

            @Override
            public void onResponse(Call call, Response response) throws IOException {
                dispatching = false;
                final String content = response.body().string();
                mDispatcher.post(new Runnable() {
                    @Override
                    public void run() {
                        try {
                            JSONObject result = new JSONObject(content);
                            String msg = result.optString("msg");
                            int code = result.optInt("code");
                            if (code == 200) {
                                JSONObject data = result.optJSONObject("data");
                                JSONObject pushObj = data.optJSONObject("publish_server");
                                JSONObject logObj = data.optJSONObject("log_info");
                                logObj.put("room_id",roomId);
                                DispatchParam mDispatchParam = new DispatchParam();
                                //param
                                JSONArray urllist = pushObj.optJSONArray("publish_domainname");
                                List<String> urls = new ArrayList<String>();
                                for (int i = 0; i < urllist.length(); i++) {
                                    urls.add(urllist.optString(i));
                                }
                                mDispatchParam.urls = urls;
                                JSONObject args = pushObj.optJSONObject("publish_args");
                                mDispatchParam.accesstoken = args.optString("accesstoken");
                                mDispatchParam.token = args.optString("token");
                                mDispatchParam.mixer = args.optString("mixer");
                                mDispatchParam.vhost = args.optString("vhost");
                                mDispatchParam.roomId = roomId;//添加房间信息到调试地址
                                //房间ID
                                mRoomId = roomId;
                                mAccessToken = accessToken;
                                //修改退流地址获取方式 22-01-10
                                String pushUrl = data.optString("pushUrl");
                                if (TextUtils.isEmpty(pushUrl)) {
                                    mURL = mDispatchParam.getURL();
                                } else {
                                    mURL = pushUrl;
                                }
                                //设置日志地址
                                if (!TextUtils.isEmpty(logReportRoomId)) {
                                    LogInfo.getInstance().roomId = logReportRoomId;
                                } else {
                                    LogInfo.getInstance().roomId = mRoomId;
                                }
                                if (logObj != null) {
                                    VLog.d(TAG, logObj.toString());
                                    LogInfo.getInstance().initBaseData(logObj);
                                }
                                setLogParam(LogInfo.getInstance().toString());
                                start(mURL);
                                trackInitEvent();
                            } else {
                                trackInitEvent(code + ":" + msg);
                                sendError(Constants.ErrorCode.ERROR_PUSH, Constants.ErrorCode.ERROR_CONNECT, msg);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                            sendError(Constants.ErrorCode.ERROR_PUSH, Constants.ErrorCode.ERROR_CONNECT, "初始化视频信息失败！");
                            trackInitEvent(LogReporter.LOG_ERROR_EXCEPTION);
                        }
                    }
                });
            }
        });
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    private class DispatchParam {
        List<String> urls;
        String token = "";
        String mixer = "";
        String accesstoken = "";
        String vhost = "";
        String roomId;

        String getURL() {
            return this.urls.get(0)
                    + "?vhost=" + this.vhost
                    + "?token=" + this.token
                    + "?webinar_id=" + this.roomId
                    + "?ismix=0?mixserver=" + this.mixer
                    + "?accesstoken=" + this.accesstoken
                    + "/" + this.roomId;

        }
    }


    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_PUSH, false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("roomId", mRoomId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITLSS_PUSH, params);
    }
}