package com.vhall.lss;

import android.text.TextUtils;

import com.vhall.framework.VHAPI;
import com.vhall.jni.VhallLiveApi;

import java.io.IOException;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.Request;
import okhttp3.Response;

import static com.vhall.framework.VHAPI.getBaseBuilder;
import static com.vhall.framework.VHAPI.getOkHttpClient;
import static com.vhall.framework.VHAPI.getRequest;

/**
 * Created by zwp on 2019/7/18
 */
public class VHLssApi {
    //lss服务
    public static final String TYPE_STREAM_START = "live_start";
    public static final String TYPE_STREAM_STOP = "live_over";
    public static final String TYPE_STREAM_CONVERT = "live_converted";
    //    //Room
    public static final String TYPE_ROOM = "service_room";

    /**
     * 获取发直播视频信息
     *
     * @param roomId
     * @param callback
     */
    public static void getPublishInfo(String roomId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("room_id", roomId+"");
        Call call = getOkHttpClient().newCall(getRequest("v2/room/get-publish-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 获取看直播视频信息
     *
     * @param roomId
     * @param callback
     */
    public static void getWatchLiveInfo(String roomId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("room_id", roomId+"");
        Call call = getOkHttpClient().newCall(getRequest("v2/room/get-watch-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }


    /**
     * 获取调度地址
     *
     * @param url
     * @param def
     * @return
     */
    public static String getDispatchURL(String url, String def) {
        String result = def;
        if (TextUtils.isEmpty(url))
            return result;
        Request request = new Request.Builder().url(url).build();
        try {
            Response response = getOkHttpClient().newCall(request).execute();
            if (response.isSuccessful())
                result = response.body().string();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}
