package com.vhall.rtc.trtc.log;


import com.vhall.logmanager.VLog;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.net.ssl.HttpsURLConnection;

//TODO 临时拷贝，后续优化
public class TempHttpRequest {

    private static final String TAG = "HttpRequest";

    private static ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();

    public static void httpGetAsyncRequest(final String urlStr) {
        singleThreadExecutor.execute(new Runnable() {
            @Override
            public void run() {
                httpSyncRequest("GET", urlStr, null);
            }
        });
    }

    public static void httpPostAsyncRequest(final String urlStr, final String post) {
        singleThreadExecutor.execute(new Runnable() {
            @Override
            public void run() {
                httpSyncRequest("POST", urlStr, post);
            }
        });
    }

    public static void httpSyncRequest(final String method, final String urlStr, final String post) {
        HttpURLConnection connection = null;
        try {
            // 调用URL对象的openConnection方法获取HttpURLConnection的实例
            URL url = new URL(urlStr);

            if (urlStr.startsWith("https")) {
                connection = (HttpsURLConnection) url.openConnection();
            } else {
                connection = (HttpURLConnection) url.openConnection();
            }

            // 设置是否从httpUrlConnection读入，默认情况下是true;
            connection.setDoOutput(true);
            connection.setDoInput(true);
            // Post 请求不能使用缓存
            connection.setUseCaches(false);
            connection.setConnectTimeout(15 * 1000); //15s
            connection.setReadTimeout(5 * 1000); //15s
            connection.setRequestMethod(method);
            if (method.equals("POST")) {
                // 获取URLConnection对象对应的输出流
                PrintWriter printWriter = new PrintWriter(connection.getOutputStream());
                // 发送请求参数
                printWriter.write(post);//post的参数 xx=xx&yy=yy
                // flush输出流的缓冲
                printWriter.flush();
                printWriter.close();
            }
            if (200 == connection.getResponseCode()) {
                // getInputStream方法获取服务器返回的输入流
                InputStream in = connection.getInputStream();
                // 使用BufferedReader对象读取返回的数据流
                // 按行读取，存储在StringBuider对象response中
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuilder response = new StringBuilder();
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                VLog.d(TAG, "------> respone data: " + response);
            }
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (connection != null) {
                // 结束后，关闭连接
                connection.disconnect();
            }
        }
    }
}
