package com.vhall.rtc.trtc.log;

import android.os.Build;
import android.util.Base64;

import com.tencent.trtc.TRTCStatistics;
import com.vhall.logmanager.VLog;
import com.vhall.rtc.trtc.Stream;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class LogReport {
    private static final String mTag = "LogReport";
    private static LogReport mInstance = null;
    private long mLogId = 0;

    private TRTCStatistics mTRTCStatistics;
    public HashMap<String, StreamLogReport> mStreamLogReportDic = new HashMap<>();

    public final static String kHost = "host";
    public final static String kVer = "ver";
    public final static String kPublishTime = "release_date";
    public final static String kSession = "s";
    public final static String kBU = "bu";
    public final static String kDT = "dt";
    public final static String kOSV = "osv";
    public final static String kUA = "ua";

    public int bu = 0;
    public int pf = 5;
    public String reportUrl;
    public String reportMonitorUrl;
    public String sessionId;
    public String userid;
    public String aid;
    public String cid;
    public JSONObject logDataInfo = new JSONObject();

    public enum VhallLogReportKey {
        kSignalingConnectSuccess(182001),
        kSignalingDisconnect(182002),
        kSubscribeInfo(182003),
        kPublishInfo(182004);

        private int _value;

        private VhallLogReportKey(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    public enum VhallLogReportErrorCode {
        kNoneError(-1),
        kSubscribeError(4001),
        kSubscribeSuccess(2002),
        kPublishError(4002),
        kPublishSuccess(2003);
        private int _value;

        private VhallLogReportErrorCode(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    public enum VhallLogType {
        kInfoLogType(5001),
        kLiveInfoLogType(5002);
        private int _value;

        private VhallLogType(int value) {
            _value = value;
        }

        public int getValue() {
            return _value;
        }
    }

    public static String md5(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xff);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result += temp;
            }
            return result;
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return "";
    }

    private LogReport() {

    }

    public static LogReport instance() {
        synchronized (LogReport.class) {
            if (mInstance == null) {
                mInstance = new LogReport();
                String uuid = java.util.UUID.randomUUID().toString();
                mInstance.sessionId = md5(uuid + System.currentTimeMillis());
            }
            return mInstance;
        }
    }

    long getLogId() {
        mLogId++;
        return mLogId;
    }

    public boolean setLogRoominfo(String uid, String aid, String cid, int pf) {
        if (!uid.isEmpty()) {
            this.userid = uid;
        }
        if (!aid.isEmpty()) {
            this.aid = aid;
        }
        if (!cid.isEmpty()) {
            this.cid = cid;
        }
        if (pf >= 0) {
            this.pf = pf;
        }
        return true;
    }

    public boolean setLogDataInfo(JSONObject logInfo) {
        if (logInfo == null) {
            return false;
        }
        logDataInfo = logInfo;
        try {
            if (logDataInfo.has(kHost)) {
                reportUrl = logDataInfo.getString(kHost);
                try {
                    URL url = new URL(reportUrl);
                    if (url.getPort() > 0) {
                        reportMonitorUrl = url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/monitor";
                    } else {
                        reportMonitorUrl = url.getProtocol() + "://" + url.getHost() + "/monitor";
                    }
                } catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                VLog.d(mTag, "reportMonitorUrl:" + reportMonitorUrl);
                logDataInfo.remove(kHost);
            } else {
                VLog.d(mTag, "data info is not contain host.");
            }
            if (logDataInfo.has(kBU)) {
                bu = logDataInfo.optInt(kBU);
            } else {
                VLog.d(mTag, "bu field is empty.");
            }
            logDataInfo.put(kOSV, "android " + Build.VERSION.RELEASE);
            logDataInfo.put(kUA, "android " + Build.VERSION.RELEASE);
            logDataInfo.put(kDT, Build.MODEL);
            logDataInfo.put(kVer, "v3.0.0");//TODO 封装为独立module后，取 code version name
            logDataInfo.put(kPublishTime, "20221115");
            logDataInfo.put(kSession, sessionId);
        } catch (JSONException e) {
            e.printStackTrace();
            VLog.d(mTag, "JSONException catch.");
        }
        return true;
    }

    public void reportLogWithKey(VhallLogReportKey key) {
        reportLogWithKeyAndStreamId(key, null, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId) {
        reportLogWithKeyAndStreamId(key, streamId, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg) {
        reportLogWithKeyAndStreamId(key, streamId, msg, -1);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg, int code) {
        reportLogWithKeyAndStreamId(key, streamId, msg, code, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg, int code, JSONObject info) {
        if (logDataInfo == null || reportUrl == null) {
            return;
        }
        JSONObject tmpObj = null;
        try {
            tmpObj = new JSONObject(logDataInfo.toString());
            tmpObj.put("uid", userid);
            tmpObj.put("aid", aid);
            tmpObj.put("cid", cid);
            tmpObj.put("s", sessionId);
            tmpObj.put("id", getLogId());
            tmpObj.put("bu", bu);
            tmpObj.put("pf", pf);
            tmpObj.put("ld", System.currentTimeMillis());
            tmpObj.put(kVer, "3.0.0");
            if (streamId != null) {
                tmpObj.put("p", streamId);
            }
            if (msg != null) {
                String _msg = msg;
                if (code != -1) {
                    _msg += ":" + code + "";
                }
                tmpObj.put("_m", _msg);
            } else {
                tmpObj.put("_m", "");
            }
            if (info != null) {
                for (Iterator<String> it = info.keys(); it.hasNext(); ) {
                    String item = it.next();
                    tmpObj.put(item, info.get(item));
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        String token = tmpObj.toString();
        String host = null;
        if (key == VhallLogReportKey.kSignalingConnectSuccess || key == VhallLogReportKey.kSignalingDisconnect) {
            host = reportUrl;
        } else {
            host = reportMonitorUrl;
        }
        String url = null;
        try {
            url = host + "?k=" + key.getValue() + "&token=" + new String(Base64.encode(token.getBytes(), Base64.NO_WRAP), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        VLog.d(mTag, "report url:" + url + "token:" + token);
        TempHttpRequest.httpGetAsyncRequest(url);
    }

    public void streamStart(Stream stream) {
        if (stream == null) {
            return;
        }
        StreamLogReport streamLogReport = null;
        synchronized (this) {
            if (mStreamLogReportDic.containsKey(stream.streamId)) {
                streamLogReport = mStreamLogReportDic.get(stream.streamId);
            } else {
                streamLogReport = new StreamLogReport();
                mStreamLogReportDic.put(stream.streamId, streamLogReport);
            }
        }
        streamLogReport.streamStart(stream);
    }

    public void streamStop(String streamId) {
        if (streamId == null) {
            return;
        }
        synchronized (this) {
            if (mStreamLogReportDic.containsKey(streamId + "")) {
                StreamLogReport streamLogReport = mStreamLogReportDic.get(streamId + "");
                streamLogReport.streamStop();
                mStreamLogReportDic.remove(streamId + "");
            }
        }
    }

    public void streamError(String streamId) {
        if (streamId == null) {
            return;
        }
        synchronized (this) {
            if (mStreamLogReportDic.containsKey(streamId + "")) {
                StreamLogReport streamLogReport = mStreamLogReportDic.get(streamId + "");
                streamLogReport.streamError();
                mStreamLogReportDic.remove(streamId + "");
            }
        }
    }

    public void streamAllStop() {
        synchronized (this) {
            for (String key : mStreamLogReportDic.keySet()) {
                StreamLogReport streamLogReport = mStreamLogReportDic.get(key);
                if (streamLogReport != null) {
                    streamLogReport.streamStop();
                }
            }
            mStreamLogReportDic.clear();
        }
    }

    public void updateLatestStatistics(TRTCStatistics statistics) {
        mTRTCStatistics = statistics;
    }

    public HashMap<String, String> fetchStatisticsData(Stream stream) {
        if (null != mTRTCStatistics) {
            HashMap<String, String> dataHashMap = new HashMap<>();

            if (stream.isLocal) {
                try {
                    dataHashMap.put("bitrate", String.valueOf(mTRTCStatistics.localArray.get(0).videoBitrate));
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    dataHashMap.put("videoWidth", String.valueOf(mTRTCStatistics.localArray.get(0).width));
                } catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    dataHashMap.put("videoHeight", String.valueOf(mTRTCStatistics.localArray.get(0).height));
                } catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    ArrayList<TRTCStatistics.TRTCRemoteStatistics> remoteList = mTRTCStatistics.remoteArray;
                    if (null != remoteList && !remoteList.isEmpty()) {
                        for (TRTCStatistics.TRTCRemoteStatistics remoteStatistics : remoteList) {
                            if (remoteStatistics.userId.equals(stream.userId)) {
                                dataHashMap.put("bitrate", String.valueOf(remoteStatistics.videoBitrate));
                                dataHashMap.put("videoWidth", String.valueOf(remoteStatistics.width));
                                dataHashMap.put("videoHeight", String.valueOf(remoteStatistics.height));
                            }
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return dataHashMap;
        }
        return null;
    }
}
