package com.vhall.rtc.absrtc;

import android.media.projection.MediaProjection;

import com.vhall.framework.common.ICallback;
import com.vhall.ilss.VHRoomListener;
import com.vhall.rtc.VRTCParams;

import org.json.JSONObject;

/**
 * @author：vhall Email：jooperge@163.com
 * 描述 rtc抽象接口
 * 修改历史:
 * <p>
 * 创建于： 2022/10/18
 */
public interface IVHRTC {
    void enterRoom(
            VRTCParams.VRTCRoomParamsInner roomParams,
            boolean autoPublish,
            boolean autoSubscribe,
            String attribute,
            VHRoomListener roomListener
    );

    /**
     * @param renderView
     * @param videoParam
     * @param isFrontCamera
     */
    void startLocalPreview(
            IVHRTCRenderView renderView,
            VRTCParams.VRTCVideoEncodeParam videoParam,
            VRTCParams.VRTCStreamParam streamParam,
            boolean isFrontCamera);

    void startRemoteView(IVHRTCRenderView renderView, String streamId);

    void createScreenShareStream(
            MediaProjection mediaProjection,
            VRTCParams.VRTCVideoEncodeParam videoParam,
            VRTCParams.VRTCStreamParam streamParam
    );

    void stopScreenShare();

    String getUserIdByStreamId(String streamId);

    void publish();

    void unPublish();

    void subscribe(String streamId);

    void unSubscribe(String streamId);

    void leaveRoom();

    void muteVideo(String streamId, boolean mute);

    void muteAudio(String streamId, boolean mute);

    void switchCamera();

    boolean isFrontCamera();

    void setMirror(boolean isMirror);

    void switchAutoFocusMode(boolean enableAuto, ISwitchFocusModeListener switchFocusModeListener);

    void release();

    void setDataReport(JSONObject data);

    /**
     * 修改音频输入设备
     * VRTC：AppRTCAudioManager.AudioDevice
     *
     * @param object
     */
    void setDefaultAudioDevice(Object object);

    /**
     * 旁路直播
     *
     * @param accessToken vhallyun token
     * @param callback
     */
    void broadcastRoom(VRTCParams.VRTCBroadcastParamInner broadcastParam, String accessToken, ICallback callback);

    /**
     * 设置混流主屏
     *
     * @param streamId
     * @param callbackV2
     */
    void setMixLayoutMainScreen(String streamId, ICallback callbackV2);

    /**
     * 设置旁路布局
     *
     * @param layoutMode
     * @param callback
     */
    void setMixLayoutMode(VRTCParams.VRTCBroadcastParamInner broadcastParam, int layoutMode, ICallback callback);

    /**
     * 设置旁路背景颜色
     *
     * @param hexColor 支持格式： 0x000000、#000000、000000；传Null代表取消背景色(重置为流媒体侧预置的背景色0x333338)
     * @param callback
     */
    void setMixBackgroundColor(VRTCParams.VRTCBroadcastParamInner broadcastParam, String hexColor, ICallback callback);

    /**
     * 设置旁路窗格边框背景
     *
     * @param border   传Null代表关闭
     * @param callback
     */
    void setMixBorderColor(VRTCParams.VRTCBroadcastParam.Border border, ICallback callback);

    /**
     * 设置旁路画布背景图
     *
     * @param url      VRTC只支持https; 传Null代表关闭
     * @param cropType TRTC暂不支持
     * @param callback
     */
    void setMixBackgroundImage(VRTCParams.VRTCBroadcastParamInner broadcastParam, String url, int cropType, ICallback callback);

    /**
     * 设置窗格占位图
     *
     * @param url      只支持https
     * @param callback
     */
    void setMixPlaceholderImage(String url, ICallback callback);

    /**
     * 启动/关闭文档容屏
     *
     * @param appId
     * @param channelId
     * @param start     true: 启动，false: 关闭
     * @param callback
     */
    void docCloudRender(String appId, String channelId, boolean start, final ICallback callback);

    /**
     * 设置互动预览画面裁剪模式
     *
     * @param scaleType {@link VRTCParams.VRTCVideoFillMode}
     */
    void setScaleType(int scaleType);

    /**
     * 直播过程中修改视频分辨率
     *
     * @param videoProfile 详情见{@link com.vhall.rtc.VRTCCode.RTCVideoProfile}
     */
    void setVideoResolution(int videoProfile);
}