package com.vhall.rtc;

/**
 * @author：jooper Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * <p>
 * 创建于： 2022/7/19
 */
public class VRTCCode {

    public static final String kick_inav = "kick_inav";//踢房间
    public static final String force_leave_inav = "force_leave_inav";//踢房间
    @Deprecated
    public static final String kick_inav_stream = "kick_inav_stream";//请下麦
    @Deprecated
    public static final String publish_inav_another = "publish_inav_another";//推旁路
    @Deprecated
    public static final String apply_inav_publish = "apply_inav_publish";//申请上麦
    @Deprecated
    public static final String askfor_inav_publish = "askfor_inav_publish";//邀请推流
    @Deprecated
    public static final String audit_inav_publish = "audit_inav_publish";//审核申请
    @Deprecated
    public static final String user_publish_callback = "user_publish_callback";//上下麦，拒绝上麦

    public static final String publish_inav_stream = "publish_inav_stream";//上麦
    public static final String inav_close = "inav_close";//房间关闭

    public static final String MODE_RTC = "rtc";//默认为互动房间 实时通信场景，例如互动连麦
    public static final String MODE_LIVE = "live";//无延迟直播房间 直播场景，例如无延迟直播

    public static final String ROLE_HOST = "administrator";//    可以发布和订阅互动流
    public static final String ROLE_AUDIENCE = "viewer";//    只能订阅互动流，无法发布

    /**
     * 弱网下互动流分辨率调整策略
     */
    public static class RTCDegradationMode {
        /**
         * 弱网下不动态调整分辨率/帧率/码率
         */
        public static final int MAINTAIN_NONE = 0;
        /**
         * 弱网下保持流畅度，允许降分辨率
         */
        public static final int MAINTAIN_FLUENCY = 1;
        /**
         * 弱网下保持清晰度，允许降码率
         */
        public static final int MAINTAIN_RESOLUTION = 2;
        /**
         * 弱网下尝试保持清晰度/流畅度平衡【默认值】
         * VRTC: 当前VRTC仅支持平衡模式
         */
        public static final int BALANCED = 3;
    }

    //************************************** 互动流分辨率方向  **************************************
    public static final int RTC_VIDEO_PROFILE_MODE_LANDSCAPE = 0;//横屏分辨率
    public static final int RTC_VIDEO_PROFILE_MODE_PORTRAIT = 1;//竖屏分辨率
    //************************************** 互动流分辨率方向  **************************************

    public static class RTCVideoProfile {
        /**
         * 互动流分辨率仅定义了横屏分辨率，如：1920x1080，如需使用竖屏分辨率
         * 需要同时设定 VRTCVideoEncodeParam#videoResolutionMode = RTC_VIDEO_PROFILE_MODE_PORTRAIT
         */
        //************************************** 1:1目前仅适用与TRTC **************************************
        public static final int PROFILE_120_120_1x1 = 1;
        public static final int PROFILE_160_160_1x1 = 2;
        public static final int PROFILE_270_270_1x1 = 3;
        public static final int PROFILE_480_480_1x1 = 4;
        //************************************** 1:1目前仅适用与TRTC **************************************

        //************************************** 4:3 **************************************
        public static final int PROFILE_160_120_4x3 = 5;
        public static final int PROFILE_192_144_4x3 = 6;//VRTC only
        public static final int PROFILE_240_180_4x3 = 7;
        public static final int PROFILE_280_210_4x3 = 8;
        public static final int PROFILE_320_240_4x3 = 9;
        public static final int PROFILE_400_300_4x3 = 10;//VRTC时降级为320x240
        public static final int PROFILE_480_360_4x3 = 11;
        public static final int PROFILE_640_480_4x3 = 12;
        public static final int PROFILE_960_720_4x3 = 13;
        //************************************** 4:3 **************************************

        //************************************** 16:9 **************************************
        public static final int PROFILE_160_90_16x9 = 14;
        public static final int PROFILE_256_144_16x9 = 15;//VRTC时降级为160x90
        public static final int PROFILE_320_180_16x9 = 16;
        public static final int PROFILE_480_270_16x9 = 17;//VRTC时降级为320x180
        public static final int PROFILE_640_360_16x9 = 18;
        public static final int PROFILE_960_540_16x9 = 19;
        public static final int PROFILE_1280_720_16x9 = 20;
        public static final int PROFILE_1920_1080_16x9 = 21;
        //************************************** 16:9 **************************************
    }

    public static class BroadcastVideoProfile {
        public static final int BROADCAST_VIDEO_PROFILE_480P_0 = 0;//"{\"resolution\":[640,480],\"framerate\":2rtc5,\"bitrate\":700},"
        public static final int BROADCAST_VIDEO_PROFILE_480P_1 = 1;//"{\"resolution\":[848,480],\"framerate\":25,\"bitrate\":750},"
        public static final int BROADCAST_VIDEO_PROFILE_540P_0 = 2;//"{\"resolution\":[720,540],\"framerate\":25,\"bitrate\":950},"
        public static final int BROADCAST_VIDEO_PROFILE_540P_1 = 3;// "{\"resolution\":[960,540],\"framerate\":25,\"bitrate\":1150},"
        public static final int BROADCAST_VIDEO_PROFILE_720P_0 = 4;//"{\"resolution\":[960,720],\"framerate\":25,\"bitrate\":1400},"
        public static final int BROADCAST_VIDEO_PROFILE_720P_1 = 5;//"{\"resolution\":[1280,720],\"framerate\":25,\"bitrate\":1600},"
        public static final int BROADCAST_VIDEO_PROFILE_960P_0 = 6;//"{\"resolution\":[1280,960],\"framerate\":25,\"bitrate\":1600},"
        public static final int BROADCAST_VIDEO_PROFILE_960P_1 = 7;//"{\"resolution\":[1712,960],\"framerate\":25,\"bitrate\":1900},"
        public static final int BROADCAST_VIDEO_PROFILE_1080P_0 = 8;//"{\"resolution\":[1440,1080],\"framerate\":25,\"bitrate\":1800},"
        public static final int BROADCAST_VIDEO_PROFILE_1080P_1 = 9;//"{\"resolution\":[1920,1080],\"framerate\":25,\"bitrate\":2200}"

        /**竖版旁路分辨率**/
        /**
         * 注意【VRTC】当使用竖版分辨率时，仅支持部分布局模板，含：
         * CANVAS_LAYOUT_PATTERN_FLOAT_2_1DR 8
         * CANVAS_LAYOUT_PATTERN_FLOAT_2_1DL 9
         * CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TR 30
         * CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TL 31
         */
        public static final int BROADCAST_VIDEO_PROFILE_480P_1_VERTICAL = 10;
        public static final int BROADCAST_VIDEO_PROFILE_540P_1_VERTICAL = 11;
        public static final int BROADCAST_VIDEO_PROFILE_720P_1_VERTICAL = 12;
        public static final int BROADCAST_VIDEO_PROFILE_1080P_1_VERTICAL = 13;
    }

    /**
     * 旁路布局
     */
    public static class BroadcastLayout {
        //************************************** 旁路布局 layout **************************************
        public static final int CANVAS_LAYOUT_PATTERN_GRID_1 = 0;//强制仅一人铺满（即使房间内有多个互动流，也只混一个）
        public static final int CANVAS_LAYOUT_PATTERN_GRID_2_H = 1;//左右两格
        public static final int CANVAS_LAYOUT_PATTERN_GRID_3_E = 2;//正品字
        public static final int CANVAS_LAYOUT_PATTERN_GRID_3_D = 3;//倒品字
        public static final int CANVAS_LAYOUT_PATTERN_GRID_4_M = 4;//2行x2列
        public static final int CANVAS_LAYOUT_PATTERN_GRID_5_D = 5;//2行，上3下2
        public static final int CANVAS_LAYOUT_PATTERN_GRID_6_E = 6;//2行x3列
        public static final int CANVAS_LAYOUT_PATTERN_GRID_9_E = 7;//3行x3列
        public static final int CANVAS_LAYOUT_PATTERN_FLOAT_2_1DR = 8;//主次悬浮，大屏铺满，小屏悬浮右下角 (小窗宽=画布宽度/5，比例为4:3)
        public static final int CANVAS_LAYOUT_PATTERN_FLOAT_2_1DL = 9;//主次悬浮，大屏铺满，小屏悬浮左下角 (小窗宽=画布宽度/5，比例为4:3)
        public static final int CANVAS_LAYOUT_PATTERN_FLOAT_3_2DL = 10;//大屏铺满，2小屏悬浮右上角 (小窗宽=画布宽度/6，比例为4:3)
        public static final int CANVAS_LAYOUT_PATTERN_FLOAT_6_5D = 11;//主次悬浮，大屏铺满，一行5个悬浮于下面 (小窗宽=画布宽度/5，比例为4:3)
        public static final int CANVAS_LAYOUT_PATTERN_FLOAT_6_5T = 12;//主次悬浮，大屏铺满，一行5个悬浮于上面 (小窗宽=画布宽度/5，比例为4:3)
        public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1T4D = 13;//主次平铺，一行4个位于底部
        public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1D4T = 14;//主次平铺，一行4个位于顶部
        public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1L4R = 15;//主次平铺，一列4个位于右边
        public static final int CANVAS_LAYOUT_PATTERN_TILED_5_1R4L = 16;//主次平铺，一列4个位于左边
        public static final int CANVAS_LAYOUT_PATTERN_TILED_6_1T5D = 17;//主次平铺，一行5个位于底部
        public static final int CANVAS_LAYOUT_PATTERN_TILED_6_1D5T = 18;//主次平铺，一行5个位于顶部
        public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1L8R = 19;//主次平铺，右边为（2列x4行=8个块）
        public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1R8L = 20;//主次平铺，左边为（2列x4行=8个块）
        public static final int CANVAS_LAYOUT_PATTERN_TILED_13_1L12R = 21;//主次平铺，右边为（3列x4行=12个块）
        public static final int CANVAS_LAYOUT_PATTERN_TILED_17_1TL16GRID = 22;//主次平铺，1V16，主屏在左上角
        public static final int CANVAS_LAYOUT_PATTERN_TILED_9_1D8T = 23;//主次平铺，主屏在下，8个（2行x4列）在上
        public static final int CANVAS_LAYOUT_PATTERN_TILED_13_1TL12GRID = 24;//主次平铺，主屏在左上角，其余12个均铺于其他剩余区域
        public static final int CANVAS_LAYOUT_PATTERN_TILED_17_1TL16GRID_E = 25;//主次平铺，主屏在左上角，其余16个均铺于其他剩余区域
        public static final int CANVAS_LAYOUT_PATTERN_CUSTOM = 27;//自定义，当使用坐标布局接口时，请使用此
        public static final int CANVAS_LAYOUT_EX_PATTERN_GRID_12_E = 28;//3行4列等分布局
        public static final int CANVAS_LAYOUT_EX_PATTERN_GRID_16_E = 29;//4行4列等分布局
        public static final int CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TR = 30;// 主次悬浮，大屏铺满，小屏悬浮右上角 (小窗宽=画布宽度/5，比例为4:3)支持竖版布局，参考PaaS需求： paas pm
        public static final int CANVAS_LAYOUT_EX_PATTERN_FLOAT_2_1TL = 31;// 主次悬浮，大屏铺满，小屏悬浮左上角 (小窗宽=画布宽度/5，比例为4:3)支持竖版布局，参考PaaS需求： paas pm
        /**
         * 混流自适应布局mode
         * 传输给MCU时会做减去1000的处理，期间用来处理部分转换逻辑，简化上层调用
         */
        public static final int CANVAS_ADAPTIVE_LAYOUT_UNDEFINED = 1000;
        public static final int CANVAS_ADAPTIVE_LAYOUT_GRID_MODE = 1001;// 均分模式
        public static final int CANVAS_ADAPTIVE_LAYOUT_TILED_MODE = 1002;// 平铺模式
        public static final int CANVAS_ADAPTIVE_LAYOUT_FLOAT_MODE = 1003;// 悬浮模式
        public static final int CANVAS_ADAPTIVE_LAYOUT_TILED_TOP_MAX16 = 1004;// 文档布局模式, 窗格位于主屏上方，最多16窗格
        public static final int CANVAS_ADAPTIVE_LAYOUT_MAX = 1005;
        //************************************** 旁路布局 layout **************************************
    }

    /**
     * TRTC流event定义，仅用于上报给服务侧
     */
    public static class TRTCStreamEvent {
        public static final String PUBLISH = "PUBLISH";
        public static final String UN_PUBLISH = "UN_PUBLISH";
        public static final String MUTE_VIDEO = "MUTE_VIDEO";
        public static final String UN_MUTE_VIDEO = "UN_MUTE_VIDEO";
        public static final String MUTE_AUDIO = "MUTE_AUDIO";
        public static final String UN_MUTE_AUDIO = "UN_MUTE_AUDIO";
    }

    /**
     * onAddInternalStream接收的流类型：云渲染
     */
    public static final String MIX_INTERNALSTREAM_TYPE_DOC_CLOUD_RENDER = "doc-cloud-render";

    /**
     * MCU背景设置成功
     */
    public static final int MCU_BG_RESULT = 200;
    /**
     * MCU背景设置异常
     */
    public static final int MCU_BG_ERROR = 20031;
    /**
     * 等比缩放至画布[适用于 混流背景图]
     */
    public static final int MCU_BG_MODE_SCALE = 0;
    /**
     * 裁剪图片和画布宽高比一致，再缩放至画布[适用于 混流背景图]
     */
    public static final int MCU_BG_MODE_ASPECTFIT = 1;
    /**
     * 直接拉伸填满画布（默认）[适用于 混流背景图]
     */
    public static final int MCU_BG_MODE_FILL = 2;

    //************************************** err codes **************************************

    /****RTC范围[11001, 12000]****/
    //sdk依赖不存在，需要检查是否进入了TRTC房间但本地工程没有引入TRTC相关依赖；检查是否进入了VRTC房间但本地踢出了VRTC相关依赖。依赖手册参考官方文档
    public static final int ERR_SDK_DEPNONE = 11001;
    //上下麦异常
    public static final int ERR_ROOM_PUBLISH = 11002;
    /****RTC范围[11001, 12000]****/

    /****旁路范围[10000, 11000]****/
    //旁路推流房间id不存在
    public static final int ERR_BROADCAST_ID_NULL = 10000;
    //旁路推流地址不存在
    public static final int ERR_BROADCAST_URL_NULL = 10001;
    //无旁路权限
    public static final int ERR_BROADCAST_PERMISSION_FAILED = 10002;
    //旁路入参配置解析异常
    public static final int ERR_BROADCAST_CONFIG_JSONEX = 10003;
    //TRTC发起/关闭旁路接口未知异常
    public static final int ERR_BROADCAST_RESPONSE_UNKNOW = 10004;
    //不支持设置旁路窗格占位图
    public static final int ERR_BROADCAST_NONSUPPORT_GRIDIMAGE = 10005;
    //不支持文档容屏
    public static final int ERR_BROADCAST_NONSUPPORT_DOCCLOUD = 10006;
    // 文档融屏API请求失败
    public static final int ERR_BROADCAST_DOCCLOUD_REQUEST_FAIL = 10007;

    /****旁路范围[10000, 11000]****/

    //************************************** err codes **************************************
}