package com.vhall.rtc;

import android.text.TextUtils;

import com.vhall.framework.common.ICallback;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import okhttp3.Response;

import java.util.Base64;
import java.nio.charset.StandardCharsets;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.core.type.TypeReference;

import java.util.Map;

/**
 * @author：vhall Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * <p>
 * 创建于： 2022/11/1
 */
public class Utils {
    /**
     * 互动旁路分辨率预设模版
     *
     * @param definition
     * @return
     * @throws JSONException
     */
    public static JSONObject getProfile(int definition) throws JSONException {
        JSONArray list = new JSONArray("[{\"resolution\":[640,480],\"framerate\":25,\"bitrate\":700},{\"resolution\":[848,480],\"framerate\":25,\"bitrate\":750},{\"resolution\":[720,540],\"framerate\":25,\"bitrate\":950},{\"resolution\":[960,540],\"framerate\":25,\"bitrate\":1150},{\"resolution\":[960,720],\"framerate\":25,\"bitrate\":1400},{\"resolution\":[1280,720],\"framerate\":25,\"bitrate\":1600},{\"resolution\":[1280,960],\"framerate\":25,\"bitrate\":1600},{\"resolution\":[1712,960],\"framerate\":25,\"bitrate\":1900},{\"resolution\":[1440,1080],\"framerate\":25,\"bitrate\":1800},{\"resolution\":[1920,1080],\"framerate\":25,\"bitrate\":2200},{\"resolution\":[480,848],\"framerate\":25,\"bitrate\":750},{\"resolution\":[540,960],\"framerate\":25,\"bitrate\":1150},{\"resolution\":[720,1280],\"framerate\":25,\"bitrate\":1600},{\"resolution\":[1080,1920],\"framerate\":25,\"bitrate\":2200}]");
        return list.getJSONObject(definition);
    }

    /* 验证token */
    public static boolean verifyToken(String token) {
        if (token == null || token.length() == 0 || token.length() % 4 != 0) {
            return false;
        }
        if (!(token.matches("[A-Za-z0-9+/]+={0,2}"))) {
            return false;
        }
        try {
            String jsonString = new String(Base64.getDecoder().decode(token), StandardCharsets.UTF_8);
            // 解析为JSON对象
            ObjectMapper objectMapper = new ObjectMapper();
            Map<String, Object> map = objectMapper.readValue(jsonString, new TypeReference<Map<String, Object>>() {
            });

            // 检查是否包含合法的token字段
            if (map.containsKey("token")) {
                System.out.println("Token: " + map.get("token"));
                return true;
            } else {
                System.out.println("Error: JSON object does not contain a valid token field.");
                return false;
            }
        } catch (Exception e) {
            System.out.println("Error: Failed to parse JSON object.");
            e.printStackTrace();
        }
        return false;
    }

    /**
     * sdk内部处理，为简化应用层使用，将自适应布局整体真实值做了+1000处理，故该处需要转换
     */
    public static int compatAdaptiveLayoutMode(int originLayoutMode) {
        return originLayoutMode >= 1000 ? (originLayoutMode - 1000) : originLayoutMode;
    }

    /**
     * sdk内部处理，旁路分辨率模版处理
     * 另由于该分辨率以VRTC为基础，针对TRTC的具体转换在服务端执行，所以真实旁路分辨率请以实际为准
     */
    public static JSONObject compatBroadcastProfile(int profile) throws JSONException {
        return getProfile(profile);
    }

    public static String compatColor2HexStyle(String color) {
        if (!TextUtils.isEmpty(color)) {
            String bgColor = color;
            if (color.startsWith("#")) {
                bgColor = color.replace("#", "0x");
            } else if (!color.startsWith("0x")) {
                bgColor = "0x".concat(color);
            }
            return bgColor;
        } else {
            return null;
        }
    }

    public static void parseOkHttpCallback(ICallback callback, Response response) {
        JSONObject result = new JSONObject();

        try {
            result = new JSONObject(response.body().string());
        } catch (Exception e) {
            e.printStackTrace();
        }
        int resultCode = result.optInt("code", -1);
        if (200 == resultCode) {
            callback.onSuccess();
        } else {
            callback.onFailure(resultCode, result.optString("msg", ""));
        }

        return;
    }
}