package com.vhall.ilss;

import org.json.JSONObject;

/**
 * @author：vhall Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * <p>
 * 创建于： 2022/10/21
 */
public abstract class VHRoomListener {

    /**
     * 房间连接(进入房间)回调
     *
     * @param roomInfo VRTC结构: TODO 记录VRTC roomInfo格式示例
     *                 TRTC结构: {"result: long}, 如果加入成功，回调 result 会是一个正数（result > 0），代表进入房间所消耗的时间，单位是毫秒（ms）。
     *                 如果加入失败，回调 result 会是一个负数（result < 0），代表失败原因的错误码。
     */
    public void onDidConnect(JSONObject roomInfo) {
    }

    /**
     * 离开房间时的事件回调
     * <p>
     * 调用 TRTCCloud 中的 exitRoom 接口会执行退出房间的相关逻辑，例如释放音视频设备资源和编解码器资源等。待 SDK 占用的所有资源释放完毕后，SDK 会抛出 onExitRoom() 回调。
     * 如果要再次调用 enterRoom 或者切换到其他的音视频 SDK，请等待 onExitRoom 回调到来后再执行相关操作。否则可能会遇到例如摄像头、麦克风设备被强占等各种异常问题。
     */
    public void onDidExitRoom() {
    }

    /**
     * 异常回调
     * <p>
     * VRTC: 暂不支持code(始终为0)，只支持errMsg
     * TRTC: https://cloud.tencent.com/document/product/647/32257
     *
     * @param code      trtc_code见 https://cloud.tencent.com/document/product/647/32257
     * @param errMsg
     * @param extraInfo [仅适用于TRTC]扩展信息字段，个别错误码可能会带额外的信息帮助定位问题
     */
    abstract public void onDidError(int code, String errMsg, String extraInfo);

    /**
     * 警告事件回调【仅适用于TRTC】
     * 表示 SDK 抛出的提示性问题，比如视频出现卡顿或 CPU 使用率太高等。
     * <p>
     * TRTC: https://cloud.tencent.com/document/product/647/79629#dcce2ff24dabe8ef54ee21033cf2dfc6
     *
     * @param warningCode https://cloud.tencent.com/document/product/647/32257
     * @param warningMsg
     * @param extraInfo   [仅适用于TRTC]扩展信息字段，个别错误码可能会带额外的信息帮助定位问题
     */
    public void onWarning(int warningCode, String warningMsg, String extraInfo) {

    }

    /**
     * 上麦事件
     * <p>
     * VRTC: 原上麦事件
     * TRTC: 本地首个视频/音频帧发布出去的事件
     *
     * @param userId
     * @param streamId
     */
    public void onDidPublishStream(String userId, String streamId) {
    }

    /**
     * 下麦事件
     *
     * @param userId
     * @param streamId
     */
    public void onDidUnPublishStream(String userId, String streamId) {
    }

    /**
     * 第一帧画面开始渲染
     * VRTC: 当前仅响应本地流首帧事件
     * TRTC: 可响应本地/远端流首帧渲染事件
     *
     * @param isLocal        是否是本地流【remoteStreamId为空时为本地流】
     * @param remoteStreamId 远端流ID
     * @param width          画面宽度【暂仅支持TRTC】
     * @param height         画面高度【暂仅支持TRTC】
     */
    public void onFirstFrameAvailable(boolean isLocal, String remoteStreamId, int width, int height) {

    }

    /**
     * 当前仅适用于VRTC
     *
     * @param userId
     * @param streamId
     */
    public void onDidInternalStreamAdded(String userId, String streamId) {
    }

    /**
     * 当前仅适用于VRTC
     *
     * @param userId
     * @param streamId
     */
    public void onDidInternalStreamRemoved(String userId, String streamId) {
    }

    /**
     * 当前仅适用于VRTC
     *
     * @param userId
     * @param streamId
     * @param errJson
     */
    public void onDidInternalStreamFailed(String userId, String streamId, JSONObject errJson) {
    }

    /**
     * 订阅远端流成功
     *
     * @param userId
     * @param streamId
     */
    public void onDidSubscribeStream(String userId, String streamId) {
    }

    public void onDidUnSubscribeStream(String userId, String streamId) {
    }

    /**
     * 有远端流进入房间，由远端用户推流成功触发
     *
     * @param userId
     * @param streamId
     */
    public void onDidAddStream(String userId, String streamId) {
    }

    /**
     * 有远端流离开房间
     * VRTC: 有远端流离开房间
     * TRTC: 有远端用户离开房间
     *
     * @param userId
     * @param streamId
     */
    public void onDidRemoveStream(String userId, String streamId) {
    }

    /**
     * 仅适用于VRTC-远端流静音状态回调 http://wiki.vhallops.com/display/media/Stream , broadcastMuteStream事件
     *
     * @param streamId
     * @param config
     */
    public void onDidUpdateOfStream(String streamId, JSONObject config) {
    }

    /**
     * 流状态变化事件，可能包含的事件包括[没有变化的参数不包含在当次事件的json结构体中]：
     * video: true/false
     * audio: true/false
     * newWidth: xxx
     * newHeight: xxx
     *
     * @param streamId
     * @param config
     */
    public void onDidUpdateOfStreamV2(String streamId, JSONObject config) {
    }


    /**
     * 重连事件
     *
     * @param total   总次数   TRTC暂不支持，始终为0
     * @param current 当前次数  TRTC暂不支持，始终为0
     */
    public void onReconnect(int total, int current) {
    }

    public void onStreamMixed(JSONObject var1) {
    }

    /**
     * 本地流摄像头异常
     *
     * @param code VRTC模式下暂不支持(始终为0); trtc_code见 https://cloud.tencent.com/document/product/647/32257
     * @param msg
     */
    public void onCameraError(int code, String msg) {

    }
}