/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.framework.utils;

import android.content.Context;
import android.os.AsyncTask;
import com.vhall.framework.VHAPI;
import com.vhall.logmanager.VLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.Request;
import okhttp3.Response;

public class FileUtil {
    private static final String TAG = "FileUtil";

    public static void getCuePointFile(String url, Context context, FileCallback callback) {
        try {
            String cachePath = context.getCacheDir().getPath();
            VLog.d((String)TAG, (String)cachePath);
            String[] marks = url.split("/");
            File file = new File(cachePath + File.separator + marks[marks.length - 2]);
            if (file.exists()) {
                file.delete();
            }
            ImageDownloadTask task = new ImageDownloadTask(url, file.getAbsolutePath(), callback);
            task.execute(new Void[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            callback.onFile(null);
        }
    }

    public static void getSubtitleFile(String url, Context context, FileCallback callback) {
        try {
            File file;
            String cachePath = context.getCacheDir().getPath();
            VLog.d((String)TAG, (String)cachePath);
            String[] marks = url.split("/");
            String directory = cachePath + File.separator + marks[marks.length - 2];
            File dir_file = new File(directory);
            if (!dir_file.exists()) {
                dir_file.mkdirs();
            }
            if ((file = new File(directory + File.separator + marks[marks.length - 1])).exists() && file.length() > 0L) {
                file.delete();
            }
            ImageDownloadTask task = new ImageDownloadTask(url, file.getAbsolutePath(), callback);
            task.execute(new Void[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readFile2String(File file) {
        String text = "";
        try {
            if (file.isFile() && file.exists()) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = fis.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
                byte[] b = outStream.toByteArray();
                fis.close();
                outStream.flush();
                outStream.close();
                text = new String(b);
            } else {
                VLog.e((String)TAG, (String)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            VLog.e((String)TAG, (String)"\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
            e.printStackTrace();
        }
        return text;
    }

    public static String readFile2ByteArray(File file) {
        try {
            if (file.isFile() && file.exists()) {
                ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = fis.read(buffer)) != -1) {
                    outStream.write(buffer, 0, length);
                }
                byte[] b = outStream.toByteArray();
                fis.close();
                outStream.flush();
                outStream.close();
                String code = "UTF-8";
                if (b[0] == -1 && b[1] == -2) {
                    code = "UTF-16LE";
                } else if (b[0] == -2 && b[1] == -1) {
                    code = "UTF-16BE";
                }
                return new String(b, code);
            }
            VLog.e((String)TAG, (String)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684\u6587\u4ef6");
        }
        catch (Exception e) {
            VLog.e((String)TAG, (String)"\u8bfb\u53d6\u6587\u4ef6\u5185\u5bb9\u51fa\u9519");
            e.printStackTrace();
        }
        return null;
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static class ImageDownloadTask
    extends AsyncTask<Void, Void, File> {
        private String remoteURL;
        private String localURL;
        private FileCallback mCallback;

        ImageDownloadTask(String remote, String local, FileCallback callback) {
            this.remoteURL = remote;
            this.localURL = local;
            this.mCallback = callback;
            VLog.d((String)FileUtil.TAG, (String)(remote + ":" + local));
        }

        protected void onPreExecute() {
            super.onPreExecute();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected File doInBackground(Void ... params) {
            File file = null;
            try {
                Request request = new Request.Builder().url(this.remoteURL).build();
                Response response = VHAPI.getOkHttpClient().newCall(request).execute();
                InputStream is = response.body().byteStream();
                byte[] buf = new byte[2048];
                int len = 0;
                FileOutputStream fos = null;
                try {
                    file = new File(this.localURL);
                    fos = new FileOutputStream(file);
                    while ((len = is.read(buf)) != -1) {
                        fos.write(buf, 0, len);
                    }
                    fos.flush();
                }
                catch (Exception exception) {
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fos != null) {
                            fos.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return file;
        }

        protected void onPostExecute(File file) {
            super.onPostExecute((Object)file);
            this.mCallback.onFile(file);
        }

        protected void onCancelled() {
            this.mCallback.onFile(null);
        }
    }

    public static interface FileCallback {
        public void onFile(File var1);
    }
}

