/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.framework.connect;

import android.app.Service;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Base64;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.chat.ChatServerV2;
import com.vhall.chat.ConnectServerV2;
import com.vhall.chat.VHChatServerV2Def;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.utils.GzipUtil;
import com.vhall.framework.utils.InternalUtils;
import com.vhall.framework.utils.JsonUtil;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.message.ChatServer;
import com.vhall.message.ConnectServer;
import com.vhall.message.MessageServer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CopyOnWriteArraySet;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VhallConnectService
extends Service {
    private static final String TAG = "VhallConnectService";
    private static final int PROTECT_MIL_SECONDS = 5000;
    private static final int SERVICE_RETRY_INTERVAL = 2000;
    public static final int SERVER_MSG = 1;
    public static final int SERVER_CHAT = 2;
    private static final int EVENT_TYPE_INIT = 0;
    private static final int EVENT_TYPE_JOIN_CHANNEL_ID = 1;
    private static final int EVENT_TYPE_UPDATE_USER_ID = 2;
    public ConnectBinder mBinder;
    private Handler mDelivery;
    private CopyOnWriteArraySet<IVHService> services = new CopyOnWriteArraySet();
    private CopyOnWriteArraySet<String> channels = new CopyOnWriteArraySet();
    private String mUserId = "";
    private String mMsgServerURL = "";
    private String mChatServerURL = "";
    private String mMsgToken = "";
    private MessageServer mMsgServer;
    private boolean mIsUsedChatV1 = true;
    private ChatServer mChatServerV1;
    private ChatServerV2 mChatServerV2;
    VHChatServerV2Def.ConnectConfigInfo mChatV2Config = new VHChatServerV2Def.ConnectConfigInfo();
    private CopyOnWriteArraySet<String> mCompChannels = new CopyOnWriteArraySet();
    private boolean isInited = false;
    private boolean isFirstJoinChannel = false;
    private String userInfoStr = "";
    private boolean hide = false;
    private VhallBaseSDK.InitCallback initCallback;
    private IVHBeautifyInitListener mBeautifyInitListener;
    private String firstJoinChannelID = "";
    private String firstJoinAccessToken = "";
    private JSONObject mBeautifyConfig = null;
    private Timer mTimer;
    private ProtectTask mProTask;
    private boolean requestInit = false;
    ConnectServer.EventCallback msgCallback = new ConnectServer.EventCallback(){

        public void onStateChanged(ConnectServer.State state) {
            VLog.d((String)VhallConnectService.TAG, (String)("onStateChanged: " + state.toString() + "   mMsgServerURL=     " + VhallConnectService.this.mMsgServer.getUrl()));
            VhallConnectService.this.sendConnectEvent(state, 1);
            switch (state) {
                case STATE_DISCONNECT: {
                    break;
                }
                case STATE_CONNECTIONG: {
                    break;
                }
                case STATE_CONNECTED: {
                    VhallConnectService.this.joinAllChannel();
                }
            }
        }

        public void onMsg(final String msg) {
            if (TextUtils.isEmpty((CharSequence)msg)) {
                return;
            }
            VhallConnectService.this.mDelivery.post(new Runnable(){

                @Override
                public void run() {
                    VhallConnectService.this.onProcessMsg(msg);
                }
            });
        }

        public void onMsg(String event, String msg) {
        }
    };
    ConnectServerV2.EventCallback chatV2CallBack = new ConnectServerV2.EventCallback(){

        public void onStateChanged(ConnectServerV2.NetState state) {
            switch (state) {
                case STATE_CONNECTING: {
                    VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_CONNECTIONG, 2);
                    break;
                }
                case STATE_SIG_EXPIRED: {
                    VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, 2);
                    break;
                }
                case STATE_CONNECTED: {
                    VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_CONNECTED, 2);
                    break;
                }
                case STATE_KICK_OFF: {
                    VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_KICK_OFF, 2);
                    break;
                }
            }
        }

        public void onMsg(String group_id, String msg) {
            VhallConnectService.this.receiveChatMsg(msg);
        }

        public void onInit(String desc) {
            VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, 2);
            VhallConnectService.this.mDelivery.postDelayed((Runnable)VhallConnectService.this.mReconnectTXIM, 2000L);
        }

        public void onLoginState(ConnectServerV2.JoinState state, int code, String desc) {
            if (state == ConnectServerV2.JoinState.STATE_LOGIN_FAILED) {
                VhallConnectService.this.mDelivery.postDelayed((Runnable)VhallConnectService.this.mReconnectTXIM, 2000L);
                VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, 2);
            }
        }

        public void onGroupState(ConnectServerV2.JoinState state, String group_id, int code, String data) {
            if (state == ConnectServerV2.JoinState.STATE_JOIN_GROUP_FAILED) {
                VhallConnectService.this.mDelivery.postDelayed((Runnable)VhallConnectService.this.mReconnectTXIM, 2000L);
                VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, 2);
            } else if (state == ConnectServerV2.JoinState.STATE_JOIN_GROUP_SUCCESS) {
                VhallConnectService.this.sendConnectEvent(ConnectServer.State.STATE_CONNECTED, 2);
            }
        }
    };
    ConnectServer.EventCallback chatCallback = new ConnectServer.EventCallback(){

        public void onStateChanged(ConnectServer.State state) {
            VhallConnectService.this.sendConnectEvent(state, 2);
        }

        public void onMsg(String msg) {
            VhallConnectService.this.receiveChatMsg(msg);
        }

        public void onMsg(String event, String msg) {
        }
    };
    private IInitSDKRunnable mInitSDKRunnable = new IInitSDKRunnable();
    private IJoinChannelIdRunnable mJoinChannelIdRunnable = new IJoinChannelIdRunnable();
    private IUpdateUserIdRunnable mUpdateUserIdRunnable = new IUpdateUserIdRunnable();
    private IReconnectTXIm mReconnectTXIM = new IReconnectTXIm();

    public void onCreate() {
        super.onCreate();
        this.mBinder = new ConnectBinder();
        this.mDelivery = new Handler(this.getMainLooper());
        this.mMsgServer = new MessageServer();
        this.mMsgServer.setEventCallback(this.msgCallback);
        this.mChatServerV1 = new ChatServer();
        this.mChatServerV1.setEventCallback(this.chatCallback);
        this.mChatServerV2 = new ChatServerV2();
        this.mChatServerV2.setEventCallback(this.chatV2CallBack);
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    public IBinder onBind(Intent intent) {
        this.init(intent);
        return this.mBinder;
    }

    public void onRebind(Intent intent) {
        this.init(intent);
    }

    private void init(Intent intent) {
        this.mUserId = intent.getStringExtra("third_party_user_id");
        this.userInfoStr = intent.getStringExtra("userInfo");
        this.hide = intent.getBooleanExtra("hide", false);
        this.isInited = false;
        this.isFirstJoinChannel = false;
        this.disConnect();
    }

    public CopyOnWriteArraySet<IVHService> getServices() {
        return this.services;
    }

    private void startProtect() {
        this.stopProtect();
        this.mProTask = new ProtectTask();
        this.mTimer = new Timer(true);
        this.mTimer.schedule((TimerTask)this.mProTask, 0L, 5000L);
    }

    private synchronized void stopProtect() {
        if (this.mProTask != null) {
            this.mProTask.cancel();
            this.mProTask = null;
        }
        if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer.purge();
            this.mTimer = null;
        }
    }

    private void disConnect() {
        if (this.mMsgServer != null) {
            this.mMsgServer.disconnectForce();
        }
        this.chatDisconnect();
    }

    private void reConnect() {
        if (this.mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
            this.joinAllChannel();
        } else {
            this.connect2MsgServer();
        }
        this.connect2ChatServer();
    }

    @Deprecated
    private void reConnectForUpdaeUserInfo() {
        if (this.mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
            this.connect2MsgServer();
        } else {
            this.leaveAllChannelForInfoChange();
            this.joinAllChannel();
        }
    }

    private void reConnectTestWhenFirstJoin() {
        this.isFirstJoinChannel = false;
        this.startProtect();
    }

    private void connect2MsgServer() {
        if (this.mMsgServer != null) {
            this.mMsgServer.disconnectForce();
        }
        if (!TextUtils.isEmpty((CharSequence)this.mMsgToken) && !TextUtils.isEmpty((CharSequence)this.mMsgServerURL)) {
            this.mMsgServer.setToken(this.mMsgToken);
            this.mMsgServer.connect(this.mMsgServerURL);
        }
    }

    private void connect2ChatServer() {
        if (this.mIsUsedChatV1 && this.mChatServerV1 != null) {
            this.mChatServerV1.connect(this.getChatURL());
        }
        if (!this.mIsUsedChatV1 && this.mChatServerV2 != null && this.mChatV2Config != null && this.mChatV2Config.group_list.size() > 0) {
            if (null != this.mDelivery) {
                this.mDelivery.removeCallbacks((Runnable)this.mReconnectTXIM);
            }
            this.mChatServerV2.connect(this.mChatV2Config);
        }
    }

    public void setUserId(String userId) {
        if (this.mUserId.equals(userId)) {
            return;
        }
        if (this.judgeMsg()) {
            this.leaveAllChannelForInfoChange();
            this.mUserId = userId;
            try {
                JSONObject userInfo = new JSONObject(this.userInfoStr);
                userInfo.put("third_party_user_id", (Object)this.mUserId);
                this.userInfoStr = userInfo.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.attemptUpdateUserId(this.firstJoinChannelID, this.firstJoinAccessToken);
        } else {
            this.mUserId = userId;
            try {
                JSONObject userInfo = new JSONObject(this.userInfoStr);
                userInfo.put("third_party_user_id", (Object)this.mUserId);
                this.userInfoStr = userInfo.toString();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        this.isInited = false;
        if (!TextUtils.isEmpty((CharSequence)this.firstJoinAccessToken)) {
            this.isInited = true;
            this.attemptInit(this.firstJoinAccessToken);
        }
    }

    public void setHide(Boolean isHide) {
        if (this.hide == isHide) {
            return;
        }
        if (this.judgeMsg()) {
            this.leaveAllChannelForInfoChange();
            this.hide = isHide;
            this.reConnect();
        } else {
            this.hide = isHide;
        }
    }

    public boolean setUserInfo(String jsonStr) {
        try {
            JSONObject obj = new JSONObject(jsonStr);
            String third_party_user_id = obj.optString("third_party_user_id");
            if (TextUtils.equals((CharSequence)third_party_user_id, (CharSequence)this.mUserId)) {
                this.userInfoStr = jsonStr;
                if (this.judgeMsg()) {
                    this.joinAllChannel();
                }
                return true;
            }
            if (this.judgeMsg()) {
                this.leaveAllChannelForInfoChange();
                this.mUserId = third_party_user_id;
                this.userInfoStr = jsonStr;
                this.attemptUpdateUserId(this.firstJoinChannelID, this.firstJoinAccessToken);
            } else {
                this.mUserId = third_party_user_id;
                this.userInfoStr = jsonStr;
            }
            this.isInited = false;
            if (!TextUtils.isEmpty((CharSequence)this.firstJoinAccessToken)) {
                this.isInited = true;
                this.attemptInit(this.firstJoinAccessToken);
            }
            return true;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean updateUserInfo(String jsonStr) {
        this.userInfoStr = jsonStr;
        if (this.judgeMsg()) {
            this.joinAllChannel();
        }
        return true;
    }

    private boolean judgeMsg() {
        return this.mMsgServer != null && this.mMsgServer.getState() != ConnectServer.State.STATE_DISCONNECT && this.services.size() > 0 && this.channels.size() > 0;
    }

    private void joinAllChannel() {
        if (this.channels.size() > 0) {
            for (String channel : this.channels) {
                try {
                    JSONObject obj = new JSONObject();
                    channel = this.getChannelIdWithComp(channel);
                    obj.put("channel", (Object)channel).put("third_party_user_id", (Object)this.mUserId).put("context", (Object)this.userInfoStr).put("hide", this.hide);
                    this.mMsgServer.join(obj);
                    this.makeMSGReport("113500", channel);
                    VLog.d((String)TAG, (String)("emit:" + obj));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void leaveAllChannelForInfoChange() {
        if (this.channels.size() > 0) {
            for (String channel : this.channels) {
                try {
                    JSONObject obj = new JSONObject();
                    channel = this.getChannelIdWithComp(channel);
                    obj.put("channel", (Object)channel).put("third_party_user_id", (Object)this.mUserId).put("context", (Object)this.userInfoStr);
                    this.mMsgServer.leave(obj);
                    VLog.d((String)TAG, (String)("service leave:" + channel));
                    this.makeMSGReport("113502", channel);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String getChatURL() {
        if (TextUtils.isEmpty((CharSequence)this.mChatServerURL) || this.channels.size() <= 0) {
            return null;
        }
        String id = "";
        if (this.channels.size() > 0) {
            for (String channnel : this.channels) {
                String comp_channel;
                if (this.mCompChannels.size() > 0 && this.mCompChannels.contains(comp_channel = "comp_" + channnel)) {
                    channnel = comp_channel;
                }
                id = id + "/" + channnel;
            }
        }
        String url = this.mChatServerURL + "/ws" + id + "?_=" + System.currentTimeMillis() + "&tag=0&time=&eventid=";
        return url;
    }

    private void paramMsgEncodeMessage(JSONObject obj) {
        try {
            boolean isEncodingText = true;
            String encoding = obj.optString("comp_alg");
            if (encoding.equals("n")) {
                isEncodingText = false;
            }
            if (obj.has("content")) {
                String content;
                String messageOriginalContent = content = obj.optString("content");
                if (isEncodingText) {
                    messageOriginalContent = new String(GzipUtil.unCompress(Base64.decode((String)content, (int)0)), "UTF-8");
                }
                JSONArray messages = new JSONArray(messageOriginalContent);
                for (int i = 0; i < messages.length(); ++i) {
                    JSONArray msgString = messages.getJSONArray(i);
                    if (msgString.length() < 2) continue;
                    String command = msgString.getString(0);
                    String jsonContentString = msgString.getString(1);
                    this.disPatchMsg(jsonContentString);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void disPatchMsg(String message) {
        if (TextUtils.isEmpty((CharSequence)message)) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(message);
            String id = this.getChannelIdWithOutComp(obj.optString("channel"));
            for (IVHService service : this.services) {
                if (!TextUtils.isEmpty((CharSequence)id) && !service.getChannelId().contains(id)) continue;
                service.onMessage(message);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public synchronized void join(IVHService service) {
        if (service == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)service.getAccessToken())) {
            return;
        }
        if (!this.requestInit) {
            this.requestInit = true;
            this.firstJoinAccessToken = service.getAccessToken();
            this.attemptInit(service, service.getAccessToken());
        } else if (this.isBeautifyService(service) && null != this.mBeautifyInitListener) {
            if (null != this.mBeautifyConfig && this.mBeautifyConfig.optBoolean("enable")) {
                this.mBeautifyInitListener.onSuccess();
            } else {
                this.mBeautifyInitListener.onError(0, "beauty config is off");
            }
        } else if (this.isVHLssV2Service(service) && null != this.initCallback) {
            String url = VhallBaseSDK.getInstance().getLicenseUrl();
            String key = VhallBaseSDK.getInstance().getLicenseKey();
            if (url != null && key != null && !url.isEmpty() && !key.isEmpty()) {
                this.initCallback.onSuccess();
            } else {
                this.attemptInit(service, service.getAccessToken());
            }
        }
        if (this.serviceNotReadyForMsg(service)) {
            return;
        }
        if (this.services.add(service) && this.channels.add(service.getChannelId())) {
            if (TextUtils.isEmpty((CharSequence)this.firstJoinChannelID) && (service.getChannelId().startsWith("ch_") || service.getChannelId().startsWith("inav_"))) {
                this.firstJoinChannelID = service.getChannelId();
                this.firstJoinAccessToken = service.getAccessToken();
                this.reConnectTestWhenFirstJoin();
                return;
            }
            if (this.mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (this.mMsgServer.getState() == ConnectServer.State.STATE_CONNECTED) {
                try {
                    String join_channel = service.getChannelId();
                    JSONObject object = new JSONObject();
                    if (this.mCompChannels.contains("comp_" + join_channel)) {
                        join_channel = "comp_" + join_channel;
                    }
                    object.put("channel", (Object)join_channel).put("third_party_user_id", (Object)this.mUserId).put("context", (Object)this.userInfoStr).put("hide", this.hide);
                    this.mMsgServer.join(object);
                    this.makeMSGReport("113500", service.getChannelId());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            this.connect2ChatServer();
        }
    }

    private void makeMSGReport(String event, String channelId) {
        JSONObject pushConfig = new JSONObject();
        try {
            pushConfig.put("channel_id", (Object)channelId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollectionWithBData(event, pushConfig);
    }

    private boolean serviceNotReadyForMsg(IVHService service) {
        return TextUtils.isEmpty((CharSequence)service.getChannelId()) || TextUtils.isEmpty((CharSequence)service.getAccessToken()) || this.isBeautifyService(service) || this.isVHLssV2Service(service);
    }

    private boolean isBeautifyService(IVHService service) {
        return null != service && !TextUtils.isEmpty((CharSequence)service.getChannelId()) && service.getChannelId().equals("vhbeautify");
    }

    private boolean isVHLssV2Service(IVHService service) {
        return null != service && !TextUtils.isEmpty((CharSequence)service.getChannelId()) && service.getChannelId().equals("vh_lss_v2");
    }

    private String getChannelIdWithOutComp(String channel_id) {
        String new_channelId = channel_id;
        if (new_channelId.contains("comp_")) {
            new_channelId = new_channelId.replace("comp_", "");
        }
        return new_channelId;
    }

    private String getChannelIdWithComp(String channel_id) {
        String new_channelId = channel_id;
        if (this.mCompChannels.contains("comp_" + channel_id)) {
            new_channelId = "comp_" + channel_id;
        }
        return new_channelId;
    }

    private void chatDisconnect() {
        if (this.mIsUsedChatV1 && this.mChatServerV1 != null) {
            this.mChatServerV1.disconnect();
        }
        if (!this.mIsUsedChatV1 && this.mChatServerV2 != null) {
            if (null != this.mDelivery) {
                this.mDelivery.removeCallbacks((Runnable)this.mReconnectTXIM);
            }
            this.mChatServerV2.disconnect();
        }
    }

    public synchronized void leave(IVHService service) {
        if (service == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)service.getChannelId())) {
            return;
        }
        if (this.services.remove(service)) {
            boolean check = false;
            for (IVHService server : this.services) {
                if (!server.getChannelId().equals(service.getChannelId())) continue;
                check = true;
                break;
            }
            if (!check) {
                if (this.channels.contains(service.getChannelId())) {
                    this.channels.remove(service.getChannelId());
                }
                if (this.mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
                    this.connect2MsgServer();
                } else {
                    try {
                        JSONObject obj = new JSONObject();
                        String leave_channel = this.getChannelIdWithComp(service.getChannelId());
                        obj.put("channel", (Object)leave_channel).put("third_party_user_id", (Object)this.mUserId).put("context", (Object)this.userInfoStr);
                        this.mMsgServer.leave(obj);
                        if (!this.mIsUsedChatV1) {
                            InternalUtils.randomInt(50, 100);
                        }
                        VLog.d((String)TAG, (String)("service leave:" + service.getChannelId()));
                        this.makeMSGReport("113502", service.getChannelId());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                this.chatDisconnect();
                if (this.mCompChannels.contains("comp_" + service.getChannelId())) {
                    this.mCompChannels.remove("comp_" + service.getChannelId());
                }
            }
            if (this.services.size() == 0) {
                this.firstJoinChannelID = "";
                this.firstJoinAccessToken = "";
                this.isFirstJoinChannel = false;
                this.mMsgToken = "";
                this.stopProtect();
                if (this.mMsgServer != null) {
                    this.mMsgServer.disconnectForce();
                }
                this.chatDisconnect();
                if (null != this.mDelivery) {
                    this.mDelivery.removeCallbacks((Runnable)this.mInitSDKRunnable);
                    this.mDelivery.removeCallbacks((Runnable)this.mJoinChannelIdRunnable);
                    this.mDelivery.removeCallbacks((Runnable)this.mUpdateUserIdRunnable);
                    this.mDelivery.removeCallbacks((Runnable)this.mReconnectTXIM);
                }
            }
        }
    }

    private void paramJsonData(String msg) {
        try {
            JSONArray messages = new JSONArray(msg);
            for (int i = 0; i < messages.length(); ++i) {
                JSONArray msgString;
                Object o = messages.get(i);
                if (o instanceof String) {
                    this.disPatchMsg((String)o);
                    continue;
                }
                if (o instanceof JSONObject) {
                    this.disPatchMsg(o.toString());
                    continue;
                }
                if (!(o instanceof JSONArray) || (msgString = (JSONArray)o).length() < 2) continue;
                String command = msgString.getString(0);
                String jsonContentString = msgString.getString(1);
                this.disPatchMsg(jsonContentString);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void processJsonMessage(String msg) {
        try {
            JSONObject obj = new JSONObject(msg);
            if (obj.has("text")) {
                JSONObject text = new JSONObject(URLDecoder.decode(obj.optString("text"), "UTF-8"));
                this.processEncodeData(text, msg);
            } else if (obj.has("comp_alg")) {
                this.processEncodeData(obj, msg);
            } else {
                this.disPatchMsg(msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void processJsonArray(String msg) {
        try {
            JSONArray messages = new JSONArray(msg);
            if (messages.length() == 2) {
                String command = messages.getString(0);
                String jsonContentString = messages.getString(1);
                this.processJsonMessage(jsonContentString);
            } else {
                this.paramJsonData(msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void onProcessMsg(String msg) {
        if (JsonUtil.isJsonObj(msg)) {
            this.processJsonMessage(msg);
        } else if (JsonUtil.isJsonArray(msg)) {
            this.processJsonArray(msg);
        } else {
            this.disPatchMsg(msg);
        }
    }

    private void processEncodeData(JSONObject text, String recMsg) {
        try {
            boolean isEncodingText = true;
            if (text.has("comp_alg")) {
                String encoding = text.optString("comp_alg");
                if (encoding.equals("n")) {
                    isEncodingText = false;
                }
                if (text.has("content")) {
                    String content;
                    String message = content = text.optString("content");
                    if (isEncodingText) {
                        message = new String(GzipUtil.unCompress(Base64.decode((String)content, (int)0)), "UTF-8");
                    }
                    this.paramJsonData(message);
                }
            } else {
                this.disPatchMsg(recMsg);
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void receiveChatMsg(final String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                VhallConnectService.this.onProcessMsg(msg);
            }
        });
    }

    public boolean onUnbind(Intent intent) {
        this.stopProtect();
        this.disConnect();
        return super.onUnbind(intent);
    }

    public void onDestroy() {
        this.initCallback = null;
        this.mBeautifyInitListener = null;
        this.disConnect();
        this.stopProtect();
        this.isInited = false;
        this.isFirstJoinChannel = false;
        if (this.mChatServerV2 != null) {
            this.mChatServerV2.destory();
        }
        super.onDestroy();
    }

    private boolean checkConnect() {
        ConnectivityManager manager = (ConnectivityManager)this.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null) {
            return networkInfo.isAvailable();
        }
        return false;
    }

    public void sendConnectEvent(final ConnectServer.State state, final int type) {
        if (this.services.size() == 0) {
            return;
        }
        this.mDelivery.post(new Runnable(){

            @Override
            public void run() {
                for (IVHService service : VhallConnectService.this.services) {
                    service.onConnectStateChanged(state, type);
                }
            }
        });
    }

    private void attemptInit(String accessToken) {
        this.attemptInit(null, accessToken);
    }

    private void attemptInit(final IVHService service, String accessToken) {
        VHAPI.initSDK(accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                if (TextUtils.isEmpty((CharSequence)VhallConnectService.this.firstJoinAccessToken)) {
                    VhallConnectService.this.isInited = false;
                    return;
                }
                if (null != VhallConnectService.this.mDelivery) {
                    VhallConnectService.this.mDelivery.postDelayed((Runnable)VhallConnectService.this.mInitSDKRunnable, 2000L);
                }
            }

            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    try {
                        VhallConnectService.this.dealResult(response.body().string(), 0, service);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        VhallConnectService.this.isInited = false;
                    }
                } else {
                    VhallConnectService.this.isInited = false;
                }
            }
        });
    }

    private void attemptJoinChannelId(String channelId, String accessToken) {
        VHAPI.joinChannelId(channelId, accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                if (TextUtils.isEmpty((CharSequence)VhallConnectService.this.firstJoinAccessToken) || TextUtils.isEmpty((CharSequence)VhallConnectService.this.firstJoinChannelID)) {
                    VhallConnectService.this.isFirstJoinChannel = false;
                    return;
                }
                if (null != VhallConnectService.this.mDelivery) {
                    VhallConnectService.this.mDelivery.postDelayed((Runnable)VhallConnectService.this.mJoinChannelIdRunnable, 2000L);
                }
            }

            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    try {
                        VhallConnectService.this.dealResult(response.body().string(), 1);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        VhallConnectService.this.isFirstJoinChannel = false;
                    }
                } else {
                    VhallConnectService.this.isFirstJoinChannel = false;
                }
            }
        });
    }

    private void attemptUpdateUserId(String channelId, String accessToken) {
        VHAPI.updateUserId(channelId, accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                if (TextUtils.isEmpty((CharSequence)VhallConnectService.this.firstJoinAccessToken) || TextUtils.isEmpty((CharSequence)VhallConnectService.this.firstJoinChannelID)) {
                    return;
                }
                if (null != VhallConnectService.this.mDelivery) {
                    VhallConnectService.this.mDelivery.postDelayed((Runnable)VhallConnectService.this.mUpdateUserIdRunnable, 2000L);
                }
            }

            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    try {
                        VhallConnectService.this.dealResult(response.body().string(), 2);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void dealResult(String json, int type) {
        this.dealResult(json, type, null);
    }

    private void dealResult(String json, int type, IVHService service) {
        try {
            JSONObject data;
            JSONObject result = new JSONObject(json);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200 && (data = result.optJSONObject("data")) != null) {
                JSONObject beautyConfig;
                VhallBaseSDK.getInstance().mDocHost = data.optString("document_server");
                VhallBaseSDK.getInstance().mLogHost = data.optString("log_server");
                JSONObject obj = data.optJSONObject("document_config");
                if (obj != null) {
                    VhallBaseSDK.getInstance().documentExt = obj.optJSONArray("ext").toString();
                    VhallBaseSDK.getInstance().documentMaxSize = obj.optInt("maxSize");
                }
                this.getLogInfo(data.optJSONObject("log_info"));
                this.mBeautifyConfig = beautyConfig = data.optJSONObject("beauty_config");
                VHBeautifyKit.getInstance().setEnableConfig(beautyConfig);
                if (this.isBeautifyService(service)) {
                    if (null != beautyConfig && beautyConfig.optBoolean("enable")) {
                        VHBeautifyKit.getInstance().init(this.getApplication(), this.mBeautifyInitListener);
                    } else if (null != this.mBeautifyInitListener) {
                        this.mBeautifyInitListener.onError(-1, "beauty config is off");
                    }
                }
                if (data.has("push_stream_license")) {
                    try {
                        JSONObject push_stream_license = data.optJSONObject("push_stream_license");
                        if (push_stream_license.has("license_url")) {
                            VhallBaseSDK.getInstance().mLicenseUrl = push_stream_license.optString("license_url");
                        }
                        if (push_stream_license.has("license_key")) {
                            VhallBaseSDK.getInstance().mLicenseKey = push_stream_license.optString("license_key");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (type != 0) {
                    this.mMsgServerURL = data.getString("socket_server");
                    this.mMsgToken = data.getString("connection_token");
                    this.mChatServerURL = data.getString("nginx_server");
                    if (data.has("comp_channel_id")) {
                        String comp_channel_id = data.getString("comp_channel_id");
                        this.mCompChannels.add(comp_channel_id);
                    }
                    if (type == 1) {
                        this.mIsUsedChatV1 = true;
                        if (data.has("extra_connection_info")) {
                            JSONObject extra_info = data.optJSONObject("extra_connection_info");
                            this.mChatV2Config.context = this.getBaseContext();
                            if (extra_info.has("tim_connection_info")) {
                                JSONObject tim_info = extra_info.optJSONObject("tim_connection_info");
                                this.mChatV2Config.sdk_app_id = tim_info.getString("sdk_app_id");
                                this.mChatV2Config.user_id = tim_info.getString("user_id");
                                this.mChatV2Config.user_sig = tim_info.getString("user_sig");
                                this.mChatV2Config.group_list.clear();
                                JSONArray groups = tim_info.optJSONArray("group_list");
                                if (groups != null && groups.length() > 0) {
                                    for (int i = 0; i < groups.length(); ++i) {
                                        JSONObject group = groups.getJSONObject(i);
                                        this.mChatV2Config.group_list.put(group.optString("group_id"), group.optString("group_type"));
                                        this.mIsUsedChatV1 = false;
                                    }
                                }
                            }
                        }
                        this.trackInitEvent();
                        this.isFirstJoinChannel = true;
                        this.connect2ChatServer();
                        this.startProtect();
                    } else if (type == 2) {
                        this.reConnect();
                    }
                } else {
                    this.isInited = true;
                }
                VLog.d((String)TAG, (String)"SDK\u6d88\u606f\u521d\u59cb\u5316\u5b8c\u6210\uff01");
                if (this.initCallback != null) {
                    this.initCallback.onSuccess();
                }
                return;
            }
            VLog.e((String)TAG, (String)("\u521d\u59cb\u5316\u6d88\u606f\u5931\u8d25:" + msg));
            if (this.isBeautifyService(service) && null != this.mBeautifyInitListener) {
                this.mBeautifyInitListener.onError(-2, msg);
            }
            if (this.initCallback != null) {
                this.initCallback.onFailure(msg);
            }
            if (type == 0) {
                this.isInited = false;
            } else if (type == 1) {
                this.isFirstJoinChannel = false;
                this.trackInitEvent(code + ":" + msg);
            }
        }
        catch (Exception e) {
            if (this.initCallback != null) {
                this.initCallback.onFailure(e.getMessage());
            }
            VLog.e((String)TAG, (String)("\u521d\u59cb\u5316\u6d88\u606f\u5931\u8d25:" + e.getMessage()));
            if (type == 0) {
                this.isInited = false;
            } else if (type == 1) {
                this.isFirstJoinChannel = false;
                this.trackInitEvent("-2");
            }
            e.printStackTrace();
        }
    }

    private void trackInitEvent(String error) {
        LogReporter.getInstance().setErr(error);
        JSONObject params = new JSONObject();
        try {
            params.put("firstChannelId", (Object)this.firstJoinChannelID);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2001", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("firstChannelId", (Object)this.firstJoinChannelID);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2001", params);
    }

    public boolean isInited() {
        return this.isInited;
    }

    private void getLogInfo(JSONObject log) {
        LogInfo logInfo = LogInfo.getInstance();
        if (log != null) {
            logInfo.initStaticData(VhallBaseSDK.getInstance().getAPP_ID(), VhallBaseSDK.getInstance().mIMEI, VhallBaseSDK.getInstance().mLogHost, 5, 1);
            logInfo.initBaseData(log);
        }
    }

    public void setInitCallback(VhallBaseSDK.InitCallback callback) {
        this.initCallback = callback;
    }

    public void setBeautifyInitCallback(IVHBeautifyInitListener beautifyInitListener) {
        this.mBeautifyInitListener = beautifyInitListener;
    }

    private class IReconnectTXIm
    implements Runnable {
        private IReconnectTXIm() {
        }

        @Override
        public void run() {
            VhallConnectService.this.mChatServerV2.connect(VhallConnectService.this.mChatV2Config);
        }
    }

    private class IUpdateUserIdRunnable
    implements Runnable {
        private IUpdateUserIdRunnable() {
        }

        @Override
        public void run() {
            if (VhallConnectService.this.checkConnect()) {
                VhallConnectService.this.attemptUpdateUserId(VhallConnectService.this.firstJoinChannelID, VhallConnectService.this.firstJoinAccessToken);
            }
        }
    }

    private class IJoinChannelIdRunnable
    implements Runnable {
        private IJoinChannelIdRunnable() {
        }

        @Override
        public void run() {
            if (VhallConnectService.this.checkConnect()) {
                VhallConnectService.this.attemptJoinChannelId(VhallConnectService.this.firstJoinChannelID, VhallConnectService.this.firstJoinAccessToken);
            }
        }
    }

    private class IInitSDKRunnable
    implements Runnable {
        private IInitSDKRunnable() {
        }

        @Override
        public void run() {
            if (VhallConnectService.this.checkConnect()) {
                VhallConnectService.this.attemptInit(VhallConnectService.this.firstJoinAccessToken);
            }
        }
    }

    class ProtectTask
    extends TimerTask {
        ProtectTask() {
        }

        @Override
        public void run() {
            if (!VhallConnectService.this.isFirstJoinChannel) {
                VhallConnectService.this.attemptJoinChannelId(VhallConnectService.this.firstJoinChannelID, VhallConnectService.this.firstJoinAccessToken);
            } else if (VhallConnectService.this.services.size() > 0 && VhallConnectService.this.checkConnect()) {
                if (VhallConnectService.this.mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
                    VhallConnectService.this.connect2MsgServer();
                }
                if (VhallConnectService.this.mIsUsedChatV1 && VhallConnectService.this.mChatServerV1.getState() == ConnectServer.State.STATE_DISCONNECT) {
                    VhallConnectService.this.connect2ChatServer();
                }
                if (!VhallConnectService.this.mIsUsedChatV1 && VhallConnectService.this.mChatServerV2.getState() == ConnectServerV2.NetState.STATE_DISCONNECT) {
                    VhallConnectService.this.connect2ChatServer();
                }
            }
        }
    }

    public class ConnectBinder
    extends Binder {
        public VhallConnectService getService() {
            return VhallConnectService.this;
        }
    }

    public static interface OnConnectStateChangedListener {
        public void onStateChanged(ConnectServer.State var1, int var2);
    }
}

