package com.vhall.framework.connect;

import static com.tencent.imsdk.base.ThreadUtils.runOnUiThread;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.Handler;
import android.os.IBinder;
import android.text.TextUtils;
import android.util.Base64;

import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.chat.ChatServerV2;
import com.vhall.chat.ConnectServerV2;
import com.vhall.chat.VHChatServerV2Def;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.framework.beautify.BeautifyRegServiceImpl;
import com.vhall.framework.lssv2.VHV2PusherServiceImpl;
import com.vhall.framework.utils.GenerateTestUserSig;
import com.vhall.framework.utils.GzipUtil;
import com.vhall.framework.utils.InternalUtils;
import com.vhall.framework.utils.JsonUtil;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.logmanager.VLog;
import com.vhall.message.ChatServer;
import com.vhall.message.ConnectServer;
import com.vhall.message.MessageServer;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

/**
 * Created by Hank on 2017/11/27.
 */
public class VhallConnectService extends Service {

    private static final String TAG = "VhallConnectService";
    private static final int PROTECT_MIL_SECONDS = 5000;
    /**
     * 该类下各业务接口失败重连间隔
     */
    private static final int SERVICE_RETRY_INTERVAL = 2000;
    public static final int SERVER_MSG = 1;
    public static final int SERVER_CHAT = 2;

    private static final int EVENT_TYPE_INIT = 0;
    private static final int EVENT_TYPE_JOIN_CHANNEL_ID = 1;
    private static final int EVENT_TYPE_UPDATE_USER_ID = 2;
    public ConnectBinder mBinder;
    private Handler mDelivery;
    //不同的服务可能拥有相同的渠道ID
    private CopyOnWriteArraySet<IVHService> services = new CopyOnWriteArraySet<IVHService>();
    private CopyOnWriteArraySet<String> channels = new CopyOnWriteArraySet<String>();
    private String mUserId = "";
    private String mMsgServerURL = "";
    private String mChatServerURL = "";

    private String mMsgToken = "";
    private MessageServer mMsgServer;
    private boolean mIsUsedChatV1 = true;
    private ChatServer mChatServerV1;
    private ChatServerV2 mChatServerV2;
    VHChatServerV2Def.ConnectConfigInfo mChatV2Config = new VHChatServerV2Def.ConnectConfigInfo();
    private CopyOnWriteArraySet<String> mCompChannels = new CopyOnWriteArraySet<String>();
    /**
     * 初始化成功
     */
    private boolean isInited = false;
    /**
     * 第一个 channel 加入成功过
     */
    private boolean isFirstJoinChannel = false;
    private String userInfoStr = "";
    private boolean hide = false;
    private VhallBaseSDK.InitCallback initCallback;
    private IVHBeautifyInitListener mBeautifyInitListener;
    private String firstJoinChannelID = "";//第一次JoinID
    private String firstJoinAccessToken = "";//第一次加入服务的 token
    private JSONObject mBeautifyConfig = null;

    private Timer mTimer;
    private ProtectTask mProTask;
    /**
     * hkl
     * 是否 请求了Init 只请求一次
     */
    private boolean requestInit = false;

    public interface OnConnectStateChangedListener {
        void onStateChanged(ConnectServer.State state, int serverType);
    }

    public class ConnectBinder extends Binder {
        public VhallConnectService getService() {
            return VhallConnectService.this;
        }
    }

    @Override
    public void onCreate() {
        super.onCreate();
        mBinder = new ConnectBinder();
        mDelivery = new Handler(this.getMainLooper());
        mMsgServer = new MessageServer();
        mMsgServer.setEventCallback(msgCallback);
        mChatServerV1 = new ChatServer();
        mChatServerV1.setEventCallback(chatCallback);
        mChatServerV2 = new ChatServerV2();
        mChatServerV2.setEventCallback(chatV2CallBack);
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public IBinder onBind(Intent intent) {
        init(intent);
        return mBinder;
    }

    @Override
    public void onRebind(Intent intent) {
        init(intent);
    }

    private void init(Intent intent) {
        mUserId = intent.getStringExtra("third_party_user_id");
        userInfoStr = intent.getStringExtra("userInfo");
        hide = intent.getBooleanExtra("hide", false);
        isInited = false;
        isFirstJoinChannel = false;
        disConnect();
        //new change
        //startProtect();
    }

    public CopyOnWriteArraySet<IVHService> getServices() {
        return services;
    }

    /**
     * 开启守护线程
     */
    private void startProtect() {
        stopProtect();
        mProTask = new ProtectTask();
        mTimer = new Timer(true);
        mTimer.schedule(mProTask, 0, PROTECT_MIL_SECONDS);
    }

    /**
     * 结束守护
     */
    private synchronized void stopProtect() {
        if (mProTask != null) {
            mProTask.cancel();
            mProTask = null;
        }
        if (mTimer != null) {
            mTimer.cancel();
            mTimer.purge();
            mTimer = null;
        }
    }

    class ProtectTask extends TimerTask {

        @Override
        public void run() {
            if (!isFirstJoinChannel) {
                attemptJoinChannelId(firstJoinChannelID, firstJoinAccessToken);
            } else {
                if (services.size() > 0 && checkConnect()) {
                    if (mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
                        connect2MsgServer();
                    }
                    if (mIsUsedChatV1 && mChatServerV1.getState() == ConnectServer.State.STATE_DISCONNECT) {
                        connect2ChatServer();
                    }
                    if (!mIsUsedChatV1 && mChatServerV2.getState() == ConnectServerV2.NetState.STATE_DISCONNECT) {
                        connect2ChatServer();
                    }
                }
            }
        }
    }

    /**
     * 修改为强制断开
     * hkl 8/31
     */
    private void disConnect() {
        if (mMsgServer != null)
            mMsgServer.disconnectForce();
        chatDisconnect();
    }

    /**
     * 重连表示连接地址不变，连接状态改变
     * 消息服务器
     */
    private void reConnect() {//用户信息改变仅需重连   by zwp 20200229
        if (mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
            joinAllChannel();
        } else {
            connect2MsgServer();
        }
        connect2ChatServer();
    }

    /**
     * 用户信息变更，重连msgServer产生上线消息
     * hkl 目前 没使用场景 8月30
     */
    @Deprecated
    private void reConnectForUpdaeUserInfo() {
        if (mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
            connect2MsgServer();
        } else {
            leaveAllChannelForInfoChange();
            joinAllChannel();
        }

    }


    /**
     * 第一个频join，需重新调用init 校验消息域名是否改变否则需要断开重连
     * by wxx 20200715
     */
    private void reConnectTestWhenFirstJoin() {
        isFirstJoinChannel = false;//重置初始化状态
        startProtect();
    }


    private void connect2MsgServer() {
        if (mMsgServer != null) {
            mMsgServer.disconnectForce();
        }
        if (!TextUtils.isEmpty(mMsgToken) && !TextUtils.isEmpty(mMsgServerURL)) {
            mMsgServer.setToken(mMsgToken);
            mMsgServer.connect(mMsgServerURL);
        }
    }

    private void connect2ChatServer() {
        if (mIsUsedChatV1 && mChatServerV1 != null) {
            mChatServerV1.connect(getChatURL());
        }
        if (!mIsUsedChatV1 && mChatServerV2 != null && mChatV2Config != null && mChatV2Config.group_list.size() > 0) {
            if (null != mDelivery) {
                mDelivery.removeCallbacks(mReconnectTXIM);
            }
            mChatServerV2.connect(mChatV2Config);
        }
    }

    /**
     * 切换用户
     *
     * @param userId
     */
    public void setUserId(String userId) {
        if (mUserId.equals(userId))
            return;
        /**
         * 先断开 在设置数据后重连
         * hkl
         */
        if (judgeMsg()) {
            leaveAllChannelForInfoChange();
            mUserId = userId;
            try {
                JSONObject userInfo = new JSONObject(userInfoStr);
                userInfo.put("third_party_user_id", mUserId);
                userInfoStr = userInfo.toString();
            } catch (JSONException e) {
                e.printStackTrace();
            }
            /**
             * 8月18号 没有服务链接 不重
             * hkl
             *
             * 9/7 3个接口都要重连
             */

            attemptUpdateUserId(firstJoinChannelID, firstJoinAccessToken);
        } else {
            mUserId = userId;
            try {
                JSONObject userInfo = new JSONObject(userInfoStr);
                userInfo.put("third_party_user_id", mUserId);
                userInfoStr = userInfo.toString();
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        /**
         * 用户id改变重新调用 init
         * hkl
         */
        isInited = false;
        if (!TextUtils.isEmpty(firstJoinAccessToken)) {
            isInited = true;
            attemptInit(firstJoinAccessToken);
        }
    }

    public void setHide(Boolean isHide) {
        if (hide == isHide) {
            return;
        }
        /**
         *hkl 先断开 在设置数据后重连 8/30
         */
        if (judgeMsg()) {
            leaveAllChannelForInfoChange();
            this.hide = isHide;
            /**
             * 8月18号 没有服务链接 不重连
             *
             * 调用接口
             */

            this.reConnect();
        } else {
            this.hide = isHide;
        }
    }

    /**
     * 外部判断 setUserInfo id 必定不同
     */
    public boolean setUserInfo(String jsonStr) {
        try {
            JSONObject obj = new JSONObject(jsonStr);
            String third_party_user_id = obj.optString("third_party_user_id");
            if (TextUtils.equals(third_party_user_id, this.mUserId)) {
                this.userInfoStr = jsonStr;
                /**
                 * hkl
                 * 新增 和ios逻辑一样
                 */
                if (judgeMsg()) {
                    joinAllChannel();
                }
                return true;
            }

            /**
             *hkl 先断开 在设置数据后重连 8/30
             */
            if (judgeMsg()) {
                leaveAllChannelForInfoChange();

                this.mUserId = third_party_user_id;
                this.userInfoStr = jsonStr;
                /**
                 * 8月18号 没有服务链接 不重连
                 */
                attemptUpdateUserId(firstJoinChannelID, firstJoinAccessToken);
            } else {
                this.mUserId = third_party_user_id;
                this.userInfoStr = jsonStr;
            }

            /**
             * 用户id改变重新调用 init
             */
            isInited = false;
            if (!TextUtils.isEmpty(firstJoinAccessToken)) {
                isInited = true;
                attemptInit(firstJoinAccessToken);
            }
            return true;
        } catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    /**
     * hkl 确认iOS没有这个逻辑 故 只替换 context 不做链接相关 8/30
     */
    public boolean updateUserInfo(String jsonStr) {
        this.userInfoStr = jsonStr;
        /**
         * 8月25号 用户id相等不重连 new change
         *
         * 9/7 新增 和ios逻辑一样
         */
        if (judgeMsg()) {
            joinAllChannel();
        }
        return true;
    }

    /**
     * 判断当前服务是否可用
     *
     * @return false 没链接不可用
     */
    private boolean judgeMsg() {
        if (mMsgServer == null || mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT || services.size() <= 0 || channels.size() <= 0) {
            return false;
        }
        return true;
    }

    //断线重连后，注入所有服务
    private void joinAllChannel() {
        if (channels.size() > 0) {
            for (String channel : channels) {
                try {
                    JSONObject obj = new JSONObject();
                    channel = getChannelIdWithComp(channel);
                    obj.put("channel", channel)
                            .put("third_party_user_id", this.mUserId)
                            .put("context", this.userInfoStr)
                            .put("hide", hide);
                    mMsgServer.join(obj);
                    makeMSGReport(LogReporter.LOG_REPORT_MSG_CONNECT, channel);
                    VLog.d(TAG, "emit:" + obj);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }


    /**
     * 用户信息变更时使用
     */
    private void leaveAllChannelForInfoChange() {
        if (channels.size() > 0) {
            for (String channel : channels) {
                try {
                    JSONObject obj = new JSONObject();
                    channel = getChannelIdWithComp(channel);
                    obj.put("channel", channel)
                            .put("third_party_user_id", this.mUserId)
                            .put("context", this.userInfoStr);
                    mMsgServer.leave(obj);
                    VLog.d(TAG, "service leave:" + channel);
                    makeMSGReport(LogReporter.LOG_REPORT_MSG_DISCONNECT, channel);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /**
     * 获取聊天服务器地址
     *
     * @return
     */
    private String getChatURL() {
        if (TextUtils.isEmpty(mChatServerURL) || channels.size() <= 0)
            return null;
        String id = "";
        if (channels.size() > 0) {
            for (String channnel : channels) {
                if (mCompChannels.size() > 0) {
                    String comp_channel = "comp_" + channnel;
                    if (mCompChannels.contains(comp_channel)) {
                        channnel = comp_channel;
                    }
                }
                id = id + "/" + channnel;
            }
        }
        String url = mChatServerURL + "/ws" + id + "?_=" + System.currentTimeMillis() + "&tag=0&time=&eventid=";
        return url;
    }

    /**
     * 解析消息压缩消息
     *
     * @param obj
     */
    private void paramMsgEncodeMessage(JSONObject obj) {
        try {
            boolean isEncodingText = true;
            String encoding = obj.optString("comp_alg");
            if (encoding.equals("n")) {
                isEncodingText = false;
            }
            if (obj.has("content")) {
                String content = obj.optString("content");
                String messageOriginalContent = content;
                if (isEncodingText) {
                    messageOriginalContent = new String(GzipUtil.unCompress(Base64.decode(content, Base64.DEFAULT)), "UTF-8");
                }
                JSONArray messages = new JSONArray(messageOriginalContent);
                for (int i = 0; i < messages.length(); i++) {
                    // 获取内部数组
                    JSONArray msgString = messages.getJSONArray(i);
                    if (msgString.length() >= 2) {
                        // 获取第一个元素（cmd）和第二个元素（内容）
                        String command = msgString.getString(0);
                        String jsonContentString = msgString.getString(1);
                        disPatchMsg(jsonContentString);
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return;
    }


    /**
     * 消息分发
     *
     * @param message
     */
    public void disPatchMsg(final String message) {
        if (TextUtils.isEmpty(message))
            return;
        try {
            JSONObject obj = new JSONObject(message);
            String id = getChannelIdWithOutComp(obj.optString("channel"));
            for (IVHService service : services) {
                if (TextUtils.isEmpty(id) || service.getChannelId().contains(id)) {
                    service.onMessage(message);
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /**
     * 加入服务
     *
     * @param service TODO 服务不同，渠道相同
     *                单有token的情况目前不存在
     *                回放id内部传递消息,直播不在监听消息,互动 文档 聊天第一次连接消息获取消息服务器地址用  如果已经在连接则不需要再调用
     */
    public synchronized void join(IVHService service) {
        if (service == null)
            return;
        if (TextUtils.isEmpty(service.getAccessToken()))
            return;
        else if (!requestInit) {
            requestInit = true;
            firstJoinAccessToken = service.getAccessToken();
            attemptInit(service, service.getAccessToken());
        } else {
            if (isBeautifyService(service) && null != mBeautifyInitListener) {
                if (null != mBeautifyConfig && mBeautifyConfig.optBoolean("enable")) {
                    mBeautifyInitListener.onSuccess();
                } else {
                    mBeautifyInitListener.onError(0, "beauty config is off");
                }
            } else if (isVHLssV2Service(service) && null != initCallback) {
                String url = VhallBaseSDK.getInstance().getLicenseUrl();
                String key = VhallBaseSDK.getInstance().getLicenseKey();
                if (url != null && key != null && !url.isEmpty() && !key.isEmpty()) {
                    initCallback.onSuccess();
                } else {
                    attemptInit(service, service.getAccessToken());
                }
            }
        }

        if (serviceNotReadyForMsg(service))
            return;
        if (services.add(service) && channels.add(service.getChannelId())) {
            //回放的只加入 不触发连接
            if (TextUtils.isEmpty(firstJoinChannelID) && (service.getChannelId().startsWith("ch_") || service.getChannelId().startsWith("inav_"))) {
                firstJoinChannelID = service.getChannelId();
                /**
                 * 同步更新 token
                 */
                firstJoinAccessToken = service.getAccessToken();
                /**
                 * 触发连接
                 */
                reConnectTestWhenFirstJoin();
                return;
            } else {
                if (mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
                    try {
                        Thread.sleep(500);
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            /**
             * 修改逻辑 第一个之后的服务加进来 如果第一个没有链接成功则等待（成功会吧当前等待的全部加入），如果链接成功 则直接加入
             * 8月19号
             */
            if (mMsgServer.getState() == ConnectServer.State.STATE_CONNECTED) {
                try {
                    String join_channel = service.getChannelId();
                    JSONObject object = new JSONObject();
                    if (mCompChannels.contains("comp_" + join_channel)) {
                        join_channel = "comp_" + join_channel;
                    }
                    object.put("channel", join_channel)
                            .put("third_party_user_id", mUserId)
                            .put("context", this.userInfoStr)
                            .put("hide", this.hide);
                    mMsgServer.join(object);
                    makeMSGReport(LogReporter.LOG_REPORT_MSG_CONNECT, service.getChannelId());
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            connect2ChatServer();
        }
    }

    private void makeMSGReport(String event, String channelId) {
        JSONObject pushConfig = new JSONObject();
        try {
            pushConfig.put("channel_id", channelId);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollectionWithBData(event, pushConfig);
    }

    private boolean serviceNotReadyForMsg(IVHService service) {
        return TextUtils.isEmpty(service.getChannelId()) || TextUtils.isEmpty(service.getAccessToken())
                || isBeautifyService(service) || isVHLssV2Service(service);
    }

    private boolean isBeautifyService(IVHService service) {
        return null != service && !TextUtils.isEmpty(service.getChannelId())
                && service.getChannelId().equals(BeautifyRegServiceImpl.CHANNEL_ID);
    }

    private boolean isVHLssV2Service(IVHService service) {
        return null != service && !TextUtils.isEmpty(service.getChannelId())
                && service.getChannelId().equals(VHV2PusherServiceImpl.CHANNEL_ID);
    }

    private String getChannelIdWithOutComp(String channel_id) {
        String new_channelId = channel_id;
        if (new_channelId.contains("comp_")) {
            new_channelId = new_channelId.replace("comp_", "");
        }
        return new_channelId;
    }

    private String getChannelIdWithComp(String channel_id) {
        String new_channelId = channel_id;
        if (mCompChannels.contains("comp_" + channel_id)) {
            new_channelId = "comp_" + channel_id;
        }
        return new_channelId;
    }

    private void chatDisconnect() {
        if (mIsUsedChatV1 && mChatServerV1 != null) {
            mChatServerV1.disconnect();
        }
        if (!mIsUsedChatV1 && mChatServerV2 != null) {
            if (null != mDelivery) {
                mDelivery.removeCallbacks(mReconnectTXIM);
            }
            mChatServerV2.disconnect();
        }
    }

    public synchronized void leave(IVHService service) {
        if (service == null)
            return;
        if (TextUtils.isEmpty(service.getChannelId()))
            return;
        if (services.remove(service)) {
            //判断其他服务中是否相同channelId,有则不离
            boolean check = false;
            for (IVHService server : services) {
                if (server.getChannelId().equals(service.getChannelId())) {
                    check = true;
                    break;
                }
            }
            if (!check) {//没有，则离开此频道
                if (channels.contains(service.getChannelId())) {
                    channels.remove(service.getChannelId());
                }

                if (mMsgServer.getState() == ConnectServer.State.STATE_DISCONNECT) {
                    connect2MsgServer();
                } else {
                    try {
                        JSONObject obj = new JSONObject();
                        String leave_channel = getChannelIdWithComp(service.getChannelId());
                        obj.put("channel", leave_channel)
                                .put("third_party_user_id", this.mUserId)
                                .put("context", this.userInfoStr);
                        mMsgServer.leave(obj);
                        if(!mIsUsedChatV1){
                            InternalUtils.randomInt(50,100);//保障leave消息发送成功。
                        }
                        VLog.d(TAG, "service leave:" + service.getChannelId());
                        makeMSGReport(LogReporter.LOG_REPORT_MSG_DISCONNECT, service.getChannelId());
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                chatDisconnect();
                if (mCompChannels.contains("comp_" + service.getChannelId())) {
                    mCompChannels.remove("comp_" + service.getChannelId());
                }
            }
            if (services.size() == 0) {
                firstJoinChannelID = "";
                firstJoinAccessToken = "";
                isFirstJoinChannel = false;
                mMsgToken = "";
                stopProtect();

                /**
                 * 2021 08/10 hkl 没有服务链接的时候 强制断开消息服务
                 */
                if (mMsgServer != null) {
                    mMsgServer.disconnectForce();
                }
                chatDisconnect();
                if (null != mDelivery) {
                    mDelivery.removeCallbacks(mInitSDKRunnable);
                    mDelivery.removeCallbacks(mJoinChannelIdRunnable);
                    mDelivery.removeCallbacks(mUpdateUserIdRunnable);
                    mDelivery.removeCallbacks(mReconnectTXIM);
                }
            }
        }
    }

    ConnectServer.EventCallback msgCallback = new ConnectServer.EventCallback() {
        @Override
        public void onStateChanged(ConnectServer.State state) {
            VLog.d(TAG, "onStateChanged: " + state.toString() + "   mMsgServerURL=     " + mMsgServer.getUrl());
            sendConnectEvent(state, SERVER_MSG);
            switch (state) {
                case STATE_DISCONNECT:
                    break;
                case STATE_CONNECTIONG:
                    break;
                case STATE_CONNECTED:
                    joinAllChannel();
                    break;
            }
        }

        @Override
        public void onMsg(String msg) {
            //解析压缩处理。分为：无压缩单条SIO通道原房间消息/无压缩单条数组式SIO通道新格式房间消息/压缩单条数组式SIO通道房间消息/压缩多条SIO通道房间消息
            if (TextUtils.isEmpty(msg))
                return;
            mDelivery.post(new Runnable() {
                @Override
                public void run() {
                    onProcessMsg(msg);
                }
            });
        }

        @Override
        public void onMsg(String event, String msg) {
            //deprecated method of imsv4
        }
    };

    private void paramJsonData(String msg) {
        try {
            JSONArray messages = new JSONArray(msg);
            for (int i = 0; i < messages.length(); i++) {
                // 获取内部数组
                Object o = messages.get(i);
                if (o instanceof String) {
                    disPatchMsg((String) o);
                } else if (o instanceof JSONObject) {
                    disPatchMsg(o.toString());
                } else if (o instanceof JSONArray) {
                    JSONArray msgString = ((JSONArray) o);
                    if (msgString.length() >= 2) {
                        // 获取第一个元素（cmd）和第二个元素（内容）
                        String command = msgString.getString(0);
                        String jsonContentString = msgString.getString(1);
                        disPatchMsg(jsonContentString);
                    }
                }
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void processJsonMessage(String msg){
        try{
            JSONObject obj = new JSONObject(msg);
            if (obj.has("text")) {
                JSONObject text = new JSONObject(URLDecoder.decode(obj.optString("text"), "UTF-8"));
                processEncodeData(text, msg);
            } else if (obj.has("comp_alg")) {
                processEncodeData(obj, msg);
            } else {
                disPatchMsg(msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void processJsonArray(String msg){
        try{
            JSONArray messages = new JSONArray(msg);
            if (messages.length() == 2) {
                // 获取第一个元素（msg）和第二个元素（内容）
                String command = messages.getString(0);
                String jsonContentString = messages.getString(1);
                processJsonMessage(jsonContentString);
            } else {
                paramJsonData(msg);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void onProcessMsg(String msg) {
        if (JsonUtil.isJsonObj(msg)) {
            processJsonMessage(msg);
        } else if (JsonUtil.isJsonArray(msg)) {
            processJsonArray(msg);
        } else {
            disPatchMsg(msg);
        }
    }

    private void processEncodeData(JSONObject text, String recMsg) {
        try {
            boolean isEncodingText = true;
            if (text.has("comp_alg")) {
                String encoding = text.optString("comp_alg");
                if (encoding.equals("n")) {
                    isEncodingText = false;
                }
                if (text.has("content")) {
                    String content = text.optString("content");
                    String message = content;
                    if (isEncodingText) {
                        message = new String(GzipUtil.unCompress(Base64.decode(content, Base64.DEFAULT)), "UTF-8");
                    }
                    paramJsonData(message);
                }
            } else {
                disPatchMsg(recMsg);
            }
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    private void receiveChatMsg(String msg) {
        //消息压缩处理分为:无压缩单条数组式Chat通道上线消息/压缩单条数组式Chat通道上线消息/压缩多条Chat通道新老上线消息
        if (TextUtils.isEmpty(msg))
            return;
        mDelivery.post(new Runnable() {
            @Override
            public void run() {
                onProcessMsg(msg);
            }
        });
    }

    ConnectServerV2.EventCallback chatV2CallBack = new ConnectServerV2.EventCallback() {
        @Override
        public void onStateChanged(ConnectServerV2.NetState state) {
            switch (state) {
                case STATE_CONNECTING:
                    sendConnectEvent(ConnectServer.State.STATE_CONNECTIONG, SERVER_CHAT);
                    break;
                case STATE_SIG_EXPIRED:
                    sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, SERVER_CHAT);
                    break;
                case STATE_CONNECTED: //真正连接成功，取加入群组成功回调. 底层加入群组成功后，上报网络重连成功。
                    sendConnectEvent(ConnectServer.State.STATE_CONNECTED, SERVER_CHAT);
                    break;
                case STATE_KICK_OFF:
                    sendConnectEvent(ConnectServer.State.STATE_KICK_OFF, SERVER_CHAT);
                    break;
                default:
                    break;
            }
        }

        @Override
        public void onMsg(String group_id, String msg) {
            receiveChatMsg(msg);
        }

        @Override
        public void onInit(String desc) {
            sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, SERVER_CHAT);
            mDelivery.postDelayed(mReconnectTXIM,SERVICE_RETRY_INTERVAL);
        }

        @Override
        public void onLoginState(ConnectServerV2.JoinState state, int code, String desc) {
            if (state == ConnectServerV2.JoinState.STATE_LOGIN_FAILED) {
                mDelivery.postDelayed(mReconnectTXIM,SERVICE_RETRY_INTERVAL);
                sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, SERVER_CHAT);
            }
        }

        @Override
        public void onGroupState(ConnectServerV2.JoinState state, String group_id, int code, String data) {
            if (state == ConnectServerV2.JoinState.STATE_JOIN_GROUP_FAILED) {
                mDelivery.postDelayed(mReconnectTXIM,SERVICE_RETRY_INTERVAL);
                sendConnectEvent(ConnectServer.State.STATE_DISCONNECT, SERVER_CHAT);
            } else if (state == ConnectServerV2.JoinState.STATE_JOIN_GROUP_SUCCESS) {
                sendConnectEvent(ConnectServer.State.STATE_CONNECTED, SERVER_CHAT);
            }
        }
    };


    ConnectServer.EventCallback chatCallback = new ConnectServer.EventCallback() {
        @Override
        public void onStateChanged(ConnectServer.State state) {
            sendConnectEvent(state, SERVER_CHAT);
        }

        @Override
        public void onMsg(String msg) {
            receiveChatMsg(msg);
        }

        @Override
        public void onMsg(String event, String msg) {
            //deprecated method of imsv4
        }
    };

    @Override
    public boolean onUnbind(Intent intent) {
        stopProtect();//先停状态保持线程
        disConnect();
        return super.onUnbind(intent);
    }

    @Override
    public void onDestroy() {
        initCallback = null;
        mBeautifyInitListener = null;
        disConnect();
        stopProtect();
        isInited = false;
        isFirstJoinChannel = false;
        if (mChatServerV2 != null) {
            mChatServerV2.destory();
        }
        super.onDestroy();
    }


    private boolean checkConnect() {
        ConnectivityManager manager = (ConnectivityManager) this.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo networkInfo = manager.getActiveNetworkInfo();
        if (networkInfo != null)
            return networkInfo.isAvailable();
        return false;
    }

    public void sendConnectEvent(final ConnectServer.State state, final int type) {
        if (services.size() == 0)
            return;
        mDelivery.post(new Runnable() {
            @Override
            public void run() {
                for (IVHService service : services) {
                    service.onConnectStateChanged(state, type);
                }
            }
        });
    }

    private void attemptInit(final String accessToken) {
        attemptInit(null, accessToken);
    }

    private IInitSDKRunnable mInitSDKRunnable = new IInitSDKRunnable();
    private IJoinChannelIdRunnable mJoinChannelIdRunnable = new IJoinChannelIdRunnable();
    private IUpdateUserIdRunnable mUpdateUserIdRunnable = new IUpdateUserIdRunnable();
    private IReconnectTXIm mReconnectTXIM = new IReconnectTXIm();


    private void attemptInit(final IVHService service, final String accessToken) {
        VHAPI.initSDK(accessToken, new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                /**
                 * hkl
                 * 离开房间 不链接 状态更新
                 * 链接断开不链接
                 */
                if (TextUtils.isEmpty(firstJoinAccessToken)) {
                    isInited = false;
                    return;
                }

                if (null != mDelivery) {
                    mDelivery.postDelayed(mInitSDKRunnable, SERVICE_RETRY_INTERVAL);
                }
            }

            @Override
            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    try {
                        dealResult(response.body().string(), EVENT_TYPE_INIT, service);
                    } catch (IOException e) {
                        e.printStackTrace();
                        isInited = false;
                    }
                } else {
                    isInited = false;
                }
            }
        });
    }

    private void attemptJoinChannelId(final String channelId, final String accessToken) {
        VHAPI.joinChannelId(channelId, accessToken, new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                /**
                 * hkl
                 * 离开房间 不链接 状态更新
                 */
                if (TextUtils.isEmpty(firstJoinAccessToken) || TextUtils.isEmpty(firstJoinChannelID)) {
                    isFirstJoinChannel = false;
                    return;
                }

                if (null != mDelivery) {
                    mDelivery.postDelayed(mJoinChannelIdRunnable, SERVICE_RETRY_INTERVAL);
                }
            }

            @Override
            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    try {
                        dealResult(response.body().string(), EVENT_TYPE_JOIN_CHANNEL_ID);
                    } catch (IOException e) {
                        e.printStackTrace();
                        isFirstJoinChannel = false;
                    }
                } else {
                    isFirstJoinChannel = false;
                }
            }
        });
    }

    private void attemptUpdateUserId(final String channelId, final String accessToken) {
        VHAPI.updateUserId(channelId, accessToken, new Callback() {
            @Override
            public void onFailure(Call call, IOException e) {
                /**
                 * hkl
                 * 离开房间 不链接
                 */
                if (TextUtils.isEmpty(firstJoinAccessToken) || TextUtils.isEmpty(firstJoinChannelID)) {
                    return;
                }

                if (null != mDelivery) {
                    mDelivery.postDelayed(mUpdateUserIdRunnable, SERVICE_RETRY_INTERVAL);
                }
            }

            @Override
            public void onResponse(Call call, Response response) {
                if (response.isSuccessful()) {
                    try {
                        dealResult(response.body().string(), EVENT_TYPE_UPDATE_USER_ID);
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private void dealResult(final String json, int type) {
        dealResult(json, type, null);
    }

    /**
     * hkl 8/30
     * 处理请求结果
     * 只有 channel的时候才增加日志上报
     * <p>
     * type 0 初始化 1 channel 加入 2 用户id重连
     */
    private void dealResult(final String json, int type, final IVHService service) {
        try {
            final JSONObject result = new JSONObject(json);
            final String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                final JSONObject data = result.optJSONObject("data");
                if (data != null) {
                    /**
                     * 2021 08/10 hkl 当前init接口channel为空 不赋值
                     *
                     * 2021 9/7 最新更改 不会出现 没有channel的情况 所以不判断
                     */

                    VhallBaseSDK.getInstance().mDocHost = data.optString("document_server");
                    VhallBaseSDK.getInstance().mLogHost = data.optString("log_server");
                    JSONObject obj = data.optJSONObject("document_config");
                    if (obj != null) {
                        VhallBaseSDK.getInstance().documentExt = obj.optJSONArray("ext").toString();
                        VhallBaseSDK.getInstance().documentMaxSize = obj.optInt("maxSize");
                    }
                    getLogInfo(data.optJSONObject("log_info"));

                    final JSONObject beautyConfig = data.optJSONObject("beauty_config");
                    mBeautifyConfig = beautyConfig;
                    VHBeautifyKit.getInstance().setEnableConfig(beautyConfig);
                    if (isBeautifyService(service)) {
                        if (null != beautyConfig && beautyConfig.optBoolean("enable")) {
                            VHBeautifyKit.getInstance().init(getApplication(), mBeautifyInitListener);
                        } else {
                            if (null != mBeautifyInitListener) {
                                mBeautifyInitListener.onError(-1, "beauty config is off");
                            }
                        }
                    }

                    if (data.has("push_stream_license")) {
                        try {
                            final JSONObject push_stream_license = data.optJSONObject("push_stream_license");
                            if (push_stream_license.has("license_url")) {
                                VhallBaseSDK.getInstance().mLicenseUrl = push_stream_license.optString("license_url");
                            }
                            if (push_stream_license.has("license_key")) {
                                VhallBaseSDK.getInstance().mLicenseKey = push_stream_license.optString("license_key");
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    if (type != EVENT_TYPE_INIT) {
                        mMsgServerURL = data.getString("socket_server");
                        mMsgToken = data.getString("connection_token");
                        mChatServerURL = data.getString("nginx_server");
                        if (data.has("comp_channel_id")) {
                            String comp_channel_id = data.getString("comp_channel_id");
                            mCompChannels.add(comp_channel_id);
                        }
                        if (type == EVENT_TYPE_JOIN_CHANNEL_ID) {
                            mIsUsedChatV1 = true;
                            if (data.has("extra_connection_info")) {
                                JSONObject extra_info = data.optJSONObject("extra_connection_info");
                                mChatV2Config.context = getBaseContext();
                                if (extra_info.has("tim_connection_info")) {
                                    JSONObject tim_info = extra_info.optJSONObject("tim_connection_info");
                                    mChatV2Config.sdk_app_id = tim_info.getString("sdk_app_id");
                                    mChatV2Config.user_id = tim_info.getString("user_id");
                                    mChatV2Config.user_sig = tim_info.getString("user_sig");
                                    mChatV2Config.group_list.clear();
                                    JSONArray groups = tim_info.optJSONArray("group_list");
                                    if (groups != null && groups.length() > 0) {
                                        for (int i = 0; i < groups.length(); i++) {
                                            JSONObject group = groups.getJSONObject(i);
                                            mChatV2Config.group_list.put(group.optString("group_id"), group.optString("group_type"));
                                            mIsUsedChatV1 = false;
                                        }
                                    }
                                }
                            }
                            trackInitEvent();
                            isFirstJoinChannel = true;
                            connect2ChatServer();
                            /**
                             * 重连消息后会自动加入渠道
                             */
                            startProtect();
                        } else if (type == EVENT_TYPE_UPDATE_USER_ID) {
                            reConnect();
                        }
                    } else {
                        isInited = true;
                    }
                    VLog.d(TAG, "SDK消息初始化完成！");
                    if (initCallback != null) {
                        initCallback.onSuccess();
                    }
                    return;
                }
            }
            VLog.e(TAG, "初始化消息失败:" + msg);
            if (isBeautifyService(service) && null != mBeautifyInitListener) {
                mBeautifyInitListener.onError(-2, msg);
            }
            if (initCallback != null) {
                initCallback.onFailure(msg);
            }
            if (type == EVENT_TYPE_INIT) {
                isInited = false;
            } else if (type == EVENT_TYPE_JOIN_CHANNEL_ID) {
                isFirstJoinChannel = false;
                trackInitEvent(code + ":" + msg);
            }
        } catch (Exception e) {
            if (initCallback != null) {
                initCallback.onFailure(e.getMessage());
            }
            VLog.e(TAG, "初始化消息失败:" + e.getMessage());
            if (type == EVENT_TYPE_INIT) {
                isInited = false;
            } else if (type == EVENT_TYPE_JOIN_CHANNEL_ID) {
                isFirstJoinChannel = false;
                trackInitEvent(LogReporter.LOG_ERROR_EXCEPTION);
            }
            e.printStackTrace();
        }
    }

    //初始化打点
    private void trackInitEvent(String error) {
        LogReporter.getInstance().setErr(error);
        JSONObject params = new JSONObject();
        try {
            params.put("firstChannelId", firstJoinChannelID);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITSDK, false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("firstChannelId", firstJoinChannelID);
        } catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection(LogReporter.LOG_EVENT_INITSDK, params);
    }

    public boolean isInited() {
        return isInited;
    }

    private void getLogInfo(JSONObject log) {
        LogInfo logInfo = LogInfo.getInstance();
        if (log != null) {
            logInfo.initStaticData(VhallBaseSDK.getInstance().getAPP_ID(),
                    VhallBaseSDK.getInstance().mIMEI, VhallBaseSDK.getInstance().mLogHost
                    , LogInfo.PLANTFORM_SDK, LogInfo.UNIT_PAAS);
            logInfo.initBaseData(log);
        }
    }

    public void setInitCallback(VhallBaseSDK.InitCallback callback) {
        this.initCallback = callback;
    }

    public void setBeautifyInitCallback(IVHBeautifyInitListener beautifyInitListener) {
        mBeautifyInitListener = beautifyInitListener;
    }

    private class IInitSDKRunnable implements Runnable {

        @Override
        public void run() {
            /**
             * 用当前的 firstJoinAccessToken 重新请求
             * 判断网络 如果网络连接正常 重连
             *hkl
             */
            if (checkConnect()) {
                attemptInit(firstJoinAccessToken);
            }
        }
    }

    private class IJoinChannelIdRunnable implements Runnable {

        @Override
        public void run() {
            if (checkConnect()) {
                attemptJoinChannelId(firstJoinChannelID, firstJoinAccessToken);
            }
        }
    }

    private class IUpdateUserIdRunnable implements Runnable {

        @Override
        public void run() {
            if (checkConnect()) {
                attemptUpdateUserId(firstJoinChannelID, firstJoinAccessToken);
            }
        }
    }

    private class IReconnectTXIm implements Runnable {
        @Override
        public void run() {
            mChatServerV2.connect(mChatV2Config);
        }
    }
}