/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.PopupWindow;
import com.vhall.beautifykit.R;
import java.util.Arrays;

public class FaceMaskView
extends View {
    public static final int MAX_FACE = 4;
    private float[] left = new float[4];
    private float[] right = new float[4];
    private float[] top = new float[4];
    private float[] bottom = new float[4];
    private Paint mFacePaint;
    private Paint mBgPaint;
    private Paint mDotLinePaint;
    private Paint mSelectedFacePaint;
    private int mCurrentFace;
    private RectF mFaceRectF;
    private int mSelectedFace = -1;
    private OnFaceSelectedListener mOnFaceSelectedListener;
    private PopupWindow mPopupWindow;
    private boolean mShowPopup = true;

    public FaceMaskView(Context context) {
        super(context);
        this.init();
    }

    public FaceMaskView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public FaceMaskView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setLayerType(1, null);
        this.mFacePaint = new Paint(1);
        int paintWidth = this.getResources().getDimensionPixelSize(R.dimen.x8);
        this.mFacePaint.setStrokeWidth((float)paintWidth);
        this.mFacePaint.setStyle(Paint.Style.FILL);
        this.mFacePaint.setColor(0);
        this.mFacePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_OUT));
        this.mBgPaint = new Paint(1);
        this.mBgPaint.setColor(Color.parseColor((String)"#B3000000"));
        this.mBgPaint.setStyle(Paint.Style.FILL);
        this.mDotLinePaint = new Paint(1);
        this.mDotLinePaint.setColor(Color.parseColor((String)"#B3FFFFFF"));
        this.mDotLinePaint.setStyle(Paint.Style.STROKE);
        int dotLineWidth = this.getResources().getDimensionPixelSize(R.dimen.x3);
        this.mDotLinePaint.setStrokeWidth((float)dotLineWidth);
        int rectDotLineGap1 = this.getResources().getDimensionPixelSize(R.dimen.x8);
        int rectDotLineGap2 = this.getResources().getDimensionPixelSize(R.dimen.x4);
        DashPathEffect peDotLine = new DashPathEffect(new float[]{rectDotLineGap1, rectDotLineGap2}, 0.0f);
        this.mDotLinePaint.setPathEffect((PathEffect)peDotLine);
        this.mSelectedFacePaint = new Paint(this.mDotLinePaint);
        this.mSelectedFacePaint.setPathEffect(null);
        int shaRadius = this.getResources().getDimensionPixelSize(R.dimen.x4);
        this.mSelectedFacePaint.setShadowLayer((float)shaRadius, 0.0f, 0.0f, Color.parseColor((String)"#27A5F4"));
        this.mFaceRectF = new RectF();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mBgPaint);
        for (int i = 0; i < this.mCurrentFace; ++i) {
            this.mFaceRectF.set(this.left[i], this.top[i], this.right[i], this.bottom[i]);
            canvas.drawOval(this.mFaceRectF, this.mFacePaint);
            if (this.mSelectedFace == i) {
                canvas.drawOval(this.mFaceRectF, this.mSelectedFacePaint);
                continue;
            }
            canvas.drawOval(this.mFaceRectF, this.mDotLinePaint);
        }
        if (this.mShowPopup) {
            this.showPopupWindow();
            this.mShowPopup = false;
        }
    }

    public void clean() {
        this.mCurrentFace = 0;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.dismissPopWindow();
        float x = event.getX();
        float y = event.getY();
        int action = event.getAction();
        if (action == 0 || action == 2) {
            return true;
        }
        if (action == 1) {
            for (int i = 0; i < this.mCurrentFace; ++i) {
                if (!(x >= this.left[i]) || !(x <= this.right[i]) || !(y >= this.top[i]) || !(y <= this.bottom[i])) continue;
                this.mSelectedFace = i;
                this.invalidate();
                if (this.mOnFaceSelectedListener != null) {
                    this.mOnFaceSelectedListener.onFaceSelected(this, this.mSelectedFace);
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private void showPopupWindow() {
        int width = this.getResources().getDimensionPixelSize(R.dimen.x456);
        int height = this.getResources().getDimensionPixelSize(R.dimen.x76);
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.popup_dual_face, null);
        this.mPopupWindow = new PopupWindow(view, width, height, true);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mPopupWindow.setOutsideTouchable(false);
        this.mPopupWindow.setTouchable(false);
        this.mPopupWindow.setAnimationStyle(R.style.photo_tip_popup_anim_style);
        float maxBottom = this.findMaxBottom();
        int yOffset = (int)(maxBottom - (float)(this.getHeight() / 2)) + this.getResources().getDimensionPixelSize(R.dimen.x8);
        this.mPopupWindow.showAtLocation((View)this, 1, 0, yOffset);
    }

    private float findMaxBottom() {
        float[] bo = Arrays.copyOf(this.bottom, this.bottom.length);
        Arrays.sort(bo);
        return bo[bo.length - 1];
    }

    public void addFaceRect(float[] faceRect) {
        this.left[this.mCurrentFace] = Math.min(faceRect[0], faceRect[2]);
        this.top[this.mCurrentFace] = Math.min(faceRect[1], faceRect[3]);
        this.right[this.mCurrentFace] = Math.max(faceRect[0], faceRect[2]);
        this.bottom[this.mCurrentFace] = Math.max(faceRect[1], faceRect[3]);
        ++this.mCurrentFace;
    }

    public void setShowPopup(boolean showPopup) {
        this.mShowPopup = showPopup;
    }

    public void dismissPopWindow() {
        if (this.mPopupWindow != null && this.mPopupWindow.isShowing()) {
            this.mPopupWindow.dismiss();
        }
    }

    public void setOnFaceSelectedListener(OnFaceSelectedListener onFaceSelectedListener) {
        this.mOnFaceSelectedListener = onFaceSelectedListener;
    }

    public static interface OnFaceSelectedListener {
        public void onFaceSelected(View var1, int var2);
    }
}

