/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.seekbar.internal.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import com.vhall.beautifykit.seekbar.internal.drawable.StateDrawable;

public class MarkerDrawable
extends StateDrawable
implements Animatable {
    private static final long FRAME_DURATION = 16L;
    private static final int ANIMATION_DURATION = 250;
    private float mCurrentScale = 0.0f;
    private Interpolator mInterpolator;
    private long mStartTime;
    private boolean mReverse = false;
    private boolean mRunning = false;
    private int mDuration = 250;
    private float mClosedStateSize;
    private float mAnimationInitialValue;
    private int mExternalOffset;
    private int mStartColor;
    private int mEndColor;
    Path mPath = new Path();
    RectF mRect = new RectF();
    Matrix mMatrix = new Matrix();
    private MarkerAnimationListener mMarkerListener;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            long currentTime = SystemClock.uptimeMillis();
            long diff = currentTime - MarkerDrawable.this.mStartTime;
            if (diff < (long)MarkerDrawable.this.mDuration) {
                float interpolation = MarkerDrawable.this.mInterpolator.getInterpolation((float)diff / (float)MarkerDrawable.this.mDuration);
                MarkerDrawable.this.scheduleSelf(MarkerDrawable.this.mUpdater, currentTime + 16L);
                MarkerDrawable.this.updateAnimation(interpolation);
            } else {
                MarkerDrawable.this.unscheduleSelf(MarkerDrawable.this.mUpdater);
                MarkerDrawable.this.mRunning = false;
                MarkerDrawable.this.updateAnimation(1.0f);
                MarkerDrawable.this.notifyFinishedToListener();
            }
        }
    };

    public MarkerDrawable(@NonNull ColorStateList tintList, int closedSize) {
        super(tintList);
        this.mInterpolator = new AccelerateDecelerateInterpolator();
        this.mClosedStateSize = closedSize;
        this.mStartColor = tintList.getColorForState(new int[]{16842910, 16842919}, tintList.getDefaultColor());
        this.mEndColor = tintList.getDefaultColor();
    }

    public void setExternalOffset(int offset) {
        this.mExternalOffset = offset;
    }

    public void setColors(int startColor, int endColor) {
        this.mStartColor = startColor;
        this.mEndColor = endColor;
    }

    @Override
    void doDraw(Canvas canvas, Paint paint) {
        if (!this.mPath.isEmpty()) {
            paint.setStyle(Paint.Style.FILL);
            int color2 = MarkerDrawable.blendColors(this.mStartColor, this.mEndColor, this.mCurrentScale);
            paint.setColor(color2);
            canvas.drawPath(this.mPath, paint);
        }
    }

    public Path getPath() {
        return this.mPath;
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.computePath(bounds);
    }

    private void computePath(Rect bounds) {
        float currentScale = this.mCurrentScale;
        Path path = this.mPath;
        RectF rect = this.mRect;
        Matrix matrix = this.mMatrix;
        path.reset();
        int totalSize = Math.min(bounds.width(), bounds.height());
        float initial = this.mClosedStateSize;
        float destination = totalSize;
        float currentSize = initial + (destination - initial) * currentScale;
        float halfSize = currentSize / 2.0f;
        float inverseScale = 1.0f - currentScale;
        float cornerSize = halfSize * inverseScale;
        float[] corners = new float[]{halfSize, halfSize, halfSize, halfSize, halfSize, halfSize, cornerSize, cornerSize};
        rect.set((float)bounds.left, (float)bounds.top, (float)bounds.left + currentSize, (float)bounds.top + currentSize);
        path.addRoundRect(rect, corners, Path.Direction.CCW);
        matrix.reset();
        matrix.postRotate(-45.0f, (float)bounds.left + halfSize, (float)bounds.top + halfSize);
        matrix.postTranslate(((float)bounds.width() - currentSize) / 2.0f, 0.0f);
        float hDiff = ((float)bounds.bottom - currentSize - (float)this.mExternalOffset) * inverseScale;
        matrix.postTranslate(0.0f, hDiff);
        path.transform(matrix);
    }

    private void updateAnimation(float factor) {
        float initial = this.mAnimationInitialValue;
        float destination = this.mReverse ? 0.0f : 1.0f;
        this.mCurrentScale = initial + (destination - initial) * factor;
        this.computePath(this.getBounds());
        this.invalidateSelf();
    }

    public void animateToPressed() {
        this.unscheduleSelf(this.mUpdater);
        this.mReverse = false;
        if (this.mCurrentScale < 1.0f) {
            this.mRunning = true;
            this.mAnimationInitialValue = this.mCurrentScale;
            float durationFactor = 1.0f - this.mCurrentScale;
            this.mDuration = (int)(250.0f * durationFactor);
            this.mStartTime = SystemClock.uptimeMillis();
            this.scheduleSelf(this.mUpdater, this.mStartTime + 16L);
        } else {
            this.notifyFinishedToListener();
        }
    }

    public void animateToNormal() {
        this.mReverse = true;
        this.unscheduleSelf(this.mUpdater);
        if (this.mCurrentScale > 0.0f) {
            this.mRunning = true;
            this.mAnimationInitialValue = this.mCurrentScale;
            float durationFactor = 1.0f - this.mCurrentScale;
            this.mDuration = 250 - (int)(250.0f * durationFactor);
            this.mStartTime = SystemClock.uptimeMillis();
            this.scheduleSelf(this.mUpdater, this.mStartTime + 16L);
        } else {
            this.notifyFinishedToListener();
        }
    }

    public void setMarkerListener(MarkerAnimationListener listener) {
        this.mMarkerListener = listener;
    }

    private void notifyFinishedToListener() {
        if (this.mMarkerListener != null) {
            if (this.mReverse) {
                this.mMarkerListener.onClosingComplete();
            } else {
                this.mMarkerListener.onOpeningComplete();
            }
        }
    }

    public void start() {
    }

    public void stop() {
        this.unscheduleSelf(this.mUpdater);
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    private static int blendColors(int color1, int color2, float factor) {
        float inverseFactor = 1.0f - factor;
        float a = (float)Color.alpha((int)color1) * factor + (float)Color.alpha((int)color2) * inverseFactor;
        float r = (float)Color.red((int)color1) * factor + (float)Color.red((int)color2) * inverseFactor;
        float g = (float)Color.green((int)color1) * factor + (float)Color.green((int)color2) * inverseFactor;
        float b = (float)Color.blue((int)color1) * factor + (float)Color.blue((int)color2) * inverseFactor;
        return Color.argb((int)((int)a), (int)((int)r), (int)((int)g), (int)((int)b));
    }

    public static interface MarkerAnimationListener {
        public void onClosingComplete();

        public void onOpeningComplete();
    }
}

