/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.radio;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.support.v7.widget.AppCompatRadioButton;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.vhall.beautifykit.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0007H\u0014J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/vhall/beautifykit/radio/XfermodeRadioButton;", "Landroid/support/v7/widget/AppCompatRadioButton;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "baseLineY", "mMyRadioButtonPaint", "Landroid/graphics/Paint;", "textColorXfermodeChecked", "textColorXfermodeNormal", "textSizeXfermode", "textXfermode", "", "textXfermodeWidth", "onDraw", "", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setChecked", "checked", "", "vhall-beautify-kit_release"})
public final class XfermodeRadioButton
extends AppCompatRadioButton {
    private final String textXfermode;
    private final int textSizeXfermode;
    private final int textColorXfermodeNormal = -1;
    private final int textColorXfermodeChecked = -1727721708;
    private int textXfermodeWidth;
    private int baseLineY;
    private final Paint mMyRadioButtonPaint;
    private HashMap _$_findViewCache;

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        Paint paint = this.mMyRadioButtonPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        this.textXfermodeWidth = (int)paint.measureText(this.textXfermode);
        Paint.FontMetrics fontMetrics = this.mMyRadioButtonPaint.getFontMetrics();
        float top = fontMetrics.top;
        float bottom = fontMetrics.bottom;
        this.baseLineY = (int)((float)this.getMeasuredHeight() - top - bottom) / 2;
        this.setMeasuredDimension(this.getMeasuredWidth(), this.getMeasuredHeight());
    }

    public void setChecked(boolean checked) {
        super.setChecked(checked);
        if (this.mMyRadioButtonPaint != null) {
            this.mMyRadioButtonPaint.setColor(checked ? this.textColorXfermodeChecked : this.textColorXfermodeNormal);
            this.mMyRadioButtonPaint.setXfermode((Xfermode)new PorterDuffXfermode(checked ? PorterDuff.Mode.SRC_ATOP : PorterDuff.Mode.XOR));
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        int x = (this.getMeasuredWidth() - this.textXfermodeWidth) / 2;
        String string2 = this.textXfermode;
        if (string2 == null) {
            Intrinsics.throwNpe();
        }
        float f = x;
        float f2 = this.baseLineY;
        Paint paint = this.mMyRadioButtonPaint;
        if (paint == null) {
            Intrinsics.throwNpe();
        }
        canvas.drawText(string2, f, f2, paint);
    }

    @JvmOverloads
    public XfermodeRadioButton(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.textColorXfermodeNormal = -1;
        this.textColorXfermodeChecked = -1727721708;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.xfermode_radio_btn, defStyleAttr, 0);
        this.textXfermode = typedArray.getString(R.styleable.xfermode_radio_btn_text_xfermode);
        Resources resources = context.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
        this.textSizeXfermode = typedArray.getDimensionPixelSize(R.styleable.xfermode_radio_btn_text_size_xfermode, (int)TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)resources.getDisplayMetrics()));
        typedArray.recycle();
        this.mMyRadioButtonPaint = new Paint();
        this.mMyRadioButtonPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.XOR));
        this.mMyRadioButtonPaint.setColor(this.textColorXfermodeNormal);
        this.mMyRadioButtonPaint.setTextSize((float)this.textSizeXfermode);
        this.mMyRadioButtonPaint.setAntiAlias(true);
        this.setButtonDrawable((Drawable)new StateListDrawable());
    }

    public /* synthetic */ XfermodeRadioButton(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.radioButtonStyle;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public XfermodeRadioButton(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public XfermodeRadioButton(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

