/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.dialog;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.dialog.BaseDialogFragment;
import com.vhall.beautifykit.listener.OnMultiClickListener;

public class PromptDialogFragment
extends BaseDialogFragment {
    private static final String MESSAGE = "message";
    private Context mContext;

    public static PromptDialogFragment newInstance(Context context, @StringRes int res) {
        return PromptDialogFragment.newInstance(context, context.getResources().getString(res));
    }

    public static PromptDialogFragment newInstance(Context context, String message) {
        PromptDialogFragment fragment = new PromptDialogFragment();
        fragment.mContext = context;
        Bundle args = new Bundle();
        args.putString(MESSAGE, message);
        fragment.setArguments(args);
        return fragment;
    }

    @Override
    protected View createDialogView(LayoutInflater inflater, @Nullable ViewGroup container) {
        View view = inflater.inflate(R.layout.dialog_prompt, container, false);
        TextView tvPrompt = (TextView)view.findViewById(R.id.tv_content);
        String message = this.getArguments().getString(MESSAGE);
        if (!TextUtils.isEmpty((CharSequence)message)) {
            tvPrompt.setText((CharSequence)message);
        }
        view.findViewById(R.id.tv_confirm).setOnClickListener((View.OnClickListener)new OnMultiClickListener(){

            @Override
            protected void onMultiClick(View v) {
                PromptDialogFragment.this.dismiss();
            }
        });
        return view;
    }

    @Override
    protected int getDialogWidth() {
        return this.getResources().getDimensionPixelSize(R.dimen.x560);
    }

    @Override
    protected int getDialogHeight() {
        return this.getResources().getDimensionPixelSize(R.dimen.x274);
    }
}

