/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.dialog;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.dialog.BaseDialogFragment;

public class ConfirmDialogFragment
extends BaseDialogFragment {
    private static final String TITLE = "content";
    private static final String CONFIRM = "confirm";
    private static final String CANCEL = "cancel";
    private BaseDialogFragment.OnClickListener mOnClickListener;

    public static ConfirmDialogFragment newInstance(@NonNull String title, @NonNull BaseDialogFragment.OnClickListener onClickListener) {
        ConfirmDialogFragment fragment = new ConfirmDialogFragment();
        fragment.mOnClickListener = onClickListener;
        Bundle bundle = new Bundle();
        bundle.putString(TITLE, title);
        fragment.setArguments(bundle);
        return fragment;
    }

    public static ConfirmDialogFragment newInstance(@NonNull String title, @NonNull String confirmText, @NonNull String cancelText, @NonNull BaseDialogFragment.OnClickListener onClickListener) {
        ConfirmDialogFragment fragment = new ConfirmDialogFragment();
        fragment.mOnClickListener = onClickListener;
        Bundle bundle = new Bundle();
        bundle.putString(TITLE, title);
        bundle.putString(CONFIRM, confirmText);
        bundle.putString(CANCEL, cancelText);
        fragment.setArguments(bundle);
        return fragment;
    }

    @Override
    protected View createDialogView(LayoutInflater inflater, @Nullable ViewGroup container) {
        View view = inflater.inflate(R.layout.dialog_confirm, container, false);
        View.OnClickListener onClickListener = new View.OnClickListener(){

            public void onClick(View v) {
                ConfirmDialogFragment.this.dismiss();
                int id2 = v.getId();
                if (id2 == R.id.tv_confirm) {
                    if (ConfirmDialogFragment.this.mOnClickListener != null) {
                        ConfirmDialogFragment.this.mOnClickListener.onConfirm();
                    }
                } else if (id2 == R.id.tv_cancel && ConfirmDialogFragment.this.mOnClickListener != null) {
                    ConfirmDialogFragment.this.mOnClickListener.onCancel();
                }
            }
        };
        String confirmTxt = this.getArguments().getString(CONFIRM);
        TextView tvConfirm = (TextView)view.findViewById(R.id.tv_confirm);
        if (!TextUtils.isEmpty((CharSequence)confirmTxt)) {
            tvConfirm.setText((CharSequence)confirmTxt);
        }
        String cancelTxt = this.getArguments().getString(CANCEL);
        TextView tvCancel = (TextView)view.findViewById(R.id.tv_cancel);
        if (!TextUtils.isEmpty((CharSequence)cancelTxt)) {
            tvCancel.setText((CharSequence)cancelTxt);
        }
        tvConfirm.setOnClickListener(onClickListener);
        tvCancel.setOnClickListener(onClickListener);
        String title = this.getArguments().getString(TITLE);
        ((TextView)view.findViewById(R.id.tv_content)).setText((CharSequence)title);
        return view;
    }

    @Override
    protected int getDialogWidth() {
        return this.getResources().getDimensionPixelSize(R.dimen.dimen_310dp);
    }

    @Override
    protected int getDialogHeight() {
        return this.getResources().getDimensionPixelSize(R.dimen.dimen_147dp);
    }

    public void setOnClickListener(BaseDialogFragment.OnClickListener onClickListener) {
        this.mOnClickListener = onClickListener;
    }
}

