/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.seekbar.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.seekbar.internal.compat.SeekBarCompat;
import com.vhall.beautifykit.seekbar.internal.drawable.MarkerDrawable;

public class Marker
extends ViewGroup
implements MarkerDrawable.MarkerAnimationListener {
    private static final int PADDING_DP = 1;
    private static final int ELEVATION_DP = 8;
    private TextView mNumber;
    private int mWidth;
    private int mSeparation;
    MarkerDrawable mMarkerDrawable;

    public Marker(Context context, AttributeSet attrs, int defStyleAttr, String maxValue, int thumbSize, int separation) {
        super(context, attrs, defStyleAttr);
        this.setVisibility(0);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DiscreteSeekBar, R.attr.discreteSeekBarStyle, R.style.Widget_DiscreteSeekBar);
        int padding = (int)(1.0f * displayMetrics.density) * 2;
        int textAppearanceId = a.getResourceId(R.styleable.DiscreteSeekBar_dsb_indicatorTextAppearance, R.style.Widget_DiscreteIndicatorTextAppearance);
        this.mNumber = new TextView(context);
        this.mNumber.setPadding(padding, 0, padding, 0);
        this.mNumber.setTextAppearance(context, textAppearanceId);
        this.mNumber.setGravity(17);
        this.mNumber.setText((CharSequence)maxValue);
        this.mNumber.setMaxLines(1);
        this.mNumber.setSingleLine(true);
        SeekBarCompat.setTextDirection(this.mNumber, 5);
        this.mNumber.setVisibility(4);
        this.setPadding(padding, padding, padding, padding);
        this.resetSizes(maxValue);
        this.mSeparation = separation;
        ColorStateList color2 = a.getColorStateList(R.styleable.DiscreteSeekBar_dsb_indicatorColor);
        this.mMarkerDrawable = new MarkerDrawable(color2, thumbSize);
        this.mMarkerDrawable.setCallback((Drawable.Callback)this);
        this.mMarkerDrawable.setMarkerListener(this);
        this.mMarkerDrawable.setExternalOffset(padding);
        float elevation = a.getDimension(R.styleable.DiscreteSeekBar_dsb_indicatorElevation, 8.0f * displayMetrics.density);
        ViewCompat.setElevation((View)this, (float)elevation);
        if (Build.VERSION.SDK_INT >= 21) {
            SeekBarCompat.setOutlineProvider((View)this, this.mMarkerDrawable);
        }
        a.recycle();
    }

    public void resetSizes(String maxValue) {
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        this.mNumber.setText((CharSequence)("-" + maxValue));
        int wSpec = View.MeasureSpec.makeMeasureSpec((int)displayMetrics.widthPixels, (int)Integer.MIN_VALUE);
        int hSpec = View.MeasureSpec.makeMeasureSpec((int)displayMetrics.heightPixels, (int)Integer.MIN_VALUE);
        this.mNumber.measure(wSpec, hSpec);
        this.mWidth = Math.max(this.mNumber.getMeasuredWidth(), this.mNumber.getMeasuredHeight());
        this.removeView((View)this.mNumber);
        this.addView((View)this.mNumber, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(this.mWidth, this.mWidth, 51));
    }

    protected void dispatchDraw(Canvas canvas) {
        this.mMarkerDrawable.draw(canvas);
        super.dispatchDraw(canvas);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        int widthSize = this.mWidth + this.getPaddingLeft() + this.getPaddingRight();
        int heightSize = this.mWidth + this.getPaddingTop() + this.getPaddingBottom();
        int diff = (int)(1.41f * (float)this.mWidth - (float)this.mWidth) / 2;
        this.setMeasuredDimension(widthSize, heightSize + diff + this.mSeparation);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int right = this.getWidth() - this.getPaddingRight();
        int bottom = this.getHeight() - this.getPaddingBottom();
        this.mNumber.layout(left, top, left + this.mWidth, top + this.mWidth);
        this.mMarkerDrawable.setBounds(left, top, right, bottom);
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mMarkerDrawable || super.verifyDrawable(who);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.animateOpen();
    }

    public void setValue(CharSequence value) {
        this.mNumber.setText(value);
    }

    public CharSequence getValue() {
        return this.mNumber.getText();
    }

    public void animateOpen() {
        this.mMarkerDrawable.stop();
        this.mMarkerDrawable.animateToPressed();
    }

    public void animateClose() {
        this.mMarkerDrawable.stop();
        this.mNumber.setVisibility(4);
        this.mMarkerDrawable.animateToNormal();
    }

    @Override
    public void onOpeningComplete() {
        this.mNumber.setVisibility(0);
        if (this.getParent() instanceof MarkerDrawable.MarkerAnimationListener) {
            ((MarkerDrawable.MarkerAnimationListener)this.getParent()).onOpeningComplete();
        }
    }

    @Override
    public void onClosingComplete() {
        if (this.getParent() instanceof MarkerDrawable.MarkerAnimationListener) {
            ((MarkerDrawable.MarkerAnimationListener)this.getParent()).onClosingComplete();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mMarkerDrawable.stop();
    }

    public void setColors(int startColor, int endColor) {
        this.mMarkerDrawable.setColors(startColor, endColor);
    }
}

