/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.beautifykit.seekbar;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewParent;
import com.vhall.beautifykit.R;
import com.vhall.beautifykit.seekbar.internal.PopupIndicator;
import com.vhall.beautifykit.seekbar.internal.compat.AnimatorCompat;
import com.vhall.beautifykit.seekbar.internal.compat.SeekBarCompat;
import com.vhall.beautifykit.seekbar.internal.drawable.MarkerDrawable;
import com.vhall.beautifykit.seekbar.internal.drawable.ThumbDrawable;
import com.vhall.beautifykit.seekbar.internal.drawable.TrackRectDrawable;
import java.util.Formatter;
import java.util.Locale;

public class DiscreteSeekBar1
extends View {
    private static final String TAG = DiscreteSeekBar1.class.getSimpleName();
    private static final boolean isLollipopOrGreater = Build.VERSION.SDK_INT >= 21;
    private static final String DEFAULT_FORMATTER = "%d";
    private static final int PRESSED_STATE = 16842919;
    private static final int FOCUSED_STATE = 16842908;
    private static final int PROGRESS_ANIMATION_DURATION = 250;
    private static final int INDICATOR_DELAY_FOR_TAPS = 150;
    private static final int DEFAULT_THUMB_COLOR = -16738680;
    private static final int SEPARATION_DP = 5;
    private ThumbDrawable mThumb;
    private TrackRectDrawable mTrack;
    private TrackRectDrawable mTrackBase;
    private TrackRectDrawable mScrubber;
    private Drawable mRipple;
    private int mTrackHeight;
    private int mTrackBaseHeight;
    private int mScrubberHeight;
    private final int mAddedTouchBounds;
    private int mMax;
    private int mMin;
    private int mValue;
    private int mKeyProgressIncrement = 1;
    private boolean mMirrorForRtl = false;
    private boolean mAllowTrackClick = true;
    private boolean mIndicatorPopupEnabled = true;
    Formatter mFormatter;
    private String mIndicatorFormatter;
    private NumericTransformer mNumericTransformer;
    private StringBuilder mFormatBuilder;
    private OnProgressChangeListener mPublicChangeListener;
    private boolean mIsDragging;
    private int mDragOffset;
    private Rect mInvalidateRect = new Rect();
    private Rect mTempRect = new Rect();
    private PopupIndicator mIndicator;
    private AnimatorCompat mPositionAnimator;
    private float mAnimationPosition;
    private int mAnimationTarget;
    private float mDownX;
    private float mTouchSlop;
    private int mValueBase;
    private Runnable mShowIndicatorRunnable = new Runnable(){

        @Override
        public void run() {
            DiscreteSeekBar1.this.showFloater();
        }
    };
    private MarkerDrawable.MarkerAnimationListener mFloaterListener = new MarkerDrawable.MarkerAnimationListener(){

        @Override
        public void onClosingComplete() {
            DiscreteSeekBar1.this.mThumb.animateToNormal();
        }

        @Override
        public void onOpeningComplete() {
        }
    };

    public DiscreteSeekBar1(Context context) {
        this(context, null);
    }

    public DiscreteSeekBar1(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.discreteSeekBarStyle);
    }

    public DiscreteSeekBar1(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TrackRectDrawable shapeDrawable;
        this.setFocusable(true);
        this.setWillNotDraw(false);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        float density = context.getResources().getDisplayMetrics().density;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DiscreteSeekBar, defStyleAttr, R.style.Widget_DiscreteSeekBar);
        int max = 100;
        int min = 0;
        this.mMirrorForRtl = a.getBoolean(R.styleable.DiscreteSeekBar_dsb_mirrorForRtl, this.mMirrorForRtl);
        this.mAllowTrackClick = a.getBoolean(R.styleable.DiscreteSeekBar_dsb_allowTrackClickToDrag, this.mAllowTrackClick);
        this.mIndicatorPopupEnabled = a.getBoolean(R.styleable.DiscreteSeekBar_dsb_indicatorPopupEnabled, this.mIndicatorPopupEnabled);
        this.mTrackHeight = a.getDimensionPixelSize(R.styleable.DiscreteSeekBar_dsb_trackHeight, (int)(1.0f * density));
        this.mTrackBaseHeight = a.getDimensionPixelSize(R.styleable.DiscreteSeekBar_dsb_trackBaseHeight, (int)(1.0f * density));
        this.mScrubberHeight = a.getDimensionPixelSize(R.styleable.DiscreteSeekBar_dsb_scrubberHeight, (int)(4.0f * density));
        int thumbSize = a.getDimensionPixelSize(R.styleable.DiscreteSeekBar_dsb_thumbSize, (int)(density * 12.0f));
        int separation = a.getDimensionPixelSize(R.styleable.DiscreteSeekBar_dsb_indicatorSeparation, (int)(5.0f * density));
        int touchBounds = thumbSize * 3 / 2;
        this.mAddedTouchBounds = Math.max(0, (touchBounds - thumbSize) / 2);
        int indexMax = R.styleable.DiscreteSeekBar_dsb_max;
        int indexMin = R.styleable.DiscreteSeekBar_dsb_min;
        int indexValue = R.styleable.DiscreteSeekBar_dsb_value;
        TypedValue out = new TypedValue();
        if (a.getValue(indexMax, out)) {
            max = out.type == 5 ? a.getDimensionPixelSize(indexMax, max) : a.getInteger(indexMax, max);
        }
        if (a.getValue(indexMin, out)) {
            min = out.type == 5 ? a.getDimensionPixelSize(indexMin, min) : a.getInteger(indexMin, min);
        }
        if (a.getValue(indexValue, out)) {
            this.mValueBase = out.type == 5 ? a.getDimensionPixelSize(indexValue, this.mValueBase) : a.getInteger(indexValue, this.mValueBase);
        }
        this.mMin = min;
        this.mMax = Math.max(min + 1, max);
        this.mValue = Math.max(min, Math.min(max, this.mValueBase));
        this.updateKeyboardRange();
        this.mIndicatorFormatter = a.getString(R.styleable.DiscreteSeekBar_dsb_indicatorFormatter);
        ColorStateList trackColor = a.getColorStateList(R.styleable.DiscreteSeekBar_dsb_trackColor);
        ColorStateList progressColor = a.getColorStateList(R.styleable.DiscreteSeekBar_dsb_progressColor);
        ColorStateList rippleColor = a.getColorStateList(R.styleable.DiscreteSeekBar_dsb_rippleColor);
        boolean editMode = this.isInEditMode();
        if (editMode || rippleColor == null) {
            rippleColor = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{-12303292});
        }
        if (editMode || trackColor == null) {
            trackColor = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{-7829368});
        }
        if (editMode || progressColor == null) {
            progressColor = new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{-16738680});
        }
        this.mRipple = SeekBarCompat.getRipple(rippleColor);
        if (isLollipopOrGreater) {
            SeekBarCompat.setBackground(this, this.mRipple);
        } else {
            this.mRipple.setCallback((Drawable.Callback)this);
        }
        this.mTrack = shapeDrawable = new TrackRectDrawable(trackColor);
        this.mTrack.setCallback((Drawable.Callback)this);
        this.mTrackBase = new TrackRectDrawable(trackColor);
        this.mTrackBase.setCallback((Drawable.Callback)this);
        this.mScrubber = shapeDrawable = new TrackRectDrawable(progressColor);
        this.mScrubber.setCallback((Drawable.Callback)this);
        this.mThumb = new ThumbDrawable(progressColor, thumbSize);
        this.mThumb.setCallback((Drawable.Callback)this);
        this.mThumb.setBounds(0, 0, this.mThumb.getIntrinsicWidth(), this.mThumb.getIntrinsicHeight());
        if (!editMode) {
            this.mIndicator = new PopupIndicator(context, attrs, defStyleAttr, this.convertValueToMessage(this.mMax), thumbSize, thumbSize + this.mAddedTouchBounds + separation);
            this.mIndicator.setListener(this.mFloaterListener);
        }
        a.recycle();
        this.setNumericTransformer(new DefaultNumericTransformer());
    }

    public void setIndicatorFormatter(@Nullable String formatter) {
        this.mIndicatorFormatter = formatter;
        this.updateProgressMessage(this.mValue);
    }

    public void setNumericTransformer(@Nullable NumericTransformer transformer) {
        this.mNumericTransformer = transformer != null ? transformer : new DefaultNumericTransformer();
        this.updateIndicatorSizes();
        this.updateProgressMessage(this.mValue);
    }

    public NumericTransformer getNumericTransformer() {
        return this.mNumericTransformer;
    }

    public void setMax(int max) {
        if (this.mMax == max) {
            return;
        }
        this.mMax = max;
        if (this.mMax < this.mMin) {
            this.setMin(this.mMax - 1);
        }
        this.updateKeyboardRange();
        this.updateIndicatorSizes();
    }

    public int getMax() {
        return this.mMax;
    }

    public void setMin(int min) {
        if (this.mMin == min) {
            return;
        }
        this.mMin = min;
        if (this.mMin > this.mMax) {
            this.setMax(this.mMin + 1);
        }
        this.updateKeyboardRange();
    }

    public int getMin() {
        return this.mMin;
    }

    public void setProgress(int progress) {
        this.setProgress(progress, false);
    }

    private void setProgress(int value, boolean fromUser) {
        value = Math.max(this.mMin, Math.min(this.mMax, value));
        if (this.isAnimationRunning()) {
            this.mPositionAnimator.cancel();
        }
        this.mValue = value;
        this.notifyProgress(value, fromUser);
        this.updateProgressMessage(value);
        this.updateThumbPosFromCurrentProgress();
    }

    public int getProgress() {
        return this.mValue;
    }

    public void setOnProgressChangeListener(@Nullable OnProgressChangeListener listener) {
        this.mPublicChangeListener = listener;
    }

    public void setThumbColor(int thumbColor, int indicatorColor) {
        this.mThumb.setColorStateList(ColorStateList.valueOf((int)thumbColor));
        this.mIndicator.setColors(indicatorColor, thumbColor);
    }

    public void setThumbColor(@NonNull ColorStateList thumbColorStateList, int indicatorColor) {
        this.mThumb.setColorStateList(thumbColorStateList);
        int thumbColor = thumbColorStateList.getColorForState(new int[]{16842919}, thumbColorStateList.getDefaultColor());
        this.mIndicator.setColors(indicatorColor, thumbColor);
    }

    public void setScrubberColor(int color2) {
        this.mScrubber.setColorStateList(ColorStateList.valueOf((int)color2));
    }

    public void setScrubberColor(@NonNull ColorStateList colorStateList) {
        this.mScrubber.setColorStateList(colorStateList);
    }

    public void setRippleColor(int color2) {
        this.setRippleColor(new ColorStateList((int[][])new int[][]{new int[0]}, new int[]{color2}));
    }

    public void setRippleColor(@NonNull ColorStateList colorStateList) {
        SeekBarCompat.setRippleColor(this.mRipple, colorStateList);
    }

    public void setTrackColor(int color2) {
        this.mTrack.setColorStateList(ColorStateList.valueOf((int)color2));
    }

    public void setTrackColor(@NonNull ColorStateList colorStateList) {
        this.mTrack.setColorStateList(colorStateList);
    }

    public void setIndicatorPopupEnabled(boolean enabled) {
        this.mIndicatorPopupEnabled = enabled;
    }

    private void updateIndicatorSizes() {
        if (!this.isInEditMode()) {
            if (this.mNumericTransformer.useStringTransform()) {
                this.mIndicator.updateSizes(this.mNumericTransformer.transformToString(this.mMax));
            } else {
                this.mIndicator.updateSizes(this.convertValueToMessage(this.mNumericTransformer.transform(this.mMax)));
            }
        }
    }

    private void notifyProgress(int value, boolean fromUser) {
        if (this.mPublicChangeListener != null) {
            this.mPublicChangeListener.onProgressChanged(this, value, fromUser);
        }
        this.onValueChanged(value);
    }

    private void notifyBubble(boolean open) {
        if (open) {
            this.onShowBubble();
        } else {
            this.onHideBubble();
        }
    }

    protected void onShowBubble() {
    }

    protected void onHideBubble() {
    }

    protected void onValueChanged(int value) {
    }

    private void updateKeyboardRange() {
        int range = this.mMax - this.mMin;
        if (this.mKeyProgressIncrement == 0 || range / this.mKeyProgressIncrement > 20) {
            this.mKeyProgressIncrement = Math.max(1, Math.round((float)range / 20.0f));
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = this.mThumb.getIntrinsicHeight() + this.getPaddingTop() + this.getPaddingBottom();
        this.setMeasuredDimension(widthSize, height += this.mAddedTouchBounds * 2);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.removeCallbacks(this.mShowIndicatorRunnable);
            if (!this.isInEditMode()) {
                this.mIndicator.dismissComplete();
            }
            this.updateFromDrawableState();
        }
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        super.scheduleDrawable(who, what, when);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int thumbWidth = this.mThumb.getIntrinsicWidth();
        int thumbHeight = this.mThumb.getIntrinsicHeight();
        int addedThumb = this.mAddedTouchBounds;
        int halfThumb = thumbWidth / 2;
        int paddingLeft = this.getPaddingLeft() + addedThumb;
        int paddingRight = this.getPaddingRight();
        int bottom = this.getHeight() - this.getPaddingBottom() - addedThumb;
        this.mThumb.setBounds(paddingLeft, bottom - thumbHeight, paddingLeft + thumbWidth, bottom);
        int trackHeight = Math.max(this.mTrackHeight / 2, 1);
        this.mTrack.setBounds(paddingLeft + halfThumb, bottom - halfThumb - trackHeight, this.getWidth() - halfThumb - paddingRight - addedThumb, bottom - halfThumb + trackHeight);
        int available = this.getWidth() - paddingRight - addedThumb - paddingLeft - thumbWidth;
        float scaleDrawBase = (float)(this.mValueBase - this.mMin) / (float)(this.mMax - this.mMin);
        int thumbPosBase = (int)(scaleDrawBase * (float)available + 0.5f);
        this.mTrackBase.setBounds(paddingLeft + halfThumb + thumbPosBase - this.mTrackBaseHeight / 8, bottom - halfThumb - this.mTrackBaseHeight / 2, paddingLeft + halfThumb + thumbPosBase + this.mTrackBaseHeight / 8, bottom - halfThumb + this.mTrackBaseHeight / 2);
        int scrubberHeight = Math.max(this.mScrubberHeight / 2, 2);
        this.mScrubber.setBounds(paddingLeft + halfThumb, bottom - halfThumb - scrubberHeight, paddingLeft + halfThumb, bottom - halfThumb + scrubberHeight);
        this.updateThumbPosFromCurrentProgress();
    }

    protected synchronized void onDraw(Canvas canvas) {
        if (!isLollipopOrGreater) {
            this.mRipple.draw(canvas);
        }
        super.onDraw(canvas);
        this.mTrack.draw(canvas);
        this.mScrubber.draw(canvas);
        if (this.mMin != this.mValueBase && this.mMax != this.mValueBase) {
            this.mTrackBase.draw(canvas);
        }
        this.mThumb.draw(canvas);
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.updateFromDrawableState();
    }

    private void updateFromDrawableState() {
        int[] state = this.getDrawableState();
        boolean focused = false;
        boolean pressed = false;
        for (int i : state) {
            if (i == 16842908) {
                focused = true;
                continue;
            }
            if (i != 16842919) continue;
            pressed = true;
        }
        if (this.isEnabled() && (focused || pressed) && this.mIndicatorPopupEnabled) {
            this.removeCallbacks(this.mShowIndicatorRunnable);
            this.postDelayed(this.mShowIndicatorRunnable, 150L);
        } else {
            this.hideFloater();
        }
        this.mThumb.setState(state);
        this.mTrack.setState(state);
        this.mScrubber.setState(state);
        this.mRipple.setState(state);
    }

    private void updateProgressMessage(int value) {
        if (!this.isInEditMode()) {
            if (this.mNumericTransformer.useStringTransform()) {
                this.mIndicator.setValue(this.mNumericTransformer.transformToString(value));
            } else {
                this.mIndicator.setValue(this.convertValueToMessage(this.mNumericTransformer.transform(value)));
            }
        }
    }

    private String convertValueToMessage(int value) {
        String format;
        String string = format = this.mIndicatorFormatter != null ? this.mIndicatorFormatter : DEFAULT_FORMATTER;
        if (this.mFormatter == null || !this.mFormatter.locale().equals(Locale.getDefault())) {
            int bufferSize = format.length() + String.valueOf(this.mMax).length();
            if (this.mFormatBuilder == null) {
                this.mFormatBuilder = new StringBuilder(bufferSize);
            } else {
                this.mFormatBuilder.ensureCapacity(bufferSize);
            }
            this.mFormatter = new Formatter(this.mFormatBuilder, Locale.getDefault());
        } else {
            this.mFormatBuilder.setLength(0);
        }
        return this.mFormatter.format(format, value).toString();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.mDownX = event.getX();
                this.startDragging(event, this.isInScrollingContainer());
                break;
            }
            case 2: {
                if (this.isDragging()) {
                    this.updateDragging(event);
                    break;
                }
                float x = event.getX();
                if (!(Math.abs(x - this.mDownX) > this.mTouchSlop)) break;
                this.startDragging(event, false);
                break;
            }
            case 1: {
                if (!this.isDragging() && this.mAllowTrackClick) {
                    this.startDragging(event, false);
                    this.updateDragging(event);
                }
                this.stopDragging();
                break;
            }
            case 3: {
                this.stopDragging();
            }
        }
        return true;
    }

    private boolean isInScrollingContainer() {
        return SeekBarCompat.isInScrollingContainer(this.getParent());
    }

    private boolean startDragging(MotionEvent ev, boolean ignoreTrackIfInScrollContainer) {
        Rect bounds = this.mTempRect;
        this.mThumb.copyBounds(bounds);
        bounds.inset(-this.mAddedTouchBounds, -this.mAddedTouchBounds);
        this.mIsDragging = bounds.contains((int)ev.getX(), (int)ev.getY());
        if (!this.mIsDragging && this.mAllowTrackClick && !ignoreTrackIfInScrollContainer) {
            this.mIsDragging = true;
            this.mDragOffset = bounds.width() / 2 - this.mAddedTouchBounds;
            this.updateDragging(ev);
            this.mThumb.copyBounds(bounds);
            bounds.inset(-this.mAddedTouchBounds, -this.mAddedTouchBounds);
        }
        if (this.mIsDragging) {
            this.setPressed(true);
            this.attemptClaimDrag();
            this.setHotspot(ev.getX(), ev.getY());
            this.mDragOffset = (int)(ev.getX() - (float)bounds.left - (float)this.mAddedTouchBounds);
            if (this.mPublicChangeListener != null) {
                this.mPublicChangeListener.onStartTrackingTouch(this);
            }
        }
        return this.mIsDragging;
    }

    private boolean isDragging() {
        return this.mIsDragging;
    }

    private void stopDragging() {
        if (this.mPublicChangeListener != null) {
            this.mPublicChangeListener.onStopTrackingTouch(this);
        }
        this.mIsDragging = false;
        this.setPressed(false);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean handled = false;
        if (this.isEnabled()) {
            int progress = this.getAnimatedProgress();
            switch (keyCode) {
                case 21: {
                    handled = true;
                    if (progress <= this.mMin) break;
                    this.animateSetProgress(progress - this.mKeyProgressIncrement);
                    break;
                }
                case 22: {
                    handled = true;
                    if (progress >= this.mMax) break;
                    this.animateSetProgress(progress + this.mKeyProgressIncrement);
                }
            }
        }
        return handled || super.onKeyDown(keyCode, event);
    }

    private int getAnimatedProgress() {
        return this.isAnimationRunning() ? this.getAnimationTarget() : this.mValue;
    }

    boolean isAnimationRunning() {
        return this.mPositionAnimator != null && this.mPositionAnimator.isRunning();
    }

    void animateSetProgress(int progress) {
        float curProgress;
        float f = curProgress = this.isAnimationRunning() ? this.getAnimationPosition() : (float)this.getProgress();
        if (progress < this.mMin) {
            progress = this.mMin;
        } else if (progress > this.mMax) {
            progress = this.mMax;
        }
        if (this.mPositionAnimator != null) {
            this.mPositionAnimator.cancel();
        }
        this.mAnimationTarget = progress;
        this.mPositionAnimator = AnimatorCompat.create(curProgress, progress, new AnimatorCompat.AnimationFrameUpdateListener(){

            @Override
            public void onAnimationFrame(float currentValue) {
                DiscreteSeekBar1.this.setAnimationPosition(currentValue);
            }
        });
        this.mPositionAnimator.setDuration(250);
        this.mPositionAnimator.start();
    }

    private int getAnimationTarget() {
        return this.mAnimationTarget;
    }

    void setAnimationPosition(float position) {
        this.mAnimationPosition = position;
        float currentScale = (position - (float)this.mMin) / (float)(this.mMax - this.mMin);
        this.updateProgressFromAnimation(currentScale);
    }

    float getAnimationPosition() {
        return this.mAnimationPosition;
    }

    private void updateDragging(MotionEvent ev) {
        this.setHotspot(ev.getX(), ev.getY());
        int x = (int)ev.getX();
        Rect oldBounds = this.mThumb.getBounds();
        int halfThumb = oldBounds.width() / 2;
        int addedThumb = this.mAddedTouchBounds;
        int newX = x - this.mDragOffset + halfThumb;
        int left = this.getPaddingLeft() + halfThumb + addedThumb;
        int right = this.getWidth() - (this.getPaddingRight() + halfThumb + addedThumb);
        if (newX < left) {
            newX = left;
        } else if (newX > right) {
            newX = right;
        }
        int available = right - left;
        float scale = (float)(newX - left) / (float)available;
        if (this.isRtl()) {
            scale = 1.0f - scale;
        }
        int progress = Math.round(scale * (float)(this.mMax - this.mMin) + (float)this.mMin);
        this.setProgress(progress, true);
    }

    private void updateProgressFromAnimation(float scale) {
        Rect bounds = this.mThumb.getBounds();
        int halfThumb = bounds.width() / 2;
        int addedThumb = this.mAddedTouchBounds;
        int left = this.getPaddingLeft() + halfThumb + addedThumb;
        int right = this.getWidth() - (this.getPaddingRight() + halfThumb + addedThumb);
        int available = right - left;
        int progress = Math.round(scale * (float)(this.mMax - this.mMin) + (float)this.mMin);
        if (progress != this.getProgress()) {
            this.mValue = progress;
            this.notifyProgress(this.mValue, true);
            this.updateProgressMessage(progress);
        }
        int thumbPos = (int)(scale * (float)available + 0.5f);
        float scaleDrawBase = (float)(this.mValueBase - this.mMin) / (float)(this.mMax - this.mMin);
        int thumbPosBase = (int)(scaleDrawBase * (float)available + 0.5f);
        this.updateThumbPos(thumbPosBase, thumbPos);
    }

    private void updateThumbPosFromCurrentProgress() {
        int thumbWidth = this.mThumb.getIntrinsicWidth();
        int addedThumb = this.mAddedTouchBounds;
        int halfThumb = thumbWidth / 2;
        int left = this.getPaddingLeft() + halfThumb + addedThumb;
        int right = this.getWidth() - (this.getPaddingRight() + halfThumb + addedThumb);
        int available = right - left;
        float scaleDraw = (float)(this.mValue - this.mMin) / (float)(this.mMax - this.mMin);
        float scaleDrawBase = (float)(this.mValueBase - this.mMin) / (float)(this.mMax - this.mMin);
        int thumbPos = (int)(scaleDraw * (float)available + 0.5f);
        int thumbPosBase = (int)(scaleDrawBase * (float)available + 0.5f);
        this.updateThumbPos(thumbPosBase, thumbPos);
    }

    private void updateThumbPos(int base, int value) {
        int start = Math.min(base += this.getPaddingLeft() + this.mAddedTouchBounds, value += this.getPaddingLeft() + this.mAddedTouchBounds);
        int end = Math.max(base, value);
        int thumbWidth = this.mThumb.getIntrinsicWidth();
        int halfThumb = thumbWidth / 2;
        this.mThumb.copyBounds(this.mInvalidateRect);
        this.mThumb.setBounds(value, this.mInvalidateRect.top, value + thumbWidth, this.mInvalidateRect.bottom);
        this.mScrubber.getBounds().left = start + halfThumb;
        this.mScrubber.getBounds().right = end + halfThumb;
        Rect finalBounds = this.mTempRect;
        this.mThumb.copyBounds(finalBounds);
        if (!this.isInEditMode()) {
            this.mIndicator.move(finalBounds.centerX());
        }
        this.mTrackBase.getBounds().left = base + halfThumb - this.mTrackBaseHeight / 8;
        this.mTrackBase.getBounds().right = base + halfThumb + this.mTrackBaseHeight / 8;
        this.mInvalidateRect.inset(-this.mAddedTouchBounds, -this.mAddedTouchBounds);
        finalBounds.inset(-this.mAddedTouchBounds, -this.mAddedTouchBounds);
        this.mInvalidateRect.union(finalBounds);
        SeekBarCompat.setHotspotBounds(this.mRipple, finalBounds.left, finalBounds.top, finalBounds.right, finalBounds.bottom);
        this.invalidate(this.mInvalidateRect);
    }

    private void setHotspot(float x, float y) {
        DrawableCompat.setHotspot((Drawable)this.mRipple, (float)x, (float)y);
    }

    protected boolean verifyDrawable(Drawable who) {
        return who == this.mThumb || who == this.mTrack || who == this.mScrubber || who == this.mRipple || super.verifyDrawable(who);
    }

    private void attemptClaimDrag() {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(true);
        }
    }

    private void showFloater() {
        if (!this.isInEditMode()) {
            this.mThumb.animateToPressed();
            this.mIndicator.showIndicator(this, this.mThumb.getBounds());
            this.notifyBubble(true);
        }
    }

    private void hideFloater() {
        this.removeCallbacks(this.mShowIndicatorRunnable);
        if (!this.isInEditMode()) {
            this.mIndicator.dismiss();
            this.notifyBubble(false);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mShowIndicatorRunnable);
        if (!this.isInEditMode()) {
            this.mIndicator.dismissComplete();
        }
    }

    @SuppressLint(value={"WrongConstant"})
    public boolean isRtl() {
        return ViewCompat.getLayoutDirection((View)this) == 1 && this.mMirrorForRtl;
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        CustomState state = new CustomState(superState);
        state.progress = this.getProgress();
        state.max = this.mMax;
        state.min = this.mMin;
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state == null || !state.getClass().equals(CustomState.class)) {
            super.onRestoreInstanceState(state);
            return;
        }
        CustomState customState = (CustomState)state;
        this.setMin(customState.min);
        this.setMax(customState.max);
        this.setProgress(customState.progress, false);
        super.onRestoreInstanceState(customState.getSuperState());
    }

    static class CustomState
    extends View.BaseSavedState {
        private int progress;
        private int max;
        private int min;
        public static final Parcelable.Creator<CustomState> CREATOR = new Parcelable.Creator<CustomState>(){

            public CustomState[] newArray(int size) {
                return new CustomState[size];
            }

            public CustomState createFromParcel(Parcel incoming) {
                return new CustomState(incoming);
            }
        };

        public CustomState(Parcel source) {
            super(source);
            this.progress = source.readInt();
            this.max = source.readInt();
            this.min = source.readInt();
        }

        public CustomState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel outcoming, int flags) {
            super.writeToParcel(outcoming, flags);
            outcoming.writeInt(this.progress);
            outcoming.writeInt(this.max);
            outcoming.writeInt(this.min);
        }
    }

    private static class DefaultNumericTransformer
    extends NumericTransformer {
        private DefaultNumericTransformer() {
        }

        @Override
        public int transform(int value) {
            return value;
        }
    }

    public static abstract class NumericTransformer {
        public abstract int transform(int var1);

        public String transformToString(int value) {
            return String.valueOf(value);
        }

        public boolean useStringTransform() {
            return false;
        }
    }

    public static class OnSimpleProgressChangeListener
    implements OnProgressChangeListener {
        @Override
        public void onProgressChanged(DiscreteSeekBar1 seekBar, int value, boolean fromUser) {
        }

        @Override
        public void onStartTrackingTouch(DiscreteSeekBar1 seekBar) {
        }

        @Override
        public void onStopTrackingTouch(DiscreteSeekBar1 seekBar) {
        }
    }

    public static interface OnProgressChangeListener {
        public void onProgressChanged(DiscreteSeekBar1 var1, int var2, boolean var3);

        public void onStartTrackingTouch(DiscreteSeekBar1 var1);

        public void onStopTrackingTouch(DiscreteSeekBar1 var1);
    }
}

