package com.vhall.beautifykit.control

import android.animation.ValueAnimator
import android.content.Context
import android.os.Build
import android.support.annotation.RequiresApi
import android.support.v7.widget.GridLayoutManager
import android.util.AttributeSet
import android.view.*
import android.view.animation.AlphaAnimation
import android.view.animation.Animation
import android.view.animation.AnimationSet
import android.view.animation.TranslateAnimation
import android.widget.ImageView
import android.widget.LinearLayout
import android.widget.Switch
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.resource.bitmap.RoundedCorners
import com.bumptech.glide.request.RequestOptions
import com.vhall.beautifykit.R
import com.vhall.beautifykit.base.BaseDelegate
import com.vhall.beautifykit.base.BaseListAdapter
import com.vhall.beautifykit.base.BaseViewHolder
import com.vhall.beautifykit.dialog.ToastHelper
import com.vhall.beautifykit.entity.FaceBeautyBean
import com.vhall.beautifykit.entity.FaceBeautyFilterBean
import com.vhall.beautifykit.entity.FaceBeautyStyleBean
import com.vhall.beautifykit.entity.ModelAttributeData
import com.vhall.beautifykit.infe.AbstractFaceBeautyDataFactory
import com.vhall.beautifykit.seekbar.DiscreteSeekBar
import com.vhall.beautifykit.utils.DecimalUtils
import kotlinx.android.synthetic.main.layout_face_beauty_control.view.*


/**
 *
 * DESC：美颜
 * Created on 2020/11/17
 *
 */
class FaceBeautyControlView @JvmOverloads constructor(private val mContext: Context, attrs: AttributeSet? = null, defStyleAttr: Int = 0) :
        BaseControlView(mContext, attrs, defStyleAttr) {

    private lateinit var mDataFactory: AbstractFaceBeautyDataFactory

    /*  美颜、美型 */ // 原始数据 不会变
    private lateinit var mModelAttributeRange: HashMap<String, ModelAttributeData>
    private var mSkinBeauty = ArrayList<FaceBeautyBean>()
    private var mShapeBeauty = ArrayList<FaceBeautyBean>()
    private var mShapeBeautySubItem = ArrayList<FaceBeautyBean>()
    private var mSubItemUIValueCache: HashMap<String, Double> = HashMap()//美型子项脸型的UI缓存值
    private var mSkinIndex = 0
    private var mShapeIndex = 1
    private var mFiltersIndex = 1
    private var mIsOnBeautyShapeMain = true//美型是否在主项上

    private lateinit var mBeautyAdapter: BaseListAdapter<FaceBeautyBean>

    /* 滤镜 */
    private var mFilters = ArrayList<FaceBeautyFilterBean>()
    private lateinit var mFiltersAdapter: BaseListAdapter<FaceBeautyFilterBean>

    /* 风格 */
    private var mStyles = ArrayList<FaceBeautyStyleBean>()
    private lateinit var mStylesAdapter: BaseListAdapter<FaceBeautyStyleBean>
    private var mEnableBottomRationClick = true

    //是否设置美颜对比按钮
    private var mEnableCompare = false
    // region  init

    private var openBeauty = true

    init {
        LayoutInflater.from(context).inflate(R.layout.layout_face_beauty_control, this)
        initView()
        initAdapter()
        bindListener()
    }

    /**
     * 设置 主选项是否显示
     * skin    美肤
     * face    美型
     * filter  滤镜
     * style   风格推荐
     */
    fun setMainTabVisibility(skin: Boolean, face: Boolean, filter: Boolean, style: Boolean) {
        beauty_radio_skin_beauty.visibility = if (skin) VISIBLE else GONE
        beauty_radio_face_shape.visibility = if (face) VISIBLE else GONE
        beauty_radio_filter.visibility = if (filter) VISIBLE else GONE
        beauty_radio_style.visibility = if (style) VISIBLE else GONE
    }


    //设置进度条是否存在 其他项目需要 自己计算 高度
    fun setSelectLineVisible() {
        select_line.visibility = VISIBLE
    }

    /**
     * 给控制绑定FaceBeautyController，数据工厂
     * @param dataFactory IFaceBeautyDataFactory
     */
    fun bindDataFactory(dataFactory: AbstractFaceBeautyDataFactory) {
        mDataFactory = dataFactory
        mFiltersIndex = dataFactory.currentFilterIndex
        mModelAttributeRange = dataFactory.modelAttributeRange
        mSkinBeauty = dataFactory.skinBeauty
        mShapeBeauty = dataFactory.shapeBeauty
        mShapeBeautySubItem = dataFactory.shapeBeautySubItem
        mFilters = dataFactory.beautyFilters
        openBeauty = dataFactory.openBeauty
        if (!openBeauty) {
            ll_seek_bar.visibility = View.GONE
            mShapeIndex = 0
        }
        mStyles = dataFactory.beautyStyles
        mFiltersAdapter.setData(mFilters)
        mStylesAdapter.setData(mStyles)
        if (dataFactory.currentStyleIndex > -1) {
            setBottomCheckRatioEnable(false)
        } else {
            setBottomCheckRatioEnable(true)
        }
        beauty_radio_group.check(R.id.beauty_radio_face_shape)

        //恢复上一次脸型选项的UI值
        mSubItemUIValueCache = mDataFactory.getCurrentFaceShapeUIValue()

        setNewData()
    }

    /**
     * 设置初始化美颜值
     */
    private fun setNewData() {
        var value: Double
        if (openBeauty) {
            mShapeBeauty.forEach {
                value = mDataFactory.getParamIntensity(it.key, mModelAttributeRange[it.key]!!.default)
                mDataFactory.updateParamIntensity(it.key, value)
            }
        }
        val faceBeautyFilterBean = mFilters[mFiltersIndex]
        value = mDataFactory.getParamIntensity(faceBeautyFilterBean.key, faceBeautyFilterBean.intensity)
        mDataFactory.updateFilterIntensity(faceBeautyFilterBean.key, value)
    }


    fun changeOrientation(orientation: Int) {
        isVertical = orientation != 0
        when (orientation) {
            // 0 横屏
            0 -> {
                bg_view.apply {
                    this.layoutParams.width = dpToPx(300)
                    this.layoutParams.height = ViewGroup.LayoutParams.MATCH_PARENT
                    this.setBackgroundResource(R.drawable.bg_horizontal_dialog)
                }
                root_view.gravity = Gravity.RIGHT
                beauty_seek_bar.layoutParams.width = dpToPx(240)
            }
            // 1 竖屏
            else -> {
                bg_view.apply {
                    this.layoutParams.width = ViewGroup.LayoutParams.MATCH_PARENT
                    this.layoutParams.height = dpToPx(260)
                    this.setBackgroundResource(R.drawable.bg_vertical_dialog)
                }
                root_view.gravity = Gravity.BOTTOM
                beauty_seek_bar.layoutParams.width = dpToPx(320)
            }
        }
        initView()
    }

    /**
     *  View初始化
     */
    private fun initView() {
        if (isVertical)
            initVerticalRecycleView(recycler_view)
        else
            initHorizontalRecycleView(recycler_view)
    }


    /**
     *  构造Adapter
     */
    private fun initAdapter() {
        mStylesAdapter = BaseListAdapter(
                ArrayList(), object : BaseDelegate<FaceBeautyStyleBean>() {
            override fun convert(viewType: Int, helper: BaseViewHolder, data: FaceBeautyStyleBean, position: Int) {
                helper.setText(R.id.tv_control, data.desRes)
                helper.setImageResource(R.id.iv_control, data.imageRes)
                helper.itemView.isSelected = mDataFactory.currentStyleIndex == position
            }

            override fun onItemClickListener(view: View, data: FaceBeautyStyleBean, position: Int) {
                super.onItemClickListener(view, data, position)
                if (mDataFactory.currentStyleIndex != position) {
                    setBottomCheckRatioEnable(false)
                    changeAdapterSelected(mStylesAdapter, mDataFactory.currentStyleIndex, position)
                    mDataFactory.currentStyleIndex = position
                    mDataFactory.onStyleSelected(data.key)
                }
            }
        }, R.layout.list_item_control_title_image_circle
        )

        mFiltersAdapter = BaseListAdapter(
                ArrayList(), object : BaseDelegate<FaceBeautyFilterBean>() {
            override fun convert(viewType: Int, helper: BaseViewHolder, data: FaceBeautyFilterBean, position: Int) {
                helper.setText(R.id.tv_control, data.desRes)
                val image = helper.getView<ImageView>(R.id.iv_control)
//                helper.setImageResource(R.id.iv_control, data.imageRes)

                var imageRes = data.imageRes
                if (image != null) {
                    if (data.buttonType == FaceBeautyFilterBean.ButtonType.CHECK_BUTTON) {
                        if (mFiltersIndex == position && data.imageResSelect != -1) {
                            imageRes = data.imageResSelect
                        }
                    }

                    Glide.with(mContext)
                            .load(imageRes)
                            .apply(RequestOptions.bitmapTransform(RoundedCorners(dpToPx(4))))
                            .into(image)
                }
                helper.itemView.isSelected = mFiltersIndex == position
//                if (data.buttonType == FaceBeautyFilterBean.ButtonType.CHECK_BUTTON) {
//                    image!!.isSelected = mFiltersIndex == position
//                }
            }

            override fun onItemClickListener(view: View, data: FaceBeautyFilterBean, position: Int) {
                super.onItemClickListener(view, data, position)
                if (mFiltersIndex != position) {
                    changeAdapterSelected(mFiltersAdapter, mFiltersIndex, position)
                    mFiltersIndex = position
                    //还原缓存的值
                    val value = mDataFactory.getParamIntensity(data.key, data.intensity)
                    mDataFactory.onFilterSelected(data.key, value, position)
                    if (data.buttonType == FaceBeautyFilterBean.ButtonType.CHECK_BUTTON) {
                        ll_seek_bar.visibility = View.GONE
                    } else {
                        seekToSeekBar(value, 0.0, 1.0)
                    }
                    mFiltersAdapter.notifyItemChanged(0)
                }
            }
        }, R.layout.list_item_control_title_image_square
        )

        mBeautyAdapter = BaseListAdapter(ArrayList(), object : BaseDelegate<FaceBeautyBean>() {
            override fun convert(viewType: Int, helper: BaseViewHolder, data: FaceBeautyBean, position: Int) {
                val isShinSelected = beauty_radio_group.checkedCheckBoxId == R.id.beauty_radio_skin_beauty
                helper.setText(R.id.tv_control, data.desRes)
                val view = helper.getView<TextView>(R.id.tv_control)
                val switch = helper.getView<Switch>(R.id.sw_beauty)
                val ll = helper.getView<View>(R.id.ll)
                view!!.visibility = VISIBLE
                switch!!.visibility = GONE
                ll!!.visibility = VISIBLE
                helper.itemView.isSelected = if (isShinSelected) mSkinIndex == position else mShapeIndex == position
                //主项的时候才需要显示
                val value = mDataFactory.getParamIntensity(data.key, mModelAttributeRange[data.key]!!.default)
                when (data.buttonType) {
                    FaceBeautyBean.ButtonType.BACK_BUTTON -> {
                        helper.setImageResource(R.id.iv_control, data.closeRes)
                    }
                    FaceBeautyBean.ButtonType.CHECK_BUTTON -> {
                        helper.setImageResource(R.id.iv_control, data.closeRes)
                        view.visibility = GONE
                        ll.visibility = GONE
                        switch.visibility = VISIBLE
                        switch.isChecked = openBeauty
                    }
                    FaceBeautyBean.ButtonType.SUB_ITEM_BUTTON -> {
                        //判断当前UI值 和 真实值是否全是空的如果是空的则不选中
                        //先过UI值
                        var choose = false
                        run outside@{
                            mSubItemUIValueCache.forEach {
                                if (it.value > 0) {
                                    choose = true
                                }
                            }

                            mShapeBeautySubItem.forEach {
                                if (it.buttonType == FaceBeautyBean.ButtonType.NORMAL_BUTTON) {
                                    if (mDataFactory.getParamIntensity(it.key, mModelAttributeRange[data.key]!!.default) > 0) {
                                        choose = true
                                    }
                                }
                            }
                        }

                        helper.setImageResource(R.id.iv_control, if (choose) data.openRes else data.closeRes)
                    }
                    //普通按钮
                    else -> {
                        val stand = mModelAttributeRange[data.key]!!.stand
                        if (DecimalUtils.doubleEquals(value, stand)) {
                            helper.setImageResource(R.id.iv_control, data.closeRes)
                        } else {
                            helper.setImageResource(R.id.iv_control, data.openRes)
                        }

                        if (openEnterAnimation && needEnterAnimation && position != 0) {
                            enterAnimation(helper.itemView)
                            if (position >= 4 || (mBeautyAdapter.itemCount < 5 && position == mBeautyAdapter.itemCount - 1)) {
                                needEnterAnimation = false
                            }
                        }
                    }
                }
            }

            override fun onItemClickListener(view: View, data: FaceBeautyBean, position: Int) {
                val isShinSelected = beauty_radio_group.checkedCheckBoxId == R.id.beauty_radio_skin_beauty
                if ((isShinSelected && position == mSkinIndex) || (!isShinSelected && position == mShapeIndex && position != 0)) {
                    return
                }
                if (!openBeauty && !isShinSelected && position != 0) {
                    return
                }
                if (isShinSelected) {
                    changeAdapterSelected(mBeautyAdapter, mSkinIndex, position)
                    val value = mDataFactory.getParamIntensity(data.key, mModelAttributeRange[data.key]!!.default)
                    val stand = mModelAttributeRange[data.key]!!.stand
                    val maxRange = mModelAttributeRange[data.key]!!.maxRange
                    seekToSeekBar(value, stand, maxRange)
                    mSkinIndex = position
                } else {
                    //点击了美型，查询按钮类型
                    when (data.buttonType) {
                        FaceBeautyBean.ButtonType.BACK_BUTTON -> {
                            //返回按钮
                            mBeautyAdapter.setData(mShapeBeauty)
                            //没有按钮被选中，需要隐藏进度条
                            ll_seek_bar.visibility = View.GONE
                            changeAdapterSelected(mBeautyAdapter, mShapeIndex, -1)
                            mShapeIndex = -1
                            mIsOnBeautyShapeMain = true
                            needEnterAnimation = true
                        }
                        FaceBeautyBean.ButtonType.CHECK_BUTTON -> {
                            switchClick(view.findViewById(R.id.sw_beauty))
                            if (openBeauty) {
                                mShapeIndex = 1
                                mBeautyAdapter.notifyItemChanged(mShapeIndex)
                                var dataDefault: FaceBeautyBean = mBeautyAdapter.getData(mShapeIndex)
                                var value: Double = mDataFactory.getParamIntensity(dataDefault.key, mModelAttributeRange[dataDefault.key]!!.default)
                                val stand = mModelAttributeRange[dataDefault.key]!!.stand
                                val maxRange = mModelAttributeRange[dataDefault.key]!!.maxRange
                                seekToSeekBar(value, stand, maxRange)
                                changeAdapterSelected(mBeautyAdapter, mShapeIndex, -1)
                            } else {
                                ll_seek_bar.visibility = View.GONE
                                changeAdapterSelected(mBeautyAdapter, mShapeIndex, -1)
                                mShapeIndex = 0
                            }
                        }
                        FaceBeautyBean.ButtonType.SUB_ITEM_BUTTON -> {
                            //子项按钮
                            //选中的是哪一个子项 -> 在FaceBeauty中有记录
                            run outside@{
                                mShapeBeautySubItem.forEachIndexed { index, value ->
                                    if (mDataFactory.getCurrentOneHotFaceShape() == value.key) {//获取当前作用的脸型
                                        mShapeIndex = index
                                        return@outside
                                    }
                                }
                            }

                            mBeautyAdapter.setData(mShapeBeautySubItem)
                            if (mShapeBeautySubItem.size >= 1) {
                                ll_seek_bar.visibility = View.VISIBLE
                                val faceBeautyBean = mShapeBeautySubItem[mShapeIndex]
                                if (faceBeautyBean.buttonType == FaceBeautyBean.ButtonType.NORMAL_BUTTON) {
                                    val value = mDataFactory.getParamIntensity(faceBeautyBean.key, mModelAttributeRange[faceBeautyBean.key]!!.default)
                                    val stand = mModelAttributeRange[faceBeautyBean.key]!!.stand
                                    val maxRange = mModelAttributeRange[faceBeautyBean.key]!!.maxRange
                                    seekToSeekBar(value, stand, maxRange)
                                }
                            }
                            mIsOnBeautyShapeMain = false
                            needEnterAnimation = true
                        }
                        //普通按钮
                        else -> {
                            //点击的是子项普通按钮还是主项普通按钮1.子项普通之间按钮效果One Hot 2.主项普通按钮之间效果可叠加
                            changeAdapterSelected(mBeautyAdapter, mShapeIndex, position)
                            //判断一下是子项还是主项，1.主项直接设置改点击对象的值，2.子项需要获取之前的缓存如果存在缓存设置回之前的值，然后还要将上一个点击过的子项sdk值设置为零，UI值进行缓存
                            var value: Double
                            if (mIsOnBeautyShapeMain) {
                                value = mDataFactory.getParamIntensity(data.key, mModelAttributeRange[data.key]!!.default)
                                mDataFactory.updateParamIntensity(data.key, value)
                            } else {
                                //子项 one hot + 如果有UI值显示UI值 -> 并将UI缓存值设置到SDK
                                value = if (mSubItemUIValueCache.contains(data.key)) {
                                    var value = mSubItemUIValueCache[data.key]!!
                                    mDataFactory.updateParamIntensity(data.key, value)
                                    mSubItemUIValueCache.remove(data.key)!!
                                } else
                                    mDataFactory.getParamIntensity(data.key, mModelAttributeRange[data.key]!!.default)
                                //将上一个点击的有效项设置为空
                                if (mShapeIndex >= 0) {
                                    var beforeData = mBeautyAdapter.getData(mShapeIndex)
                                    when (beforeData.buttonType) {
                                        FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                                            //算法值要设置为零，但是点击回来的时候需要根据UI值(缓存值)重新设置回算法值
                                            mSubItemUIValueCache[beforeData.key] = mDataFactory.getParamIntensity(beforeData.key, mModelAttributeRange[data.key]!!.default)
                                            mDataFactory.updateParamIntensity(beforeData.key, 0.0)
                                        }
                                    }
                                }
                                mDataFactory.setCurrentOneHotFaceShape(data.key)
                                mBeautyAdapter.notifyItemChanged(mShapeIndex)
                                mBeautyAdapter.notifyItemChanged(position)
                            }

                            //设置当前点击bean的进度值
                            val stand = mModelAttributeRange[data.key]!!.stand
                            val maxRange = mModelAttributeRange[data.key]!!.maxRange
                            seekToSeekBar(value, stand, maxRange)
                            mShapeIndex = position
                        }
                    }
                }
            }
        }, R.layout.list_item_control_title_image_circle)
    }

    /**
     * 美颜的单独开关设置 不更新缓存
     */
    private fun switchClick(switch: Switch) {
        openBeauty = !openBeauty
        switch.isChecked = openBeauty
        closeFace(openBeauty)
        //还原主项和子项
        mShapeBeauty.forEach {
            when (it.buttonType) {
                FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                    val default = mModelAttributeRange[it.key]!!.default
                    val value = if (openBeauty) mDataFactory.getParamIntensity(it.key, default) else mModelAttributeRange[it.key]!!.stand
                    mDataFactory.updateParamIntensity(it.key, value, false)
                }
            }
        }
    }

    // 关闭美型和美肤
    private fun closeFace(open: Boolean) {
        mDataFactory.openBeauty = open
    }

    /**
     * 绑定监听事件
     */
    private fun bindListener() {
        /*菜单控制*/
        bindBottomRadioListener()
        /*滑动条控制*/
        bindSeekBarListener()
        /*比对开关*/
        iv_compare.setOnTouchStateListener { v, event ->
            val action = event.action
            if (action == MotionEvent.ACTION_DOWN) {
                v.alpha = 0.7f
                mDataFactory.enableFaceBeauty(false)
            } else if (action == MotionEvent.ACTION_UP) {
                v.alpha = 1f
                mDataFactory.enableFaceBeauty(true)
            }
            true
        }

        bg_view.setOnClickListener { }

        /*还原数据*/
        tv_reset.setOnClickListener {
            showDialog(mContext.getString(R.string.dialog_reset_avatar_model)) {
                recoverFaceData()
                recoverFilterData()
            }
        }
        root_view.setOnClickListener { visibility = GONE }
    }


    /**
     * 滚动条绑定事件
     */
    private fun bindSeekBarListener() {
        beauty_seek_bar.setOnProgressChangeListener(object : DiscreteSeekBar.OnSimpleProgressChangeListener() {
            override fun onProgressChanged(seekBar: DiscreteSeekBar?, progress: Int, fromUser: Boolean) {
                if (!fromUser) {
                    return
                }
                val valueF = 1.0 * (progress - seekBar!!.min) / 100
                var seekBarProgress = beauty_seek_bar.progress
                when (beauty_radio_group.checkedCheckBoxId) {
                    R.id.beauty_radio_skin_beauty -> {
                        val bean = mSkinBeauty[mSkinIndex]
                        val range = mModelAttributeRange[bean.key]!!.maxRange
                        val stand = mModelAttributeRange[bean.key]!!.stand
                        val res = valueF * range
                        val value = mDataFactory.getParamIntensity(bean.key, mModelAttributeRange[bean.key]!!.default)
                        if (!DecimalUtils.doubleEquals(res, value)) {
                            mDataFactory.updateParamIntensity(bean.key, res)
                            updateBeautyItemUI(mBeautyAdapter.getViewHolderByPosition(mSkinIndex), bean)
                        }
                        if (stand == 0.5) {
                            seekBarProgress *= 2
                        }
                    }
                    R.id.beauty_radio_face_shape -> {
                        if (mShapeIndex < 0) return
                        val bean = mBeautyAdapter.getData(mShapeIndex)
                        when (bean.buttonType) {
                            FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                                //判断一下这个按钮的类型
                                val range = mModelAttributeRange[bean.key]!!.maxRange
                                val res = valueF * range
                                val value = mDataFactory.getParamIntensity(bean.key, mModelAttributeRange[bean.key]!!.default)
                                val stand = mModelAttributeRange[bean.key]!!.stand
                                if (!DecimalUtils.doubleEquals(res, value)) {
                                    mDataFactory.updateParamIntensity(bean.key, res)
                                    updateBeautyItemUI(mBeautyAdapter.getViewHolderByPosition(mShapeIndex), bean)
                                }
                                if (stand == 0.5) {
                                    seekBarProgress *= 2
                                }
                            }
                        }
                    }
                    R.id.beauty_radio_filter -> {
                        val bean = mFilters[mFiltersIndex]
                        if (!DecimalUtils.doubleEquals(bean.intensity, valueF)) {
                            bean.intensity = valueF
                            mDataFactory.updateFilterIntensity(bean.key, valueF)
                        }
                    }
                }

                setSeekBarText(seekBarProgress)
            }
        })
    }


    /**
     * 导航栏绑定监听事件，处理RecycleView等相关布局变更
     */
    private fun bindBottomRadioListener() {

        beauty_radio_group.setOnDispatchActionUpListener { x ->
            if (!mEnableBottomRationClick) {
                val width = beauty_radio_group.measuredWidth
                when {
                    x < width * 0.25 -> {
                        val toastStr = mContext.getString(R.string.beauty_face_style_toast, mContext.getString(R.string.beauty_radio_skin_beauty))
                        ToastHelper.showNormalToast(mContext, toastStr)
                    }
                    x < width * 0.5 -> {
                        val toastStr = mContext.getString(R.string.beauty_face_style_toast, mContext.getString(R.string.beauty_radio_face_shape))
                        ToastHelper.showNormalToast(mContext, toastStr)
                    }
                    x < width * 0.75f -> {
                        val toastStr = mContext.getString(R.string.beauty_face_style_toast, mContext.getString(R.string.beauty_radio_filter))
                        ToastHelper.showNormalToast(mContext, toastStr)
                    }
                }
            }
        }
        beauty_radio_filter.setOnClickListener {
            beauty_radio_group.check(R.id.beauty_radio_filter)
        }
        beauty_radio_face_shape.setOnClickListener {
            beauty_radio_group.check(R.id.beauty_radio_face_shape)
        }

        beauty_radio_group.setOnCheckedChangeListener { _, checkedId ->
            val layoutParams = select_line.layoutParams as LinearLayout.LayoutParams
            //视图变化
            when (checkedId) {
                R.id.beauty_radio_skin_beauty -> {
                    iv_compare.visibility = if (mEnableCompare) View.VISIBLE else View.GONE
                    ll_seek_bar.visibility = if (openBeauty && mShapeIndex != 0) View.VISIBLE else View.GONE
                    if (!isVertical) recycler_view.layoutManager = GridLayoutManager(mContext, 5)
                    select_line.apply {
                        layoutParams.gravity = Gravity.START
                        layoutParams.leftMargin = dpToPx(28)
                        layoutParams.rightMargin = 0
                    }
                }
                R.id.beauty_radio_face_shape -> {
                    iv_compare.visibility = if (mEnableCompare) View.VISIBLE else View.GONE
                    ll_seek_bar.visibility = if (openBeauty && mShapeIndex != 0) View.VISIBLE else View.GONE

                    if (!isVertical) recycler_view.layoutManager = GridLayoutManager(mContext, 5)
                    select_line.apply {
                        layoutParams.gravity = Gravity.START
                        layoutParams.leftMargin = dpToPx(22)
                    }
                }
                R.id.beauty_radio_filter -> {
                    if (!isVertical) recycler_view.layoutManager = GridLayoutManager(mContext, 4)
                    iv_compare.visibility = if (mEnableCompare) View.VISIBLE else View.GONE
                    ll_seek_bar.visibility = if (mFiltersIndex == 0) View.GONE else View.VISIBLE
                    select_line.apply {
                        layoutParams.gravity = Gravity.START
                        layoutParams.leftMargin = dpToPx(76)
                    }
                }
                R.id.beauty_radio_style -> {
                    if (!isVertical) recycler_view.layoutManager = GridLayoutManager(mContext, 4)
                    iv_compare.visibility = if (mEnableCompare) View.VISIBLE else View.GONE
                    ll_seek_bar.visibility = View.GONE
                }
                View.NO_ID -> {
                    iv_compare.visibility = View.GONE
                    mDataFactory.enableFaceBeauty(true)
                }

            }

            //数据变化
            when (checkedId) {
                R.id.beauty_radio_skin_beauty -> {
                    mBeautyAdapter.setData(mSkinBeauty)
                    recycler_view.adapter = mBeautyAdapter
                    val item = mSkinBeauty[mSkinIndex]
                    val value = mDataFactory.getParamIntensity(item.key, mModelAttributeRange[item.key]!!.default)
                    val stand = mModelAttributeRange[item.key]!!.stand
                    val maxRange = mModelAttributeRange[item.key]!!.maxRange
                    seekToSeekBar(value, stand, maxRange)
                    changeBottomLayoutAnimator(true)
                }
                R.id.beauty_radio_face_shape -> {
                    mBeautyAdapter.setData(mShapeBeauty)
                    recycler_view.adapter = mBeautyAdapter
                    if (mShapeIndex > 0) {
                        val item = mShapeBeauty[mShapeIndex]
                        val value = mDataFactory.getParamIntensity(item.key, mModelAttributeRange[item.key]!!.default)
                        val stand = mModelAttributeRange[item.key]!!.stand
                        val maxRange = mModelAttributeRange[item.key]!!.maxRange
                        seekToSeekBar(value, stand, maxRange)
                        changeBottomLayoutAnimator(true)
                    } else {
                        ll_seek_bar.visibility = View.GONE
                    }
                }
                R.id.beauty_radio_filter -> {
                    recycler_view.adapter = mFiltersAdapter
                    recycler_view.scrollToPosition(mFiltersIndex)
                    if (mFiltersIndex == 0) {
                        ll_seek_bar.visibility = View.GONE
                    } else {
                        val item = mFilters[mFiltersIndex]
                        seekToSeekBar(mDataFactory.getParamIntensity(item.key, item.intensity), 0.0, 1.0)
                    }
                    changeBottomLayoutAnimator(true)
                }
                R.id.beauty_radio_style -> {
                    recycler_view.adapter = mStylesAdapter
                    if (mDataFactory.currentStyleIndex > -1) {
                        recycler_view.scrollToPosition(mDataFactory.currentStyleIndex)
                    }
                    changeBottomLayoutAnimator(true)
                }
                View.NO_ID -> {
                    changeBottomLayoutAnimator(false)
                    mDataFactory.enableFaceBeauty(true)
                }

            }
        }
    }

    public fun setCompare(enable: Boolean) {
        mEnableCompare = enable
    }

    private fun setBottomCheckRatioEnable(enable: Boolean) {
        mEnableBottomRationClick = enable
        var i = 0
        val childCount: Int = beauty_radio_group.getChildCount()
        while (i < childCount) {
            val view: View = beauty_radio_group.getChildAt(i)
            if (view.id != R.id.beauty_radio_style) {
                view.alpha = if (enable) 1f else 0.6f
                view.isEnabled = enable
            }
            i++
        }
    }

    // endregion
    // region  业务处理


    /**
     * 设置滚动条数值
     * @param value Double 结果值
     * @param stand Double 标准值
     * @param range Double 范围区间
     */
    private fun seekToSeekBar(value: Double, stand: Double, range: Double) {
        if (stand == 0.5) {
            beauty_seek_bar.min = -50
            beauty_seek_bar.max = 50
            beauty_seek_bar.progress = (value * 100 / range - 50).toInt()
            setSeekBarText(beauty_seek_bar.progress * 2)
        } else {
            beauty_seek_bar.min = 0
            beauty_seek_bar.max = 100
            beauty_seek_bar.progress = (value * 100 / range).toInt()
            setSeekBarText(beauty_seek_bar.progress)
        }
        ll_seek_bar.visibility = View.VISIBLE
    }

    fun setSeekBarText(num: Int) {
        beauty_seek_bar_text.text = if (num >= 0) "+".plus(num.toString()) else num.toString()
    }

    /**
     * 更新单项是否为基准值显示
     */
    private fun updateBeautyItemUI(viewHolder: BaseViewHolder?, item: FaceBeautyBean) {
        val value = mDataFactory.getParamIntensity(item.key, mModelAttributeRange[item.key]!!.default)
        val stand = mModelAttributeRange[item.key]!!.stand
        if (DecimalUtils.doubleEquals(value, stand)) {
            viewHolder?.setImageResource(R.id.iv_control, item.closeRes)
        } else {
            viewHolder?.setImageResource(R.id.iv_control, item.openRes)
        }
    }


    /**
     * 遍历美肤数据确认还原按钮是否可以点击
     */
    private fun checkFaceSkinChanged(): Boolean {
        val item = mSkinBeauty[mSkinIndex]
        var default = mModelAttributeRange[item.key]!!.default
        var value = mDataFactory.getParamIntensity(item.key, default)
        if (!DecimalUtils.doubleEquals(value, default)) {
            return true
        }
        mSkinBeauty.forEach {
            default = mModelAttributeRange[it.key]!!.default
            value = mDataFactory.getParamIntensity(it.key, default)
            if (!DecimalUtils.doubleEquals(value, default)) {
                return true
            }
        }
        return false
    }

    /**
     * 遍历美型数据确认还原按钮是否可以点击
     */
    private fun checkFaceShapeChanged(): Boolean {
        if (checkFaceShapeChanged(mShapeBeauty) || checkFaceShapeChanged(mShapeBeautySubItem))
            return true
        return false
    }

    /**
     * 遍历美型数据确认还原按钮是否可以点击
     */
    private fun checkFaceShapeChanged(shapeBeauty: ArrayList<FaceBeautyBean>): Boolean {
        var value: Double
        var default: Double
        if (shapeBeauty.size > mShapeIndex) {
            var item = shapeBeauty[mShapeIndex]
            item?.let {
                default = mModelAttributeRange[item.key]!!.default
                value = mDataFactory.getParamIntensity(item.key, default)
                if (!DecimalUtils.doubleEquals(value, default)) {
                    return true
                }
            }
        }

        shapeBeauty.forEach {
            when (it.buttonType) {
                FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                    default = mModelAttributeRange[it.key]!!.default
                    value = mDataFactory.getParamIntensity(it.key, default)
                    if (!DecimalUtils.doubleEquals(value, default)) {
                        return true
                    }
                }
            }
        }

        return false
    }

    private fun recoverAllData() {
        recoverSkinData()
        recoverFaceData()
        recoverFilterData()
    }

    private fun recoverFilterData() {
        //还原子项
        mFiltersIndex = 1
        mDataFactory.currentFilterIndex = 1
        mFilters = mDataFactory.beautyFilters
        mFiltersAdapter.setData(mFilters)
        var value = 0.0
        var stand = 0.0
        var maxRange = 1.0
        mFilters.forEach {
            mDataFactory.updateCatchIntensity(it.key, it.intensity)
            value = it.intensity
        }

        if (beauty_radio_group.checkedCheckBoxId == R.id.beauty_radio_filter)
            seekToSeekBar(value, stand, maxRange)
    }

    private fun recoverFaceData() {
        if (mShapeIndex == 0 && !openBeauty)
            mShapeIndex = 1
        openBeauty = true
        mDataFactory.openBeauty = true
        //还原主项和子项
        mShapeBeauty.forEach {
            when (it.buttonType) {
                FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                    val default = mModelAttributeRange[it.key]!!.default
                    mDataFactory.updateParamIntensity(it.key, default)
                }
            }
        }

        //还原子项
        mShapeBeautySubItem.forEach {
            when (it.buttonType) {
                FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                    val default = mModelAttributeRange[it.key]!!.default
                    mDataFactory.updateParamIntensity(it.key, default)
                }
            }
        }

        //获取当前shapeAdapter中被选中的项
        var value = 0.0
        var stand = 0.0
        var maxRange = 1.0

        val item = mBeautyAdapter.getData(mShapeIndex)
        when (item.buttonType) {
            FaceBeautyBean.ButtonType.NORMAL_BUTTON -> {
                stand = mModelAttributeRange[item.key]!!.stand
                value = mModelAttributeRange[item.key]!!.default
                maxRange = mModelAttributeRange[item.key]!!.maxRange
            }
        }
        if (mShapeIndex != 0 && beauty_radio_group.checkedCheckBoxId == R.id.beauty_radio_face_shape)
            seekToSeekBar(value, stand, maxRange)
        mBeautyAdapter.setData(mShapeBeauty)
    }

    private fun recoverSkinData() {
        mSkinBeauty.forEach {
            val default = mModelAttributeRange[it.key]!!.default
            mDataFactory.updateParamIntensity(it.key, default)
        }
        val item = mSkinBeauty[mSkinIndex]
        val value = mDataFactory.getParamIntensity(item.key, mModelAttributeRange[item.key]!!.default)
        val stand = mModelAttributeRange[item.key]!!.stand
        val maxRange = mModelAttributeRange[item.key]!!.maxRange
        seekToSeekBar(value, stand, maxRange)
        mBeautyAdapter.notifyDataSetChanged()
    }

    /**
     * 底部动画处理
     * @param isOpen Boolean
     */
    private fun changeBottomLayoutAnimator(isOpen: Boolean) {
        if (isBottomShow == isOpen) {
            return
        }
        val start = if (isOpen) resources.getDimension(R.dimen.x1).toInt() else resources.getDimension(R.dimen.x268).toInt()
        val end = if (isOpen) resources.getDimension(R.dimen.x268).toInt() else resources.getDimension(R.dimen.x1).toInt()

        if (bottomLayoutAnimator != null && bottomLayoutAnimator!!.isRunning) {
            bottomLayoutAnimator!!.end()
        }
        bottomLayoutAnimator = ValueAnimator.ofInt(start, end).setDuration(150)
        bottomLayoutAnimator!!.addUpdateListener { animation ->
            val height = animation.animatedValue as Int
            if (onBottomAnimatorChangeListener != null) {
                val showRate = 1.0f * (height - start) / (end - start)
                onBottomAnimatorChangeListener?.onBottomAnimatorChangeListener(if (!isOpen) 1 - showRate else showRate)
            }
            if (DecimalUtils.floatEquals(animation.animatedFraction, 1.0f) && isOpen) {
                iv_compare.visibility = if (mEnableCompare) View.VISIBLE else View.GONE
            }
        }
        bottomLayoutAnimator!!.start()
        isBottomShow = isOpen
    }

    override fun onDetachedFromWindow() {
        //被销毁前，记录此时的UI值，用于下一次启动的时候恢复
        mSubItemUIValueCache.forEach {
            //应该要将UI值保存用于后续恢复

        }
        super.onDetachedFromWindow()
    }

    /* item入场动画总开关 */
    val openEnterAnimation = false

    /* 是否需要对该子项进行入场动画 */
    var needEnterAnimation = false

    /**
     * recycleView ITEM 子项入场动画
     */
    fun enterAnimation(view: View) {
        //动画集合
        val animSet = AnimationSet(false)
        //位移动画
        val translateAnim = TranslateAnimation(
                Animation.ABSOLUTE, 0f, Animation.ABSOLUTE, 0f,
                Animation.ABSOLUTE, 100f, Animation.ABSOLUTE, 0f)
        //渐变动画
        val alphaAnim = AlphaAnimation(0.0f, 1.0f)
        animSet.addAnimation(translateAnim)
        animSet.addAnimation(alphaAnim)
        animSet.duration = 300
        animSet.fillAfter = true
        animSet.addAnimation(alphaAnim)
        view.startAnimation(animSet)
    }
}
