/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.module.room;

import android.text.TextUtils;
import com.vhall.beautify.IVHBeautifyInitListener;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.business.core.VHEventManager;
import com.vhall.framework.VhallBaseSDK;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHNetCallback;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.httpclient.core.VHNetResponse;
import com.vhall.ims.VHIM;
import com.vhall.logmanager.VLog;
import com.vhall.message.ConnectServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.VssSdk;
import vhall.com.vss2.data.MessageData;
import vhall.com.vss2.data.ResponseAttributes;
import vhall.com.vss2.data.ResponseChatInfo;
import vhall.com.vss2.data.ResponseImMessageInfo;
import vhall.com.vss2.data.ResponseJe;
import vhall.com.vss2.data.ResponsePushInfo;
import vhall.com.vss2.data.ResponseRoomInfo;
import vhall.com.vss2.data.ResponseScrollingInfo;
import vhall.com.vss2.data.ResponseUserStatus;
import vhall.com.vss2.data.UserInfoData;
import vhall.com.vss2.data.VssMessageAnnouncementData;
import vhall.com.vss2.data.VssMessageChatData;
import vhall.com.vss2.data.VssMessageLotteryData;
import vhall.com.vss2.data.VssMessageQuestionData;
import vhall.com.vss2.data.VssMessageSignData;
import vhall.com.vss2.module.role.VssRoleManager;
import vhall.com.vss2.module.room.IRoomPresenter;
import vhall.com.vss2.module.room.callback.IVssCallBackListener;
import vhall.com.vss2.module.room.callback.IVssMessageListener;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.VHJSON;
import vhall.com.vss2.utils.exception.ApiException;
import vhall.com.vss2.utils.exception.CustomException;
import vhall.com.vss2.utils.rxutils.BasePresenter;

class RoomPresenter
extends BasePresenter
implements IRoomPresenter {
    private VHIM im;
    private final String TAG = "RoomPresenter";
    private IVssCallBackListener vssCallBackLister;
    private List<IVssMessageListener> messageListerList = new ArrayList<IVssMessageListener>();

    RoomPresenter() {
    }

    public ResponseRoomInfo getInfo() {
        return roomInfo;
    }

    private void getRoomInfo(String vssToken, String roomId, final CallBack<ResponseRoomInfo> callBack) {
        HashMap<String, String> bodyParams = this.getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(bodyParams).setUrl(this.createVssUrl("room/get")).build();
        VHNetApi.getNetApi().doPost(request, new IVHNetCallback(){

            public void onFailure(VHNetResponse response, Exception e) {
                if (callBack != null) {
                    ApiException exception = CustomException.handleException(response.getResponseCode(), e);
                    callBack.onError(exception.getCode(), exception.getMessage());
                }
            }

            public void response(VHNetResponse response) {
                if (response != null && !TextUtils.isEmpty((CharSequence)response.getResult())) {
                    ResponseJe<ResponseRoomInfo> responseJe = new ResponseJe<ResponseRoomInfo>(response.getResult(), ResponseRoomInfo.class);
                    if (responseJe.getCode() != 200) {
                        if (callBack != null) {
                            callBack.onError(responseJe.getCode(), responseJe.getMsg());
                        }
                        return;
                    }
                    roomInfo = responseJe.getData();
                    if (roomInfo == null) {
                        if (callBack != null) {
                            callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                        }
                        return;
                    }
                    UserInfoData userInfo = VHJSON.parseObject(VhallSDK.getInstance().getmUserInfo(), UserInfoData.class);
                    if (userInfo == null) {
                        userInfo = new UserInfoData();
                        userInfo.setAvatar(VssSdk.getInstance().getAvatar());
                        userInfo.setNick_name(VssSdk.getInstance().getNickName());
                        userInfo.setNickname(VssSdk.getInstance().getNickName());
                    }
                    userInfo.setThird_party_user_id(roomInfo.getThird_party_user_id());
                    userInfo.setRole_name(roomInfo.getRole_name());
                    userInfo.setDevice_type("3");
                    userInfo.setDevice_status("1");
                    final UserInfoData finalUserInfo = userInfo;
                    final UserInfoData finalUserInfo1 = userInfo;
                    RoomPresenter.this.getAttributes(new CallBack<ResponseAttributes>(){

                        @Override
                        public void onSuccess(ResponseAttributes result) {
                            if (roomInfo == null) {
                                if (callBack != null) {
                                    callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                                }
                                return;
                            }
                            roomInfo.setAttributes(result);
                            RoomPresenter.this.getUserStatus(new CallBack<ResponseUserStatus>(){

                                @Override
                                public void onSuccess(ResponseUserStatus result) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                                        }
                                        return;
                                    }
                                    if (result == null) {
                                        VssSdk.getInstance().setUserInfo(finalUserInfo);
                                        callBack.onSuccess(roomInfo);
                                        return;
                                    }
                                    roomInfo.setUserStatus(result);
                                    finalUserInfo.setIs_banned(result.getIs_banned());
                                    VssSdk.getInstance().setUserInfo(finalUserInfo);
                                    callBack.onSuccess(roomInfo);
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                                        }
                                        return;
                                    }
                                    roomInfo.setUserStatus(new ResponseUserStatus());
                                    finalUserInfo.setIs_banned("0");
                                    VssSdk.getInstance().setUserInfo(finalUserInfo);
                                    callBack.onSuccess(roomInfo);
                                }
                            });
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                            if (roomInfo == null) {
                                if (callBack != null) {
                                    callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                                }
                                return;
                            }
                            roomInfo.setAttributes(new ResponseAttributes());
                            RoomPresenter.this.getUserStatus(new CallBack<ResponseUserStatus>(){

                                @Override
                                public void onSuccess(ResponseUserStatus result) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                                        }
                                        return;
                                    }
                                    if (result == null) {
                                        VssSdk.getInstance().setUserInfo(finalUserInfo1);
                                        callBack.onSuccess(roomInfo);
                                        return;
                                    }
                                    roomInfo.setUserStatus(result);
                                    finalUserInfo1.setIs_banned(result.getIs_banned());
                                    VssSdk.getInstance().setUserInfo(finalUserInfo1);
                                    callBack.onSuccess(roomInfo);
                                }

                                @Override
                                public void onError(int eventCode, String msg) {
                                    if (roomInfo == null) {
                                        if (callBack != null) {
                                            callBack.onError(-1, "\u623f\u95f4\u4fe1\u606f\u52a0\u8f7d\u5931\u8d25");
                                        }
                                        return;
                                    }
                                    roomInfo.setUserStatus(new ResponseUserStatus());
                                    finalUserInfo1.setIs_banned("0");
                                    VssSdk.getInstance().setUserInfo(finalUserInfo1);
                                    callBack.onSuccess(roomInfo);
                                }
                            });
                        }
                    });
                } else if (callBack != null) {
                    callBack.onError(-1, "room data error");
                }
            }
        });
    }

    public void roomGetPushInfo(String status, CallBack<ResponsePushInfo> callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> bodyParams = this.getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(bodyParams).setUrl(this.createVssUrl("room/get-push-info")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponsePushInfo>(callBack, ResponsePushInfo.class));
    }

    @Override
    public void roomStartLive(CallBack<String> callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 2);
        params.put("start_type", "3");
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("room/start-live")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void setKicked(String receiveJoinId, String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canChatKickOut()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8e22\u51fa\u6216\u53d6\u6d88\u8e22\u51fa\u6743\u9650");
            }
            VLog.e((String)"RoomPresenter", (String)"\u6ca1\u6709\u8e22\u51fa\u6216\u53d6\u6d88\u8e22\u51fa\u6743\u9650");
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_account_id", receiveJoinId);
        params.put("status", status);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-kicked")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void setMainScreen(String receiveJoinId, String joinId, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_join_id", receiveJoinId);
        params.put("join_id", joinId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-main-screen")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void setDocPermission(String receiveJoinId, String joinId, CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocwhiteBoard()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u8bbe\u7f6e\u6587\u6863\u767d\u677f\u6743\u9650\u6743\u9650");
            }
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("receive_join_id", receiveJoinId);
        params.put("join_id", joinId);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-doc-permission")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void sendNotice(String content, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(null, roomId, 2);
        params.put("content", content);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/send-notice")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void getUserStatus(CallBack<ResponseUserStatus> callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("account_id", roomInfo.getThird_party_user_id());
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/get-user-status")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseUserStatus>(callBack, ResponseUserStatus.class));
    }

    @Override
    public void roomEndLive(CallBack<String> callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            if (callBack != null) {
                callBack.onError(-1, "NO enter room");
            }
            return;
        }
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 2);
        params.put("end_type", "3");
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("room/end-live")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void roomSwitchDoc(String status, CallBack callBack) {
        if (!VssRoleManager.getInstance().canDocSwitch()) {
            if (callBack != null) {
                callBack.onError(1001, "\u6ca1\u6709\u6587\u6863\u5f00\u5173\u63a7\u5236\u6743\u9650");
            }
            VLog.e((String)"RoomPresenter", (String)"\u6ca1\u6709\u6587\u6863\u5f00\u5173\u63a7\u5236\u6743\u9650");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)vssToken) || TextUtils.isEmpty((CharSequence)roomId)) {
            callBack.onError(-1, "NO enter room");
            return;
        }
        HashMap<String, String> bodyParams = this.getDefaultParam(vssToken, roomId, 3);
        bodyParams.put("status", status);
        IVHRequest request = new IVHRequest.Builder().addFormParas(bodyParams).setUrl(this.createVssUrl("room/switch-doc")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void leaveRoom() {
        if (this.im != null) {
            this.im.leave();
            this.im = null;
        }
        this.messageListerList.clear();
        roomInfo = null;
        vssToken = null;
        roomId = null;
    }

    public void enterRoom(String vssToken1, String roomId1, final CallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)vssToken1) || TextUtils.isEmpty((CharSequence)roomId1)) {
            if (callBack != null) {
                callBack.onError(-1, "data error");
            }
            return;
        }
        vssToken = vssToken1;
        roomId = roomId1;
        this.getRoomInfo(vssToken, roomId, new CallBack<ResponseRoomInfo>(){

            @Override
            public void onSuccess(ResponseRoomInfo result) {
                roomInfo = result;
                try {
                    VhallBaseSDK.getInstance().initBeautify(result.getPaas_access_token(), new IVHBeautifyInitListener(){

                        public void onSuccess() {
                            VHBeautifyKit.getInstance().setBeautifyEnable(true);
                            VLog.v((String)"initBeautify", (String)"onSuccess");
                            VHEventManager.share().notifyEvent(301, "initBeautify onSuccess", "", null);
                        }

                        public void onError(int i, String s) {
                            VLog.e((String)"initBeautify", (String)("onError  msg:   " + s));
                            VHEventManager.share().notifyEvent(i, s, "", null);
                        }
                    });
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                if (RoomPresenter.this.im == null) {
                    RoomPresenter.this.im = new VHIM(result.getChannel_id(), result.getPaas_access_token());
                    RoomPresenter.this.im.setOnMessageListener((VHIM.OnMessageListener)new MsgListener());
                    RoomPresenter.this.im.setOnConnectChangedListener(new VhallConnectService.OnConnectStateChangedListener(){

                        public void onStateChanged(ConnectServer.State state, int i) {
                            if (RoomPresenter.this.vssCallBackLister != null) {
                                RoomPresenter.this.vssCallBackLister.onStateChanged(state, i);
                            }
                        }
                    });
                    RoomPresenter.this.im.join();
                }
                RoomPresenter.this.setDevice("1", "1", null);
                if (!VssRoleManager.getInstance().isOpenRole()) {
                    VssRoleManager.getInstance().getAccessList(roomInfo.getThird_party_user_id(), roomInfo.getRole_name(), new CallBack<List<Integer>>(){

                        @Override
                        public void onSuccess(List<Integer> result) {
                        }

                        @Override
                        public void onError(int eventCode, String msg) {
                            VLog.e((String)"RoomPresenter", (String)("getAccessList onError:   " + msg));
                        }
                    });
                }
                if (callBack != null) {
                    callBack.onSuccess(result);
                }
            }

            @Override
            public void onError(int eventCode, String msg) {
                if (msg != null && msg.contains("Can not perform")) {
                    return;
                }
                if (callBack != null) {
                    callBack.onError(eventCode, msg);
                }
            }
        });
    }

    @Override
    public void setVssCallBackLister(IVssCallBackListener listener) {
        if (this.im != null) {
            this.vssCallBackLister = listener;
        } else {
            VLog.e((String)"RoomPresenter", (String)"No enter room");
        }
    }

    @Override
    public void getScrollingInfo(CallBack<ResponseScrollingInfo> callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("scrolling/info")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseScrollingInfo>(callBack, ResponseScrollingInfo.class));
    }

    @Override
    public void getAttributes(CallBack<ResponseAttributes> callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 2);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("room/get-attributes")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback<ResponseAttributes>(callBack, ResponseAttributes.class));
    }

    public void setDevice(String status, String type, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("status", status);
        params.put("type", type);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("inav/set-device")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    @Override
    public void sendMsg(String msg, String type, final CallBack callBack) {
        if (TextUtils.isEmpty((CharSequence)type)) {
            type = "text";
        }
        if (this.im != null) {
            if ("service_custom".equals(type)) {
                this.im.sendCustomMsg(msg, new VHIM.Callback(){

                    public void onSuccess() {
                        if (callBack != null) {
                            callBack.onSuccess(null);
                        }
                    }

                    public void onFailure(int i, String s) {
                        if (callBack != null) {
                            callBack.onError(i, s);
                        }
                    }
                });
                return;
            }
            this.im.sendMsg(msg, type, new VHIM.Callback(){

                public void onSuccess() {
                    if (callBack != null) {
                        callBack.onSuccess(null);
                    }
                }

                public void onFailure(int i, String s) {
                    if (callBack != null) {
                        callBack.onError(i, s);
                    }
                }
            });
        } else if (callBack != null) {
            callBack.onError(-1, "\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public void sendImageMsg(String text, List<String> imageUrls, final CallBack callBack) {
        if (this.im != null) {
            this.im.sendImageText(text, imageUrls, new VHIM.Callback(){

                public void onSuccess() {
                    if (callBack != null) {
                        callBack.onSuccess(null);
                    }
                }

                public void onFailure(int i, String s) {
                    if (callBack == null) {
                        return;
                    }
                    callBack.onError(i, s);
                }
            });
        } else {
            if (callBack == null) {
                return;
            }
            callBack.onError(-1, "\u521d\u59cb\u5316\u5931\u8d25");
        }
    }

    @Override
    public void setVssMessageListener(IVssMessageListener iVssMessageListener) {
        this.messageListerList.add(iVssMessageListener);
    }

    public void removeVssMessageListener(IVssMessageListener iVssMessageListener) {
        this.messageListerList.remove(iVssMessageListener);
    }

    class MsgListener
    implements VHIM.OnMessageListener {
        MsgListener() {
        }

        public void onMessage(String msg) {
            if (TextUtils.isEmpty((CharSequence)msg)) {
                return;
            }
            try {
                ResponseImMessageInfo responseImMessageInfo = VHJSON.parseObject(msg, ResponseImMessageInfo.class);
                if (TextUtils.isEmpty((CharSequence)responseImMessageInfo.getData()) || TextUtils.isEmpty((CharSequence)responseImMessageInfo.getService_type())) {
                    return;
                }
                this.dealMessage(responseImMessageInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void onChannelStatus(String s) {
        }

        private void sendMessage(String type, Object data, ResponseImMessageInfo responseImMessageInfo) {
            if (RoomPresenter.this.messageListerList != null && RoomPresenter.this.messageListerList.size() > 0) {
                for (IVssMessageListener iVssMessageListener : RoomPresenter.this.messageListerList) {
                    if (iVssMessageListener == null) continue;
                    iVssMessageListener.onMessage(new MessageData(type, data, responseImMessageInfo));
                }
            }
        }

        private void dealMessage(ResponseImMessageInfo responseImMessageInfo) {
            try {
                String type;
                JSONObject objData;
                JSONObject objCon = null;
                if (!TextUtils.isEmpty((CharSequence)responseImMessageInfo.getContext())) {
                    objCon = new JSONObject(responseImMessageInfo.getContext());
                }
                try {
                    objData = new JSONObject(responseImMessageInfo.getData());
                    type = objData.optString("type");
                }
                catch (Exception e) {
                    objData = null;
                    type = "-1";
                }
                String id = "";
                block8 : switch (responseImMessageInfo.getService_type()) {
                    case "service_im": {
                        switch (type) {
                            case "disable": {
                                id = objData.optString("target_id");
                                if (roomInfo != null && TextUtils.equals((CharSequence)roomInfo.getThird_party_user_id(), (CharSequence)id)) {
                                    roomInfo.getUserStatus().setIs_banned("1");
                                }
                                this.sendMessage(type, null, responseImMessageInfo);
                                break block8;
                            }
                            case "permit": {
                                id = objData.optString("target_id");
                                if (roomInfo != null && TextUtils.equals((CharSequence)roomInfo.getThird_party_user_id(), (CharSequence)id)) {
                                    roomInfo.getUserStatus().setIs_banned("0");
                                }
                                this.sendMessage(type, null, responseImMessageInfo);
                                break block8;
                            }
                            case "disable_all": {
                                if (roomInfo != null && TextUtils.equals((CharSequence)roomInfo.getThird_party_user_id(), (CharSequence)id)) {
                                    roomInfo.getAttributes().setAll_banned("1");
                                }
                                this.sendMessage(type, null, responseImMessageInfo);
                                break block8;
                            }
                            case "permit_all": {
                                if (roomInfo != null && TextUtils.equals((CharSequence)roomInfo.getThird_party_user_id(), (CharSequence)id)) {
                                    roomInfo.getAttributes().setAll_banned("0");
                                }
                                this.sendMessage(type, null, responseImMessageInfo);
                                break block8;
                            }
                            case "image": 
                            case "text": {
                                JSONArray image_urls;
                                VssMessageChatData chatData = new VssMessageChatData();
                                ArrayList<ResponseChatInfo.ContextBean.AtListBean> atList = new ArrayList();
                                if (objCon != null) {
                                    JSONArray atListArray;
                                    String replyMsg;
                                    chatData.setAvatar(objCon.optString("avatar"));
                                    chatData.setRoom_id(objCon.optString("room_id"));
                                    chatData.setRoleName(objCon.optString("role_name"));
                                    if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                                        chatData.setNickname(objCon.optString("nickname"));
                                    }
                                    if (TextUtils.isEmpty((CharSequence)chatData.getNickname())) {
                                        chatData.setNickname(objCon.optString("nick_name"));
                                    }
                                    if (!TextUtils.isEmpty((CharSequence)(replyMsg = objCon.optString("replyMsg").trim())) && !replyMsg.startsWith("[") && replyMsg.startsWith("{")) {
                                        VssMessageChatData.ReplyMsgBean replyMsgBean = VHJSON.parseObject(replyMsg, VssMessageChatData.ReplyMsgBean.class);
                                        chatData.setReplyMsg(replyMsgBean);
                                    }
                                    if ((atListArray = objCon.optJSONArray("atList")) != null && atListArray.length() > 0) {
                                        atList = (List)VHJSON.parseObject(atListArray.toString(), new ArrayList<ResponseChatInfo.ContextBean.AtListBean>(){}.getClass());
                                        chatData.setAtlist(atList);
                                    }
                                }
                                if ((image_urls = objData.optJSONArray("image_urls")) != null) {
                                    ArrayList<String> urls = new ArrayList<String>();
                                    for (int i = 0; i < image_urls.length(); ++i) {
                                        urls.add(image_urls.get(i).toString());
                                    }
                                    chatData.setImage_urls(urls);
                                }
                                chatData.setTime(responseImMessageInfo.getDate_time());
                                chatData.setType(type);
                                String textContent = objData.optString("text_content");
                                if (atList.size() > 0) {
                                    for (ResponseChatInfo.ContextBean.AtListBean bean : atList) {
                                        textContent = textContent.replace("***" + bean.getNickName(), "@" + bean.getNickName());
                                    }
                                }
                                chatData.setText_content(textContent);
                                chatData.setImage_url(objData.optString("image_url"));
                                chatData.setUserId(responseImMessageInfo.getSender_id());
                                chatData.setMy(responseImMessageInfo.getSender_id().equals(roomInfo.getThird_party_user_id()));
                                this.sendMessage(type, chatData, responseImMessageInfo);
                                break block8;
                            }
                        }
                        this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                        break;
                    }
                    case "service_custom": {
                        VssMessageChatData chatData = new VssMessageChatData();
                        if (objCon != null) {
                            chatData.setAvatar(objCon.optString("avatar"));
                            chatData.setRoom_id(objCon.optString("room_id"));
                            chatData.setRoleName(objCon.optString("role_name"));
                            if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                                chatData.setNickname(objCon.optString("nickname"));
                            } else {
                                chatData.setNickname(objCon.optString("nick_name"));
                            }
                            chatData.setRoleName(objCon.optString("role_name"));
                        }
                        chatData.setTime(responseImMessageInfo.getDate_time());
                        chatData.setType("text");
                        chatData.event = "custom_broadcast";
                        chatData.setText_content(responseImMessageInfo.getData());
                        chatData.setUserId(responseImMessageInfo.getSender_id());
                        chatData.setMy(responseImMessageInfo.getSender_id().equals(roomInfo.getThird_party_user_id()));
                        this.sendMessage("service_custom", chatData, responseImMessageInfo);
                        break;
                    }
                    case "service_online": {
                        String hide = objData.optString("hide");
                        JSONObject online = new JSONObject();
                        online.put("time", (Object)responseImMessageInfo.getDate_time());
                        online.put("id", (Object)responseImMessageInfo.getSender_id());
                        online.put("hide", (Object)objData.optString("hide"));
                        if (objCon != null) {
                            if (!TextUtils.isEmpty((CharSequence)objCon.optString("nickname"))) {
                                online.put("name", (Object)objCon.optString("nickname"));
                            } else {
                                online.put("name", (Object)objCon.optString("nick_name"));
                            }
                            online.put("avatar", (Object)objCon.optString("avatar"));
                        }
                        this.sendMessage(type, online, responseImMessageInfo);
                        break;
                    }
                    case "service_room": {
                        switch (type) {
                            case "lottery_push": 
                            case "lottery_result_notice": {
                                this.dealLottery(responseImMessageInfo, type);
                                break block8;
                            }
                            case "sign_in_push": {
                                this.dealData(responseImMessageInfo, type, VssMessageSignData.class);
                                break block8;
                            }
                            case "room_announcement": {
                                this.dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                break block8;
                            }
                            case "question_answer_open": {
                                this.dealData(responseImMessageInfo, type, VssMessageAnnouncementData.class);
                                break block8;
                            }
                            case "question_answer_create": 
                            case "question_answer_commit": {
                                this.dealData(responseImMessageInfo, type, VssMessageQuestionData.class);
                                break block8;
                            }
                            case "questionnaire_push": 
                            case "questionnaire_repush": {
                                String questionnaire_id = objData.optString("questionnaire_id");
                                JSONObject question = new JSONObject();
                                question.put("questionnaire_id", (Object)questionnaire_id);
                                this.sendMessage(type, question, responseImMessageInfo);
                                break block8;
                            }
                            case "vrtc_connect_apply": 
                            case "vrtc_connect_apply_cancel": 
                            case "vrtc_connect_invite_refused": 
                            case "vrtc_connect_success": {
                                JSONObject apply = new JSONObject();
                                apply.put("nick_name", (Object)objData.optString("nick_name"));
                                apply.put("user_id", (Object)objData.optString("room_join_id"));
                                this.sendMessage(type, apply, responseImMessageInfo);
                                break block8;
                            }
                            case "vrtc_connect_invite": 
                            case "room_kickout": 
                            case "vrtc_connect_agree": 
                            case "vrtc_connect_refused": {
                                id = objData.optString("target_id");
                                this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break block8;
                            }
                            case "vrtc_frames_forbid": 
                            case "vrtc_mute_cancel": 
                            case "vrtc_mute": 
                            case "vrtc_frames_display": 
                            case "vrtc_disconnect_success": {
                                this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                                break block8;
                            }
                        }
                        this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                        break;
                    }
                    default: {
                        this.sendMessage(type, responseImMessageInfo, responseImMessageInfo);
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void dealData(ResponseImMessageInfo responseImMessageInfo, String type, Class c) {
            Object data = VHJSON.parseObject(responseImMessageInfo.getData(), c);
            if (data != null) {
                this.sendMessage(type, data, responseImMessageInfo);
            }
        }

        private void dealLottery(ResponseImMessageInfo responseImMessageInfo, String type) {
            VssMessageLotteryData lotteryData = VHJSON.parseObject(responseImMessageInfo.getData(), VssMessageLotteryData.class);
            if (lotteryData != null) {
                List<VssMessageLotteryData.LotteryWinnersBean> lottery_winners = lotteryData.getLottery_winners();
                if (lottery_winners != null && lottery_winners.size() > 0) {
                    for (int i = 0; i < lottery_winners.size(); ++i) {
                        VssMessageLotteryData.LotteryWinnersBean lotteryWinnersBean = lottery_winners.get(i);
                        if (lotteryWinnersBean.getLottery_user_id().equals(roomInfo.getThird_party_user_id())) {
                            lotteryWinnersBean.setSelf(true);
                            continue;
                        }
                        lotteryWinnersBean.setSelf(false);
                    }
                }
                this.sendMessage(type, lotteryData, responseImMessageInfo);
            }
        }
    }
}

