/*
 * Decompiled with CFR 0.152.
 */
package vhall.com.vss2.module.lottery;

import android.text.TextUtils;
import com.vhall.httpclient.api.VHNetApi;
import com.vhall.httpclient.core.IVHRequest;
import com.vhall.logmanager.VLog;
import java.util.HashMap;
import vhall.com.vss2.CallBack;
import vhall.com.vss2.net.VssNetCallback;
import vhall.com.vss2.utils.rxutils.BasePresenter;

public class VssLotteryManager
extends BasePresenter {
    private static volatile VssLotteryManager instance;
    private static String TAG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VssLotteryManager getInstance() {
        if (roomInfo == null) {
            VLog.e((String)TAG, (String)"room data error");
        }
        if (instance != null) return instance;
        Class<VssLotteryManager> clazz = VssLotteryManager.class;
        synchronized (VssLotteryManager.class) {
            if (instance != null) return instance;
            instance = new VssLotteryManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void lotteryAdd(String lottery_type, String lottery_number, String lottery_user_ids, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 5);
        params.put("lottery_type", lottery_type);
        params.put("lottery_number", lottery_number);
        params.put("lottery_user_ids", lottery_user_ids);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/add")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void lotteryEnd(String lottery_id, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("lottery_id", lottery_id);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/end")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void lotteryUsersGet(String lottery_id, String offset, String limit, String sort_type, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 6);
        params.put("lottery_id", lottery_id);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort_type", sort_type);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/users-get")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void lotteryGet(String lottery_type, String offset, String limit, String sort_type, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 6);
        params.put("lottery_type", lottery_type);
        params.put("offset", offset);
        params.put("limit", limit);
        params.put("sort_type", sort_type);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/get")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void lotteryAward(String lottery_id, String lottery_user_name, String lottery_user_phone, String lottery_user_remark, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 6);
        params.put("lottery_id", lottery_id);
        params.put("lottery_user_name", lottery_user_name);
        params.put("lottery_user_phone", lottery_user_phone);
        if (!TextUtils.isEmpty((CharSequence)lottery_user_remark)) {
            params.put("lottery_user_remark", lottery_user_remark);
        }
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/award")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void lotteryCount(String lottery_type, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 3);
        params.put("lottery_type", lottery_type);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/count")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    public void lotterySearch(String lottery_type, String keyword, CallBack callBack) {
        HashMap<String, String> params = this.getDefaultParam(vssToken, roomId, 4);
        params.put("keyword", keyword);
        params.put("lottery_type", lottery_type);
        IVHRequest request = new IVHRequest.Builder().addFormParas(params).setUrl(this.createVssUrl("lottery/search")).build();
        VHNetApi.getNetApi().doPost(request, new VssNetCallback(callBack));
    }

    static {
        TAG = "VssLotteryManager";
    }
}

